#ifndef BRLIBRAR_H
#define BRLIBRAR_H
//========================================================================================
//
//     File:			BRLibrar.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/27/90
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRMODULE_H
#include "BRModule.h"
#endif    BRMODULE_H

#ifndef   BRMEMMGR_H
#include "BRMemMgr.h"
#endif    BRMEMMGR_H


//========================================================================================
//	CLASS BR_CLibrary
//========================================================================================

class BR_CLibrary : public BR_CModule
{
public:
	BR_CLibrary(BR_TString<BR_Char>& libraryName);
	BR_CLibrary(BR_CFileSpecification& libraryFileSpec);
	virtual ~BR_CLibrary();

private:
	void InitLibrary(BR_CFileSpecification& libraryFileSpec);
	
	
#ifdef BR_BUILD_MAC
private:
	short fMacResourceRefNum;
#endif

	BR_SETCLASSNAME(BR_CLibrary);
};


//========================================================================================
// EXCEPTION BR_XLibrary - BR_CLibrary ctor failed.
//========================================================================================

class BR_XLibrary : public BR_XBedException
{
public:
	BR_XLibrary();
	BR_XLibrary(PlatformError fError);
	virtual ~BR_XLibrary();
	_BR_EXCEPTION_DEFINE(BR_XLibrary);
};


//========================================================================================
// EXCEPTION BR_XLibraryNotFound - BR_CLibrary ctor failed because file not found.
//========================================================================================

class BR_XLibraryNotFound : public BR_XLibrary
{
public:
	BR_XLibraryNotFound();
	BR_XLibraryNotFound(PlatformError fError);
	virtual ~BR_XLibraryNotFound();
	_BR_EXCEPTION_DEFINE(BR_XLibraryNotFound);
};


//========================================================================================
// EXCEPTION BR_XLibraryMemoryExhausted - Memory exhausted during resource loading or BR_CLibrary ctor.
//========================================================================================

class BR_XLibraryMemoryExhausted :public BR_XMemoryExhausted
{
public:
	BR_XLibraryMemoryExhausted();
	virtual ~BR_XLibraryMemoryExhausted();
	_BR_EXCEPTION_DEFINE(BR_XLibraryMemoryExhausted);
};

#endif
