#if !defined(BRINFILE_H) && !defined(__BEDRC__)
#define BRINFILE_H
//========================================================================================
//
//     File:		BRInFile.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/21/91
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRCHRSTR_H
#include "BRChrStr.h"
#endif

#ifndef BRFILESP_H
#include "BRFileSp.h"
#endif



//========================================================================================
//	BR_CInitializationFile
//
//	Provides a protocol for storing application settings in a default file.  For Windows,
//		this is the application.INI file.  On Macintosh, this is a Preferences file in the
//		System Preferences Folder.
//	<Invariants>
//========================================================================================
class BR_CInitializationFile
{
	typedef BR_CharacterPosition Index;

public:
	BR_CInitializationFile(BR_Boolean keepFilePrivate = FALSE);
	~BR_CInitializationFile();				// Should be virtual?!

	void UseIniFile(const BR_CFileSpecification& fileSpec);

	BR_Boolean GetValue(const BR_TString<BR_Char>& topic,
						const BR_TString<BR_Char>& key,
						BR_TString<BR_Char>& Value) const;

	BR_Boolean GetValue(const BR_TString<BR_Char>& topic,
						const BR_TString<BR_Char>& key,
						long& longValue) const;

	BR_Boolean SetValue(const BR_TString<BR_Char>& topic,
						const BR_TString<BR_Char>& key,
						const BR_TString<BR_Char>& Value);

	BR_Boolean SetValue(const BR_TString<BR_Char>& topic,
						const BR_TString<BR_Char>& key,
						long longValue);

	BR_Boolean GetKeyList(const BR_TString<BR_Char>& topic,
						  BR_CStringList& keyList) const;

private:

#ifdef BR_BUILD_MAC
	BR_Boolean FindTopic(const BR_TString<BR_Char>& searchString,
						 Index &foundAtIndex) const;
	BR_Boolean FindKey(const BR_TString<BR_Char>& searchString,
					   Index &foundAtIndex,
					   Index startIndex) const;

	BR_CDynamicCharString fBuffer;
	BR_Boolean fDirty;							// indicates if settings have changed
#endif

	BR_Boolean fSystem;							// Use WIN.INI
	BR_CFileSpecification* fFileSpec;

};





#endif
