#if !defined(BRICON_H) && !defined(__BEDRC__)
#define BRICON_H
//========================================================================================
//
//     File:		BRIcon.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/17/90
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRRECT_H
#include "BRRect.h"
#endif

#ifndef BRCURSOR_H
#include "BRCursor.h"
#endif

//========================================================================================
//	BR_CIcon
//
//	A class used to load icons.
//========================================================================================

class BR_CIcon : public BR_CObject
{
public:
	BR_CIcon(const BR_CModule& module,
			 BR_ResourceId resourceId);
	virtual~ BR_CIcon();

	virtual void GetSize(BR_CPoint& size) const;

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	BR_CIcon(LPSTR systemIconId);

	HICON GetHandle() const;
	void SetHandle(HICON hNew);

	void SetIsStock(BR_Boolean state);
	BR_Boolean IsStock();

private:
	HICON fIcon;
	BR_Boolean fIsStock;
#endif

	//----------------------------------------------------------------------------------------
	// Macintosh
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	BR_CIcon(BR_ResourceId systemIconResId);

	Handle GetHandle() const;
	void SetHandle(Handle hNew);

	void SetIsColor(BR_Boolean state);
	BR_Boolean IsColor() const;

private:
	Handle fIcon;
	BR_Boolean fIsColor;
#endif

	BR_SETCLASSNAME(BR_CIcon);
};

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CIcon::GetHandle
//----------------------------------------------------------------------------------------
inline HICON BR_CIcon::GetHandle() const
{
	return fIcon;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CIcon::SetHandle
//----------------------------------------------------------------------------------------
inline void BR_CIcon::SetHandle(HICON hNew)
{
	fIcon = hNew;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CIcon::SetIsStock
//----------------------------------------------------------------------------------------
inline void BR_CIcon::SetIsStock(BR_Boolean state)
{
	fIsStock = state;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CIcon::IsStock
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CIcon::IsStock()
{
	return fIsStock;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CIcon::GetHandle
//----------------------------------------------------------------------------------------
inline Handle BR_CIcon::GetHandle() const
{
	return fIcon;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CIcon::SetHandle
//----------------------------------------------------------------------------------------
inline void BR_CIcon::SetHandle(Handle hNew)
{
	fIcon = hNew;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CIcon::SetIsColor
//----------------------------------------------------------------------------------------
inline void BR_CIcon::SetIsColor(BR_Boolean state)
{
	fIsColor = state;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CIcon::IsColor
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CIcon::IsColor() const
{
	return fIsColor;
}
#endif

//========================================================================================
//	BR_CDocumentIcon
//
//	A class used to load and store icons associated with documents
//========================================================================================

class BR_CDocumentIcon : public BR_CIcon
{
public:
	BR_CDocumentIcon(const BR_CModule& module,
					 BR_ResourceId resId);
	virtual~ BR_CDocumentIcon();

	// Return this instance's icon
	const BR_CCursor* GetCursor() const;

private:
	// The loaded icon is placed in here
	BR_CCursor fCursor;

	BR_SETCLASSNAME(BR_CDocumentIcon);
};

//----------------------------------------------------------------------------------------
// BR_CIcon::GetCursor
//----------------------------------------------------------------------------------------
inline const BR_CCursor* BR_CDocumentIcon::GetCursor() const 
{
	return &fCursor;
}

#endif


