#if !defined(BRGRID_H) && !defined(__BEDRC__)
#define BRGRID_H
//========================================================================================
//
//     File:		BRGrid.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	10/29/90
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRVIEW_H
#include "BRView.h"
#endif


//========================================================================================
//	BR_CGrid
//========================================================================================
class BR_CGrid : public BR_CView
{
public:
	typedef unsigned short int GridRowNumber;
	typedef unsigned short int GridColumnNumber;
	typedef unsigned short int GridRowCount;
	typedef unsigned short int GridColumnCount;

	BR_CGrid(BR_CView* enclosure,
			 BR_CBureaucrat* supervisor,
			 BR_Distance width,
			 BR_Distance height,
			 BR_Coordinate fX,
			 BR_Coordinate fY,
			 ViewSizing horizontalSizing,
			 ViewSizing verticalSizing,
			 ViewUnits viewUnits);

	BR_CGrid(BR_CView* enclosure,
			 BR_CBureaucrat* supervisor,
			 const BR_CModule& resourceModule,
			 BR_SResource& viewResource);

	virtual~ BR_CGrid();

	GridColumnCount GetColumns() const;
	GridRowCount GetRows() const;

	// New virtual methods
	virtual BR_Boolean GetCell(const BR_CPoint& mousePoint,
							   GridRowNumber& rowNumber,
							   GridColumnNumber& columnNumber) const;
	virtual BR_Boolean GetCellRect(BR_CRectangle& cellRectangle,
								   GridRowNumber rowNumber,
								   GridColumnNumber columnNumber) const;
	virtual void DoCellClick(GridRowNumber rowNumber,
							 GridColumnNumber columnNumber);
	virtual void DoCellDoubleClick(GridRowNumber rowNumber,
								   GridColumnNumber columnNumber);
	virtual void DoCellDraw(GridRowNumber rowNumber,
							GridColumnNumber columnNumber);
	virtual void SetGridSize(GridRowCount rows,
							 GridColumnCount columns);
	virtual BR_Distance GetRowHeight(GridRowNumber rowNumber = 0) const;
	virtual BR_Distance GetColumnWidth(GridColumnNumber columnNumber = 0) const;

	// New instances of inherited virtual functions
	virtual void DoClick(const BR_CPoint& point,
						 KeyModifiers keys);
	virtual void DoDoubleClick(const BR_CPoint& point,
							   KeyModifiers keys);
	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& Area);
	virtual void SetInteriorSize(const BR_CPoint& newSize,
							 BR_Boolean redraw = TRUE);
	virtual void AdjustCellSize();
	virtual BR_Distance GetCellRangeLength(long startingCell,
										   long endingCell,
										   BR_Boolean fVertical) const;

	virtual void GetEffectiveInterior(BR_CRectangle& interior) const;

protected:
	void SetColumns(GridColumnCount numberOfColumns);
	void SetRows(GridRowCount numberOfRows);
	virtual void SetRowHeight(BR_Distance fHeightOfRow,
							  GridRowNumber whichRow = 0);
	virtual void SetColumnWidth(BR_Distance columnWidth,
								GridColumnNumber whichColumn = 0);
	virtual void DrawRange(GridRowNumber topCell,
						   GridRowNumber bottomCell,
						   GridColumnNumber leftCell,
						   GridColumnNumber rightCell);
	virtual BR_Boolean GetCellRanges(const BR_CRectangle& gridArea,
									 GridColumnNumber& leftCell,
									 GridRowNumber& topCell,
									 GridColumnNumber& rightCell,
									 GridRowNumber& bottomCell) const;



private:

	GridRowCount fNumberOfRows;							// The number of rows
	GridColumnCount fNumberOfColumns;					// The number of columns
	unsigned short fHeightOfRow;					// The height of each row
	unsigned short fWidthOfColumn;					// The height of each column

	BR_SETCLASSNAME(BR_CGrid);
};

//========================================================================================
//	STRUCT BR_SGridResource
//========================================================================================
struct BR_SGridResource : BR_SViewResource
{
	BR_CGrid::GridRowCount fNumberOfRows;
	BR_CGrid::GridColumnCount fNumberOfColumns;
};


//----------------------------------------------------------------------------------------
//	BR_CGrid::GetColumns
//----------------------------------------------------------------------------------------
inline BR_CGrid::GridColumnCount BR_CGrid::GetColumns() const
{
	return (fNumberOfColumns);
}


//----------------------------------------------------------------------------------------
//	BR_CGrid::GetRows
//----------------------------------------------------------------------------------------
inline BR_CGrid::GridRowCount BR_CGrid::GetRows() const
{
	return (fNumberOfRows);
}


//----------------------------------------------------------------------------------------
//	BR_CGrid::SetColumns
//----------------------------------------------------------------------------------------
inline void BR_CGrid::SetColumns(GridColumnCount numberOfColumns)
{
	fNumberOfColumns = numberOfColumns;
}


//----------------------------------------------------------------------------------------
//	cGrid::SetRows
//----------------------------------------------------------------------------------------
inline void BR_CGrid::SetRows(GridRowCount numberOfRows)
{
	fNumberOfRows = numberOfRows;
}


#endif
