#if !defined(BRFONTCH_H) && !defined(__BEDRC__)
#define BRFONTCH_H
//========================================================================================
//
//     File:			BRFontCh.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/10/91
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDLGDIR_H
#include "BRDlgDir.h"  // always include the base class
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#if defined(BR_BUILD_WIN) && !defined(_INC_COMMDLG)
#include <Commdlg.h>
#endif

//========================================================================================
//	Forward Class Declaration
//========================================================================================

class BR_CView;
class BR_CCanvas;
class BR_CFont;

//========================================================================================
//	BR_CFontChooser
// a class that allows to choose a font.  You give BR_CFontChooser
// a font and call ShowDialog.  Then, if the user selects Ok, the font is
// updated with the selected attributes.
//========================================================================================

class BR_CFontChooser : public BR_CDialogDirector
{
public:
	enum FontChooserOptions
	{
		kDefault = 0, kFixedFontsOnly = 1 << 0, kChooseColor = 1 << 1
	};


public:
	BR_CFontChooser(BR_CDirector *supervisor,
								 BR_CView *pane,
								 BR_CFont *font);
	//	When displayed, the dialog will present a selection of fonts available if the
	//	Pane is drawn to its current (at that time) canvas.

	BR_CFontChooser(BR_CDirector *supervisor,
								 BR_CView *pane,
								 BR_CCanvas *canvas,
								 BR_CFont *font);
	//	When displayed, the dialog will present a selection of fonts available if the
	//	Pane is drawn to the Canvas.

	BR_CFontChooser(BR_CBureaucrat *supervisor,
								 BR_CView *enclosure,
								 BR_CModule& module,
								 BR_ResourceId resourceId);

	virtual~ BR_CFontChooser();

	void SetOptions(FontChooserOptions options);

	BR_CFont *GetFont() const;
	void SetColor(const BR_CColor& textColor);
	BR_CColor GetColor() const;

	// Inherited methods
	virtual void ShowDialog();

private:
	BR_CView* fPane;							// Selection of fonts is based upon this
	BR_CCanvas* fCanvas;						//   pane or this canvas
	BR_CFont* fFont;							// This is the font we modify
	BR_CColor fColor;
	FontChooserOptions fOptions;

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
protected:
#ifdef BR_BUILD_WIN
	virtual BR_Boolean WinDoDialog(LOGFONT& lf,
								   CHOOSEFONT& chf);
	//Uses lf to Set the initial selection in the dialog. Returns TRUE if the user
	//  chose cmdOk.  On fEntryArray, chf is initialized for Windows COMMDLG. The caller
	//  should use chf to Set the font attributes. Returns TRUE if the user closed the
	//  dialog with Ok.

	HDC fDC;
	virtual void WinCreateDC();
	virtual void WinDeleteDC();
	HDC WinGetDC() const;
#endif	

	BR_SETCLASSNAME(BR_CFontChooser);
};


//----------------------------------------------------------------------------------------
//	BR_CFontChooser::GetFont
//----------------------------------------------------------------------------------------

inline BR_CFont *BR_CFontChooser::GetFont() const
{
	return fFont;
}

//----------------------------------------------------------------------------------------
//	BR_CFontChooser::SetOptions
//----------------------------------------------------------------------------------------

inline void BR_CFontChooser::SetOptions(FontChooserOptions options)
{
	fOptions = options;
}

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CFontChooser::WinGetDC
//----------------------------------------------------------------------------------------

inline HDC BR_CFontChooser::WinGetDC() const
{
	return (fDC);
}
#endif

#endif


