#if !defined(BRFILESP_H) && !defined(__BEDRC__)
#define BRFILESP_H
//========================================================================================
//
//     File:			BRFileSp.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	2/7/91
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRFILEFI_H
#include "BRFileFi.h"
#endif

#ifndef BRCHRSTR_H
#include "BRChrStr.h"  
#endif

#ifdef BR_BUILD_WIN
#include <dos.h>
#endif

#if defined(BR_BUILD_WIN) && !defined(BRDOS_H)
#include "BRDOS.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__FILES__)
#include <Files.h>
#endif




//========================================================================================
//	BR_CFileSpecification
//
//	This class is used to identify a disk-based file.  Since this is a very OS-relative
//    object, the data fields have been made public.
//========================================================================================

class BR_CFileSpecification : public BR_CObject
{
public:
	BR_CFileSpecification(const BR_CFileSpecification& specification);
	BR_CFileSpecification(const BR_TString<BR_Char>& fileName);
	~BR_CFileSpecification();

	void GetName(BR_TString<BR_Char>& fileName) const;
	// Get the file name

	void SetName(const BR_TString<BR_Char>& fileName);
	// Rename the file

	BR_Boolean operator==(const BR_CFileSpecification& theOtherFile);
	BR_CFileSpecification& operator=(const BR_CFileSpecification& theOtherFile);

	void GetPath(BR_TString<BR_Char>& pathName) const;

#ifdef BR_BUILD_WIN
public:
	int GetDrive() const;
	
	BR_CDynamicCharString fFileName;
#endif

#ifdef BR_BUILD_MAC
public:
	BR_CFileSpecification(const FSSpec& specification);

	FSSpec fFileSpec;
#endif 

	BR_SETCLASSNAME(BR_CFileSpecification);
};




//========================================================================================
//	BR_CDirectorySpecification
//
//	This class is used to indentify a disk-based directory.  A directory is represented
//    as a file which contains a collection of other files, therefore it is derived from
//    the BR_CFileSpecification class.
//========================================================================================
class BR_CDirectorySpecification : public BR_CFileSpecification
{
public:
	BR_CDirectorySpecification(const BR_CDirectorySpecification& specification);
	BR_CDirectorySpecification(const BR_TString<BR_Char>& directoryName);
	virtual ~BR_CDirectorySpecification();

#ifdef BR_BUILD_MAC
public:
	BR_CDirectorySpecification(FSSpec& specification);
#endif

	BR_SETCLASSNAME(BR_CDirectorySpecification);
};

#endif


