#if !defined(BRFILEFI_H) && !defined(__BEDRC__)
#define BRFILEFI_H
//========================================================================================
//
//     File:		BRFileFi.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	7/1/91
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRCHRSTR_H 
#include "BRChrStr.h"
#endif

#ifndef BRSTRLIS_H
#include "BRStrLis.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__TYPES__)
#include <Types.h>
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CFileSpecification;


//========================================================================================
// Type definitions
//========================================================================================

typedef unsigned short BR_CollectionIndex;				// Change to match OrderedColl.
typedef unsigned long  BR_OrderedCollectionIndex;		// Change to match OrderedColl.


//========================================================================================
//	BR_CFileFilter
//
//		This class is used to determine whether or not a file name matches
//		the specified fPatternList.  Patterns are specified as regular expressions.
//		If no title is passed into the BR_CFileFilter constructor, that filter
// 		is assumed to be a default file filter and will match all files.
// 
// 		Recognized matches on Windows:
//       * - recognizes 0 or more characters.
//       ? - recognizes a single character.
// 
// 		Recognized matches on Macintosh:
//       * - recognizes 0 or more characters.
//        - (option-fX) recognizes 0 or more characters.
//       ? - recognizes a single character.
//        
//========================================================================================
class BR_CFileFilter : public BR_CDynamicCharString
{
public:
	// New methods
	BR_CFileFilter(const BR_TString<BR_Char>& FilterName);
	BR_CFileFilter(const BR_Char* FilterName);
	BR_CFileFilter();							// Default File Filter
	virtual~ BR_CFileFilter();

	virtual BR_Boolean AddPattern(const BR_TString<BR_Char>& strPattern);
	virtual BR_Boolean AddPattern(const BR_Char* strPattern);
	virtual void GetPattern(BR_CollectionIndex index,
								BR_TString<BR_Char>& strPattern) const;
	virtual BC_Index GetPatternCount() const;

	virtual BR_Boolean DoesFileFit(const BR_CFileSpecification& FileSpec) const;
	virtual void GetAllPatternsConcatenated(BR_TString<BR_Char>& strPattern,
											BR_Char mysep = ';') const;

	BR_Boolean IsDefaultFilter() const;


private:
	BR_CStringList fPatternList;		// The list of fPatternList
	BR_Boolean fIsDefault;			// TRUE if filter is a default filter (matches all)

private:
	BR_Boolean MatchFile(const BR_CFileSpecification& FileSpec) const;
};


//----------------------------------------------------------------------------------------
//	BR_CFileFilter::IsDefaultFilter
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CFileFilter::IsDefaultFilter() const
{
	return (fIsDefault);
}


#endif
