#if !defined(BREDITCO_H) && !defined(__BEDRC__)
#define BREDITCO_H
//========================================================================================
//
//     File:			BREditCo.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 20, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BREDITCO_K
#include "BREditCo.k"
#endif

#ifndef BRCONTRO_H
#include "BRContro.h"
#endif

#ifndef BRCHORE_H
#include "BRChore.h"
#endif

#if defined(BR_BUILD_WIN) && !defined(__INC_WINDOWS)
#include <windows.h>
#endif

#if defined(BR_BUILD_MAC) && !defined(__TEXTEDIT__)
#include <TextEdit.h>
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CEditCtlCaretChore;


//========================================================================================
// Constants
//========================================================================================

#define ORI_MAX_CHARS 32000
	// Maximum length of an BR_CEditControl on the Macintosh. This is a TextEdit limit.

const unsigned short kSelectAll = 32767;


//========================================================================================
// STRUCT BR_SEditControlResource
//========================================================================================

struct BR_SEditControlResource : BR_SControlResource
{
};


//========================================================================================
//	CLASS BR_CEditControl
//
//	A class that creates and manages a rectangle in which the user can
//  enter and edit text
//========================================================================================

class BR_CEditControl : public BR_CControl
{
public:
	typedef unsigned short int CharacterPosition;
	
	enum { kDefaultHorizontalMargin = 3, kDefaultVerticalMargin = 3 };

	BR_CEditControl(BR_CView* enclosure,
					BR_CBureaucrat* supervisor,
					BR_Distance width,
					BR_Distance height,
					BR_Coordinate x,
					BR_Coordinate y,
					ViewSizing horizontalSizing,
					ViewSizing verticalSizing,
					ViewId viewId,
					ViewStyle style);

	BR_CEditControl(BR_CView* enclosure,
					BR_CBureaucrat* supervisor,
					const BR_CModule& module,
					BR_SResource& viewResource);

	BR_CEditControl();

	void InitEditControl(BR_CView* enclosure,
						 BR_CBureaucrat* supervisor,
						 const BR_CModule& module,
						 BR_SResource& viewResource);

	void InitEditControl(BR_CView* enclosure,
						 BR_CBureaucrat* supervisor,
						 BR_Distance width,
						 BR_Distance height,
						 BR_Coordinate x,
						 BR_Coordinate y,
						 ViewSizing horizontalSizing,
						 ViewSizing verticalSizing,
						 ViewId viewId,
						 ViewStyle style);

	virtual~ BR_CEditControl();

	// ----- Inherited methods

	virtual BR_Boolean DoKey(Key key,
							 unsigned short repeatCount,
							 BR_Boolean callSupervisor = TRUE);

	virtual void ReceiveFocus();
	virtual void InvalidViewFeedback();
	virtual void UpdateMenus(BR_CMenuBar& menuBar,
							 BR_Boolean callSupervisor);
	virtual void SetEnable(BR_Boolean state);

	// ----- New methods

	BR_Boolean HasChanged() const;
	virtual void SetChanged(BR_Boolean newChanged);

	virtual short GetNumberOfLines() const;

	virtual BR_Boolean GetSelection(BR_TString<BR_Char>& strBuffer) const;
	virtual BR_Boolean ReplaceSelection(const BR_TString<BR_Char>& strBuffer);

	virtual void GetSelectionRange(CharacterPosition& nStart,
								   CharacterPosition& nEnd) const;
	virtual void SetSelectionRange(CharacterPosition nStart,
								   CharacterPosition nEnd);

	void SelectAll();

	void SetCaretPosition(CharacterPosition nOffset);
	virtual void SetReadOnly(BR_Boolean readOnly);
	void SetTextLimit(unsigned short numberOfCharacters);

	virtual void Scroll(short lines, short chars);
	virtual void ScrollTo(short lineNumber, short charNumber);

private:
	BR_Boolean fInitialized:1;							// is instance initialized?

#ifdef BR_BUILD_MAC
public:

	// Enumeration for ASCII Character Constants - These constants are included here for
    // now but they should probably be put in some Bedrock global file at some point. !!!

	enum
	{
		chBackspace = 8,						// ASCII code for Backspace character  
		chClear = 27,							// ASCII code for Clear fKey (aka ESC)  
		chDown = 31,							// ASCII code for down arrow  
		chEnd = 4,								// ASCII code for the End fKey  
		chEnter = 3,							// ASCII code for Enter character  
		chEscape = 27,							// ASCII code for Escape (aka Clear) fKey  
		chFunction = 16,						// ASCII code for any function fKey  
		chFwdDelete = 127,						// ASCII code for forward delete  
		chHelp = 5,								// ASCII code for Help fKey  
		chHome = 1,								// ASCII code for the Home fKey  
		chLeft = 28,							// ASCII code for fLeft arrow  
		chPageDown = 12,						// ASCII code for Page Down fKey  
		chPageUp = 11,							// ASCII code for Page Up fKey  
		chReturn = 13,							// ASCII code for Return character  
		chRight = 29,							// ASCII code for fRight arrow  
		chSpace = 32,							// ASCII code for Space character  
		chTab = 9,								// ASCII code for Tab character  
		chUp = 30								// ASCII code for up arrow
	};

	virtual void BeginDrawing(BR_CDrawStateData& drawStateData);
	virtual void ResumeDrawing(const BR_CDrawStateData& drawStateData);
	virtual void LoseFocus(BR_CView *viewReceivingFocus);
	virtual void SetText(const BR_TString<BR_Char>& text, BR_Boolean redraw=TRUE);
	virtual unsigned long GetText(BR_TString<BR_Char>& buffer) const;
	virtual unsigned long GetTextLength() const;
	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& area);
	virtual BR_Boolean SetFocus();
	virtual BR_CFont* SetViewFont(BR_CFont* newFont);
	virtual void DoClick(const BR_CPoint& point, KeyModifiers keyFlags);

	void BlinkInsertionPoint();								// ?INTERNAL?

protected:
	BR_Boolean InitMacEditControl(ViewStyle style);				// ?INTERNAL?
	void SetMacTE(TEHandle hTE);								// ?INTERNAL?
	TEHandle GetMacTE() const;								// ?INTERNAL?
	void MarkChanged(BR_Boolean newChanged = TRUE);		// ?INTERNAL?
	ViewStyle GetStyle() const;									// ?INTERNAL?
	
private:
	TEHandle fMacTE;								// Mac TextEdit record
	BR_Boolean fChanged;						// TRUE if text was modified
	ViewStyle fStyle;							// Windows fStyle of edit control
	BR_CEditCtlCaretChore* fCaretChore;			// idle chore for cursor flashing
	unsigned long fMaxTxLen;					// max text length for SetTextLimit mwd
#endif

#ifdef BR_BUILD_WIN
public:
	virtual BR_Boolean DoKeyDown(Key key,
								 unsigned short repeatCount,
								 BR_Boolean callSupervisor = TRUE);

	LONG Dispatch(WORD wMessage,
				  WORD wParam,
				  LONG lParam,
				  BR_Boolean callDefaultProc = TRUE);	// ?INTERNAL?
				  
	LONG DoDefaultProc(WORD wMessage,
					   WORD wParam,
					   LONG lParam);					// ?INTERNAL?
#endif

	BR_SETCLASSNAME(BR_CEditControl);
};

//----------------------------------------------------------------------------------------
//	BR_CEditControl::SelectAll
//----------------------------------------------------------------------------------------

inline void BR_CEditControl::SelectAll()
{
	SetSelectionRange(0, kSelectAll);
}

//----------------------------------------------------------------------------------------
//	BR_CEditControl::SetCaretPosition
//
//	Sets the position of the caret in an EditControl. Upon exit, the selection
//	is empty.
//----------------------------------------------------------------------------------------

inline void BR_CEditControl::SetCaretPosition(CharacterPosition offset)
{
    SetSelectionRange(offset, offset);
}

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CEditControl::SetMacTE
//----------------------------------------------------------------------------------------

inline void BR_CEditControl::SetMacTE(TEHandle hTE)
{
	fMacTE = hTE;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CEditControl::GetMacTE
//----------------------------------------------------------------------------------------

inline TEHandle BR_CEditControl::GetMacTE() const
{
	return fMacTE;
}
#endif


#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CEditControl::GetStyle
//----------------------------------------------------------------------------------------

inline BR_CView::ViewStyle BR_CEditControl::GetStyle() const
{
	return fStyle;
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CEditControl::HasChanged
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CEditControl::HasChanged() const
{
#ifdef BR_BUILD_MAC
	return fChanged;
#endif

#ifdef BR_BUILD_WIN
	return (BR_Boolean)::SendMessage(GetPlatformWindow(), EM_GETMODIFY, 0, 0L);
#endif
}

	
#ifdef BR_BUILD_MAC
//========================================================================================
//	CLASS BR_CEditCtlCaretChore
//========================================================================================

class BR_CEditCtlCaretChore : public BR_CTimerChore
{
public:
	BR_CEditCtlCaretChore(BR_CEditControl* anEditCtl);
	virtual~ BR_CEditCtlCaretChore();
	virtual BR_Boolean Do();

	BR_SETCLASSNAME(BR_CEditCtlCaretChore);
};
#endif

#endif
