#if !defined(BRDIRECT_H) && !defined(__BEDRC__)
#define BRDIRECT_H
//========================================================================================
//
//     File:		BRDirect.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 12, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRBUREAU_H
#include "BRBureau.h"
#endif

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCCOLLD_H
#include "BCCollD.h"
#endif

#ifndef BCMAPD_H
#include "BCMapD.h"
#endif

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef BRHELP_H
#include "BRHelp.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CWindow;
class BR_CModule;
class BR_CEditControl;
class BR_CListBoxBase;
class BR_CEntryListBoxBase;
class BR_CCheckBox;
class BR_CRadioButton;
class BR_CRadioGroup;
class BR_CPushButton;
class BR_CControl;
//template<class tCharacter>
//class BR_TString;

//========================================================================================
// CLASS BR_CDirector
//========================================================================================

class BR_CDirector : public BR_CBureaucrat
{
public:
	typedef unsigned short int HelpItem;
	enum HelpItemConstants
	{
		kMenu, kView
	};


	typedef unsigned short int TypeOfHelp;
	enum TypeOfHelpConstants
	{
		kRunHelp, kStatusString, kBalloon
	};

	enum { kWindowListIncrementSize = 3,
		   kHelpDictionaryIncrementSize = 3,
		   kHelpDictionaryBuckets = 3 };
	
	virtual void Activate();

	virtual BR_Boolean AddViewHelp(BR_CView* theView,
									 BR_CHelp::HelpTopic theId);

	void AddWindow(BR_CWindow* aWindow);

	virtual BR_Boolean Close(BR_Boolean quitting,
							 BR_Boolean confirmQuit = FALSE);
	virtual void CloseWindow(BR_CWindow* aWindow);
	virtual BR_Boolean ConfirmClose(BR_Boolean quitting);

	virtual void Deactivate();

	virtual void DoCancel();

	virtual BR_Boolean DoCommand(CommandId itsCommand,
								 BR_CObject* itsNotifier,
								 BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean DoKeyDown(Key theKey,
								 unsigned short repeatCount,
								 BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean DoHelp(BR_CHelp::HelpTopic theId,
								HelpItem theItem,
								TypeOfHelp theType);

	virtual BR_Boolean DoMenuHelp(BR_CMenu::MenuId theId,
									TypeOfHelp theType);

	virtual BR_Boolean DoViewHelp(const BR_CView& theView,
									TypeOfHelp theType);

	virtual void DoReturn();

	virtual void DoTab() const;

	void EnableSubview(BR_CView::ViewId id,
								 BR_Boolean enable) const;

	virtual void EnterView(BR_CView& theView);
	virtual void ExitView(BR_CView& theView);

	virtual BR_CWindow* GetActiveWindow() const;
	BR_CCheckBox* GetCheckBox(BR_CView::ViewId nId) const;
	virtual BR_CDirector* GetDirector() const;
	BR_CEditControl* GetEditControl(BR_CView::ViewId nId) const;
	BR_CEntryListBoxBase* GetEntryListBox(BR_CView::ViewId nId);
	BR_CListBoxBase* GetListBox(BR_CView::ViewId nId) const;
	BR_CPushButton* GetPushButton(BR_CView::ViewId nId) const;
	BR_CRadioButton* GetRadioButton(BR_CView::ViewId nId) const;
	BR_CRadioGroup* GetRadioGroup(BR_CView::ViewId nId) const;
	virtual BR_Boolean GetStatusString(BR_CHelp::HelpTopic theId,
									   BR_TString<BR_Char>& helpStatusString) const;
	BR_CView* GetSubview(BR_CView::ViewId id) const;
	BR_Boolean BR_CDirector::GetSubviewText(BR_CView::ViewId id,
										BR_TString<BR_Char>& theText) const;
	virtual BR_CHelp::HelpTopic GetViewHelpId(const BR_CView& theView) const;
	virtual BR_CHelp::HelpTopic GetMenuHelpId(BR_CMenu::MenuId theMenuId) const;
	BR_CWindow* GetWindow(unsigned long winNumber) const;
	unsigned long GetWindowCount() const;

	void InitDirector(BR_CBureaucrat* itsSupervisor);

	BR_Boolean IsActive() const;
	virtual BR_Boolean IsControlValid(const BR_CControl& theControl) const;

	virtual BR_CWindow* LoadWindow(BR_CView* theEnclosure,
									 BR_CModule* theCodeModule,
									 BR_CModule* theResModule,
									 BR_ResourceId theId);

	virtual void NameWindow(BR_CWindow& theWindow) const;
	virtual void NewWindow();

	virtual void NotValidControl(const BR_CControl& control);

	virtual BR_Boolean Quit();

	virtual BR_CHelp::HelpTopic RemapHelpId(BR_CHelp::HelpTopic theId,
											  HelpItem theItem,
											  TypeOfHelp theType) const;

	virtual BR_Boolean RemoveViewHelp(const BR_CView& aView);

	void RemoveWindow(const BR_CWindow& aWindow);

	virtual BR_Boolean ShowHelpStatusString(const BR_TString<BR_Char>& helpStatusString) const;

	void ShowSubview(BR_CView::ViewId theId,
							   BR_Boolean show) const;

	BR_Boolean SetSubviewText(BR_CView::ViewId id,
								BR_TString<BR_Char>& theText);

	virtual void UpdateMenus(BR_CMenuBar& theMenuBar,
							 BR_Boolean callSupervisor = TRUE);

protected:
	BR_CDirector();
	BR_CDirector(BR_CBureaucrat* itsSupervisor);
	virtual~ BR_CDirector();

	BR_Boolean IsHelpStatusResourceAvailable() const;
	BR_Boolean IsHelpMenuResourceAvailable() const;

	void SetHelpResModule(BR_CModule* module);
	void SetHelpStatusResId(BR_ResourceId theId);
	void SetHelpMenuResId(BR_ResourceId theId);

private:
	BR_Boolean fInitialized:1;
	BR_Boolean fActive:1;
	BR_Boolean fHelpStatusResourceAvailable:1;
		// is help status multistring resource present?
	BR_Boolean fHelpMenuResourceAvailable:1;
		// is BR_CHelp::HelpTopic-to-helpId multilong resource present?
	BC_TDynamicCollection<BR_CWindow *, BC_CUnmanaged> fWindowList;
	BC_TDynamicMap<BR_CView *, BR_CHelp::HelpTopic, kHelpDictionaryBuckets, BC_CUnmanaged> fHelpDictionary;
	BR_ResourceId fHelpStatusResourceId;
	BR_ResourceId fHelpMenuResourceId;
		// BR_CHelp::HelpTopic-to-helpId multilong resource.
	BR_CModule* fHelpResourceModule;
		// Pointer to help resource module.

	void SetResourceAvailableMembers();
		// Set 'fHelpStatusResourceAvailable' and 'fHelpMenuResourceAvailable'.

	BR_SETCLASSNAME(BR_CDirector);
};


//----------------------------------------------------------------------------------------
// BR_CDirector::IsActive
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDirector::IsActive() const
{
	return fActive;
}


//----------------------------------------------------------------------------------------
// BR_CDirector::IsHelpStatusResourceAvailable
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDirector::IsHelpStatusResourceAvailable() const
{
	return fHelpStatusResourceAvailable;
}


//----------------------------------------------------------------------------------------
// BR_CDirector::IsHelpMenuResourceAvailable
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDirector::IsHelpMenuResourceAvailable() const
{
	return fHelpMenuResourceAvailable;
}

//========================================================================================
// CLASS BR_CAppDirector
//========================================================================================

class BR_CAppDirector : public BR_CDirector
{
public:
	BR_CAppDirector(BR_CApplication* theApplication);
	virtual~ BR_CAppDirector();

	virtual BR_Boolean AddViewHelp(BR_CView* View,
										BR_CHelp::HelpTopic lHelpId);

	virtual BR_Boolean Close(BR_Boolean quitting,
							 BR_Boolean confirmQuit = FALSE);

	virtual BR_CHelp::HelpTopic GetViewHelpId(const BR_CView& view) const;
	virtual BR_CHelp::HelpTopic GetMenuHelpId(BR_CMenu::MenuId MenuId) const;
	virtual BR_Boolean GetStatusString(BR_CHelp::HelpTopic theId,
									   BR_TString<BR_Char>& helpStatusString) const;


	virtual BR_Boolean DoMenuHelp(BR_CMenu::MenuId theId,
									   TypeOfHelp theType);

	virtual BR_Boolean BR_CAppDirector::DoViewHelp(const BR_CView& View,
									   TypeOfHelp wHelpType);

	virtual BR_Boolean DoHelp(BR_CHelp::HelpTopic theId,
								   HelpItem theItem,
								   TypeOfHelp theType);

	virtual BR_CHelp::HelpTopic RemapHelpId(BR_CHelp::HelpTopic theId,
												 HelpItem theItem,
												 TypeOfHelp theType) const;

	virtual BR_Boolean RemoveViewHelp(const BR_CView& theView);
	virtual BR_Boolean ShowHelpStatusString(const BR_TString<BR_Char>& helpStatusString) const;

	void SetHelpResModule(BR_CModule* module);
	void SetHelpStatusResId(BR_ResourceId theId);
	void SetHelpMenuResId(BR_ResourceId theId);

private:
	BR_CApplication* fApplication;

	BR_SETCLASSNAME(BR_CAppDirector);
};

//----------------------------------------------------------------------------------------
// BR_CAppDirector::SetHelpResModule
//----------------------------------------------------------------------------------------

inline void BR_CAppDirector::SetHelpResModule(BR_CModule* module)
{
	BR_CDirector::SetHelpResModule(module);
}

//----------------------------------------------------------------------------------------
// BR_CAppDirector::SetHelpStatusResId
//----------------------------------------------------------------------------------------

inline void BR_CAppDirector::SetHelpStatusResId(BR_ResourceId theId)
{
	BR_CDirector::SetHelpStatusResId(theId);
}

//----------------------------------------------------------------------------------------
// BR_CAppDirector::SetHelpMenuResId
//----------------------------------------------------------------------------------------

inline void BR_CAppDirector::SetHelpMenuResId(BR_ResourceId theId)
{
	BR_CDirector::SetHelpMenuResId(theId);
}
#endif

