#if !defined(BRDEBUG_H) && !defined(__BEDRC__)
#define BRDEBUG_H
//========================================================================================
//
//     File:			BRDebug.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/7/90
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef BRALERT_H
#include "BRAlert.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

#if defined BR_BUILD_WIN  && !defined BRSTR_H
#include "BRStr.h"
#endif

//========================================================================================
// Forward class declaration
//========================================================================================
class BR_CObject;

//========================================================================================
// Type definitions
//========================================================================================
#ifdef BR_DEBUG
typedef unsigned short  BR_DebugErrorCode;
#endif

//========================================================================================
// Constants
//========================================================================================

// BEDSPRINTF - sprintf use for debugging
#if defined(BR_BUILD_WIN)
#define BEDSPRINTF ::wsprintf
#elif defined(BR_BUILD_MAC)
#define BEDSPRINTF ::sprintf
#endif

#ifdef BR_DEBUG
#define kErrorTextID         (cmdUser)
#define kFileNameID          (cmdUser+1)
#define kLineNumberID            (cmdUser+2)
#define kDebugDialogID       1000

// Internal BR_DEBUG Error Codes
const unsigned short kDebugTargetNotFound = 1;
const unsigned short kDebugBadCastdown    = 2;
#endif

//========================================================================================
// Global procedure declarations
//========================================================================================


#ifdef BR_DEBUG
//========================================================================================
// These are macros that simplify access to the BR_DEBUG message box system
//  by eliminating the need to provide a filename or line number.
//  They also provide an easy way to cut off access to the BR_DEBUG message
//  box (see below)
//========================================================================================
#define BR_DEBUG_STRING(s)            ::BCLDebugString(__FILE__, __LINE__, s)
#define BR_DEBUG_RECT(pString, pRect) ::BCLDebugRect(__FILE__, __LINE__, pString, pRect)
#define BR_ASSERT_OBJECT(f, p)        if(!(f)) ::BCLAssertObject(__FILE__, __LINE__, #f, p)
#define BR_ASSERT(f)                 BR_ASSERT_OBJECT(f, NULL)
#define BR_ASSERT_FUNC(f) 			  ::BCLAssertFunc(f, __FILE__, __LINE__, #f)

#else

// If the BR_DEBUG flag is not set, then set up the following macros so that the
// BR_DEBUG message box isn't shown
#define BR_DEBUG_STRING(s)              ((void)0)
#define BR_DEBUG_RECT(s, r)             ((void)0)
#define BR_ASSERT(exp)                 ((void)0)
#define BR_ASSERT_FUNC(f)               ((void)(f))
#define BR_ASSERT_OBJECT(f, p)          ((void)0)

#endif


BR_MesssageBoxCommandID DoMessage(const BR_TString<BR_Char>& message,
								  const BR_TString<BR_Char>& caption,
								  const BR_MessageBoxFlags dialogFlags);




#ifdef BR_DEBUG
//========================================================================================
// The declarations of the BR_DEBUG message box access methods
//========================================================================================

BR_Boolean IsInDebugString(void);

void BedDebuggerBreak();
void BedDebuggerString(char* message);
void BedDebuggerString(char* fileName,
					   int lineNumber,
					   char* messageString);

void BCLDebugString(LPSTR fileName,
					int lineNumber,
					BR_Char* messageString);
void BCLDebugString(LPSTR fileName,
					int lineNumber,
					BR_DebugErrorCode messageID);
unsigned short BCLAssertFunc(unsigned short functionPointer,
					 LPSTR fileName,
					 int lineNumber,
					 BR_Char* messageString);
void BCLAssertObject(LPSTR fileName,
					 int lineNumber,
					 LPSTR messageString,
					 const BR_CObject* errorObject);

#endif

#endif
