#if !defined(BRDATETI_H) && !defined(__BEDRC__)
#define BRDATETI_H
//========================================================================================
//
//     File:			BRDateTi.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/11/91
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BROBJECT_H
#include "BRObject.h"   // always include the base class
#endif

#ifndef BRINTL_H
#include "BRIntl.h"
#endif

#ifndef BRTIME_H
#include "BRTime.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

//======================================================================================
//	Forward class Declarations.
//======================================================================================

//template<class tCharacter>
//class BR_TString;
class BR_CTime;
class BR_CDate;

//========================================================================================
//	class BR_CTime : public BR_CObject
//========================================================================================

class BR_CTime : public BR_CObject
{
public:
	BR_CTime();
	BR_CTime(const BR_CTime& time);
	BR_CTime(BR_Hour iHour,
			 BR_Minute iMinute,
			 BR_Second iSecond,
			 BR_Hundredths iHundredths = 0);
	virtual~ BR_CTime();

	BR_CTime& operator=(const BR_CTime& time);

	BR_Boolean operator==(const BR_CTime& time) const;
	BR_Boolean operator!=(const BR_CTime& time) const;
	BR_Boolean operator>=(const BR_CTime& time) const;
	BR_Boolean operator<=(const BR_CTime& time) const;
	BR_Boolean operator>(const BR_CTime& time) const;
	BR_Boolean operator<(const BR_CTime& time) const;

	short CompareDateTime(const BR_CTime& time) const;
	void Update();								// Get the current time
	void Format(BR_TString<BR_Char>& strTime,
				BR_TimeFormatOptions theOptions = BR_TimeFmt_kUseDefault,
				BR_STimeFormatPtr tfmt = NULL);

	// Get components of the time

	BR_Hour GetHour() const;
	BR_Minute GetMinute() const;
	BR_Second GetSecond() const;
	BR_Hundredths GetSecondHundredths() const;

	void GetDateTime(BR_SDateTime& dt) const;

	void SetHour(BR_Hour iHour);
	void SetMinute(BR_Minute iMinute);
	void SetSecond(BR_Second iSecond);
	void SetSecondHundredths(BR_Hundredths iHundredths);

	void SetSystemClock();
	BR_Hour AdjustHours(const BR_Hour delta);
	BR_Minute AdjustMinutes(const BR_Minute delta);
	BR_Second AdjustSeconds(const BR_Second delta);
	BR_Hundredths AdjustSecondHundredths(const BR_Hundredths delta);

private:
	short Adjust(const short delta,
				 // AKJ I don't know what this delta is!
				 BR_DurationUnit unit);
	BR_SDateTime fSdateTIME;						// This holds the last known time

	BR_SETCLASSNAME(BR_CTime);
};

//----------------------------------------------------------------------------------------
// BR_CTime::operator==
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CTime::operator==(const BR_CTime& time) const
{
	return (CompareDateTime(time) == 0);
}

//----------------------------------------------------------------------------------------
// BR_CTime::operator!=
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CTime::operator!=(const BR_CTime& time) const
{
	return (CompareDateTime(time) != 0);
}

//----------------------------------------------------------------------------------------
// BR_CTime::operator>=
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CTime::operator>=(const BR_CTime& time) const
{
	return (CompareDateTime(time) >= 0);
}

//----------------------------------------------------------------------------------------
// BR_CTime::operator<=
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CTime::operator<=(const BR_CTime& time) const
{
	return (CompareDateTime(time) <= 0);
}

//----------------------------------------------------------------------------------------
// BR_CTime::operator>
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CTime::operator>(const BR_CTime& time) const
{
	return (CompareDateTime(time) > 0);
}

//----------------------------------------------------------------------------------------
// BR_CTime::operator<
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CTime::operator<(const BR_CTime& time) const
{
	return (CompareDateTime(time) < 0);
}

//----------------------------------------------------------------------------------------
// BR_CTime::GetHour
//----------------------------------------------------------------------------------------

inline BR_Hour BR_CTime::GetHour() const
{
	return (BR_Hour(fSdateTIME.fHour));
}

//----------------------------------------------------------------------------------------
// BR_CTime::GetMinute
//----------------------------------------------------------------------------------------

inline BR_Minute BR_CTime::GetMinute() const
{
	return (BR_Minute(fSdateTIME.fMinute));
}

//----------------------------------------------------------------------------------------
// BR_CTime::GetSecond
//----------------------------------------------------------------------------------------

inline BR_Second BR_CTime::GetSecond() const
{
	return (BR_Second(fSdateTIME.fSecond));
}

//----------------------------------------------------------------------------------------
// BR_CTime::GetSecondHundredths
//----------------------------------------------------------------------------------------

inline BR_Hundredths BR_CTime::GetSecondHundredths() const
{
	return (BR_Hundredths(fSdateTIME.fHundredths));
}


//========================================================================================
//	class BR_CDate : public BR_CObject
//
//	<comments>
//	<Invariants>
//========================================================================================

class BR_CDate : public BR_CObject
{
public:
	BR_CDate();
	BR_CDate(const BR_CDate& Date);
	BR_CDate(BR_Day iDay,
			 BR_Month iMonth,
			 BR_Year iYear);
	virtual~ BR_CDate();

	BR_CDate& operator=(const BR_CDate& Date);

	BR_Boolean operator==(const BR_CDate& date) const;
	BR_Boolean operator!=(const BR_CDate& date) const;
	BR_Boolean operator>=(const BR_CDate& date) const;
	BR_Boolean operator<=(const BR_CDate& date) const;
	BR_Boolean operator>(const BR_CDate& date) const;
	BR_Boolean operator<(const BR_CDate& date) const;

	short CompareDateTime(const BR_CDate& date) const;
	void Update();								// Get the current date
	void Format(BR_TString<BR_Char>& strDate,
				BR_Boolean fShort = TRUE,
				BR_DateFormatOptions fOptions = BR_DateFmt_kUseDefault,
				BR_SDateFormatPtr dfmt = NULL);

	// Get components of the date
	BR_Day GetDay() const;
	BR_Month GetMonth() const;
	BR_Year GetYear() const;
	BR_Day GetDayOfWeek() const;
	BR_Week GetWeek() const;
	BR_Week GetWeekOfMonth() const;
	BR_Boolean IsLeapYear() const;

	void GetDateTime(BR_SDateTime& dt) const;

	void SetDay(BR_Day iDay);
	void SetMonth(BR_Month iMonth);
	void SetYear(BR_Year iYear);

	void AdjustDays(const BR_Day delta);
	void AdjustWeeks(const BR_Week delta);
	void AdjustMonths(const BR_Month delta);
	void AdjustYears(const BR_Year delta);

	void SetSystemClock();

private:
	BR_SDateTime fSDATEtime;						// This holds the last known date.

	BR_SETCLASSNAME(BR_CDate);
};

//----------------------------------------------------------------------------------------
// BR_CDate::operator==
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDate::operator==(const BR_CDate& date) const
{
	return (CompareDateTime(date) == 0);
}

//----------------------------------------------------------------------------------------
// BR_CDate::operator!=
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDate::operator!=(const BR_CDate& date) const
{
	return (CompareDateTime(date) != 0);
}

//----------------------------------------------------------------------------------------
// BR_CDate::operator>=
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDate::operator>=(const BR_CDate& date) const
{
	return (CompareDateTime(date) >= 0);
}

//----------------------------------------------------------------------------------------
// BR_CDate::operator<=
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDate::operator<=(const BR_CDate& date) const
{
	return (CompareDateTime(date) <= 0);
}

//----------------------------------------------------------------------------------------
// BR_CDate::operator>
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDate::operator>(const BR_CDate& date) const
{
	return (CompareDateTime(date) > 0);
}

//----------------------------------------------------------------------------------------
// BR_CDate::operator<
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDate::operator<(const BR_CDate& date) const
{
	return (CompareDateTime(date) < 0);
}

//----------------------------------------------------------------------------------------
// BR_CDate::GetDay
//----------------------------------------------------------------------------------------

inline BR_Day BR_CDate::GetDay() const
{
	return (BR_Day(fSDATEtime.fDay));
}

//----------------------------------------------------------------------------------------
// BR_CDate::GetMonth
//----------------------------------------------------------------------------------------

inline BR_Month BR_CDate::GetMonth() const
{
	return (BR_Month(fSDATEtime.fMonth));
}

//----------------------------------------------------------------------------------------
// BR_CDate::GetYear
//----------------------------------------------------------------------------------------

inline BR_Year BR_CDate::GetYear() const
{
	return (BR_Year(fSDATEtime.fYear));
}

//----------------------------------------------------------------------------------------
// BR_CDate::GetDayOfWeek
//----------------------------------------------------------------------------------------

inline BR_Day BR_CDate::GetDayOfWeek() const
{
	return (BR_Day(fSDATEtime.fDayOfWeek));
}

//----------------------------------------------------------------------------------------
// BR_CDate::GetWeek
//----------------------------------------------------------------------------------------

inline BR_Week BR_CDate::GetWeek() const
{
	return (BR_Week(fSDATEtime.fWeek));
}

//----------------------------------------------------------------------------------------
// BR_CDate::GetWeekOfMonth
//----------------------------------------------------------------------------------------

inline BR_Week BR_CDate::GetWeekOfMonth() const
{
	return (BR_Week(fSDATEtime.fWeekOfMonth));
}

//----------------------------------------------------------------------------------------
// BR_CDate::IsLeapYear
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDate::IsLeapYear() const
{
	return (fSDATEtime.fLeapYear);
}


//========================================================================================template <class tCharacter>
// CLASS BR_TFormatTool
//
// Placeholder till the formatting tools are implemented
//========================================================================================template <class tCharacter>

template <class tCharacter>
class BR_TDateTimeFormat : public BR_TMinimalStringTool<tCharacter>
{
public:
	virtual ~BR_TDateTimeFormat();
	BR_TDateTimeFormat();
	
	virtual void FormatDate(BR_TString<tCharacter> &string);
	virtual void FormatTime(BR_TString<tCharacter> &string);
	virtual void FormatInteger(BR_TString<tCharacter> &string, unsigned short n);
};

#endif


