#if !defined(BRCURSOR_H) && !defined(__BEDRC__)
#define BRCURSOR_H
//========================================================================================
//
//     File:			BRCursor.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/20/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#if defined BR_BUILD_WIN  && !defined __INC_WINDOWS
#include <windows.h>
#endif

#if defined BR_BUILD_WIN  && !defined BRSTR_H
#include "BRStr.h"
#endif

#if defined BR_BUILD_MAC  && !defined __QUICKDRAW__
#include <QuickDraw.h>
#endif


//========================================================================================
//	Forward Class Declarations
//========================================================================================

class BR_CModule;

//========================================================================================
//  Type definitions
//========================================================================================
#ifdef BR_BUILD_WIN
typedef HCURSOR BR_PlatformCursorHandle;
#endif
#ifdef BR_BUILD_MAC
typedef CursHandle BR_PlatformCursorHandle;
#endif

//========================================================================================
//	BR_CCursor
//========================================================================================

class BR_CCursor : public BR_CObject
{	
public:
	BR_CCursor(const BR_CModule& Module,
			   BR_ResourceId resourceId);
	virtual~ BR_CCursor();

	void Show();
	void Hide();
	void Select();
	void Unselect();

	BR_PlatformCursorHandle GetHandle() const;			// ?INTERNAL?

	void SetHandle(BR_PlatformCursorHandle hNew);			// ?INTERNAL?

#ifdef BR_BUILD_WIN
	BR_CCursor(LPCSTR resourceId);			// ?INTERNAL?
#endif

#ifdef BR_BUILD_MAC
	BR_CCursor(BR_ResourceId resourceId);	// ?INTERNAL?
#endif

private:
	BR_PlatformCursorHandle fCursorHandle;

#ifdef BR_BUILD_WIN
	BR_PlatformCursorHandle hOld;
#endif

	BR_SETCLASSNAME(BR_CCursor);
};

//----------------------------------------------------------------------------------------
//	BR_CCursor::Show
//----------------------------------------------------------------------------------------
inline void BR_CCursor::Show()
{
#ifdef BR_BUILD_MAC
	::ShowCursor();
#endif

#ifdef BR_BUILD_WIN
	::ShowCursor(TRUE);
#endif

}

//----------------------------------------------------------------------------------------
//	BR_CCursor::Hide
//----------------------------------------------------------------------------------------
inline void BR_CCursor::Hide()
{
#ifdef BR_BUILD_MAC
	::HideCursor();
#endif

#ifdef BR_BUILD_WIN
	::ShowCursor(FALSE);
#endif

}

//----------------------------------------------------------------------------------------
//	BR_CCursor::Select
//----------------------------------------------------------------------------------------
inline void BR_CCursor::Select()
{
#ifdef BR_BUILD_MAC
	if (fCursorHandle)
		::SetCursor(*fCursorHandle);
	else
		::SetCursor(&qd.arrow);
#endif

#ifdef BR_BUILD_WIN
	hOld = ::SetCursor(fCursorHandle);
#endif
}

//----------------------------------------------------------------------------------------
//	BR_CCursor::Unselect
//----------------------------------------------------------------------------------------
inline void BR_CCursor::Unselect()
{
#ifdef BR_BUILD_MAC
	// Unselect ???
#endif

#ifdef BR_BUILD_WIN
	::SetCursor(hOld);
#endif

}

//----------------------------------------------------------------------------------------
//	BR_CCursor::GetHandle
//----------------------------------------------------------------------------------------
inline BR_PlatformCursorHandle BR_CCursor::GetHandle() const
{
	return fCursorHandle;
}

//----------------------------------------------------------------------------------------
//	BR_CCursor::SetHandle
//----------------------------------------------------------------------------------------
inline void BR_CCursor::SetHandle(BR_PlatformCursorHandle hNew)
{
	fCursorHandle = hNew;
}

#endif


