#if !defined(BRCONDLG_H) && !defined(__BEDRC__)
#define BRCONDLG_H
//========================================================================================
//
//     File:		BRConDlg.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/11/91
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDLGDIR_H
#include "BRDlgDir.h"
#endif

#ifndef BRMStrLi_H
#include "BRMStrLi.h"
#endif

#ifndef BRALERT_H
#include "BRAlert.h"
#endif

//========================================================================================
// CLASS BR_CConfirmDialog
//========================================================================================

class BR_CConfirmDialog : public BR_CDialogDirector
{
public:
	BR_CConfirmDialog::BR_CConfirmDialog(BR_CDocument* itsDocument,
										 BR_CMultiStringList::StringId theId,
										 BR_MessageBoxFlags wButtons);
	virtual~ BR_CConfirmDialog();

	BR_CBureaucrat::CommandId GetResult() const;

private:
	CommandId fResult;							// The result of the dialog

	BR_SETCLASSNAME(BR_CConfirmDialog);
};

//----------------------------------------------------------------------------------------
// BR_CConfirmDialog::GetResult
//----------------------------------------------------------------------------------------

inline BR_CBureaucrat::CommandId BR_CConfirmDialog::GetResult() const
{
	return fResult;
}


//========================================================================================
// CLASS BR_CConfirmClose
//========================================================================================

class BR_CConfirmClose : public BR_CConfirmDialog
{
public:
	BR_CConfirmClose(BR_CDocument* itsDocument);
	virtual~ BR_CConfirmClose();

	BR_SETCLASSNAME(BR_CConfirmClose);
};


//========================================================================================
// CLASS BR_CConfirmRevert
//========================================================================================

class BR_CConfirmRevert : public BR_CConfirmDialog
{
public:
	BR_CConfirmRevert(BR_CDocument* itsDocument);
	virtual~ BR_CConfirmRevert();

	BR_SETCLASSNAME(BR_CConfirmRevert);
};


#endif
