#ifndef BRCMDIDS_H
#define BRCMDIDS_H
//========================================================================================
//
//     File:			BRCmdIds.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/20/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

//========================================================================================
// Command Id Constants
//
// It would be better if we could distribute these definitions throughout Bedrock, but
// then there would be no practical way to manage the allocation of the constant values.
//========================================================================================

#define cmdShowDesktop          0x1
#define cmdOk                   0x2
#define cmdCancel               0x3

#define cmdPageUp				0x4
#define cmdPageDown             0x5
#define cmdPageLeft             0x6
#define cmdPageRight            0x7
#define cmdPageTop              0x8
#define cmdPageBottom           0x9
#define cmdPageFarLeft          0xA 
#define cmdPageFarRight         0xB

#define cmdEditControlChange	0xC		// Text in an edit control changed
#define	cmdEntryListBoxChange	0xD		// Text control in an fEntryArray list box changed 
#define cmdEntryListBoxUpdateList 0xF	// The list was dropped down 
#define cmdListBoxDoubleClick	0x10	// Double click in the list box 
#define cmdListBoxSelect		0x11	// Selection in list box

#define cmdEndControlMode		0x12	// The user is done with a control

// Various menu identifiers

#define cmdNew                  0x100   // New
#define cmdOpen                 0x101   // Open
#define cmdClose                0x102   // Close
#define cmdSave                 0x103   // Save
#define cmdSaveAs               0x104   // Save As
#define cmdRevert               0x105   // Revert
#define cmdDocumentPrintSetup   0x106   // Windows page setup/Mac Document Setup
#define cmdPrint                0x107   // Print
#define cmdPrinterPrintSetup    0x108   // Windows Print setup/Mac Page Setup
#define cmdQuit                 0x1F0   // Quit

#define cmdUndo                 0x200   // Undo
#define cmdCut                  0x201   // Cut
#define cmdCopy                 0x202   // Copy
#define cmdPaste                0x203   // Paste
#define cmdClear                0x204   // Clear
#define cmdClipboard            0x2F0   // Clipboard

#define cmdTextFont             0xE00   // Change text font
#define cmdTextSize             0xE01   // Change text size
#define cmdTextStyle            0xE02   // Change text fStyle
#define cmdTextColor            0xE03   // Change text color

#define cmdFontFirst            0x1100  // The first font
#define cmdFontLast             0x12FF  // The last font

#define cmdStyleFirst           0x1300  // The first fStyle
#define cmdStyleNormal          0x1300  // Normal
#define cmdStyleBold            0x1301  // Bold
#define cmdStyleItalic          0x1302  // Italic
#define cmdStyleUnderline       0x1303  // Underline
#define cmdStyleOutline         0x1304  // Outline
#define cmdStyleShadow          0x1305  // Shadow
#define cmdStyleLast            0x13FF  // The last font

#define cmdColorFirst           0x1400  // The first color
#define cmdColorBlack           0x1400  // Black
#define cmdColorWhite           0x1401  // White
#define cmdColorGrey            0x1402  // Grey
#define cmdColorRed             0x1403  // Red
#define cmdColorGreen           0x1404  // Green
#define cmdColorBlue            0x1405  // Blue
#define cmdColorYellow          0x1406  // Yellow
#define cmdColorPurple          0x1407  // Purple
#define cmdColorLast            0x14FF  // The last color

#define cmdSize                 0x1500  // The font size selector
#define cmdSizeFirst            0x1500  // The first size
#define cmdSizeLast             0x15FF  // The last size

// More menu codes
#define cmdTile                 0xF00   // Tile windows
#define cmdCascade              0xF01   // Cascase windows
#define cmdIcons                0xF02   // Iconify
#define cmdFirstChild           0xF20   // The name of the first child window

#define cmdHelpIndex            0x1000  // Run help app: Index
#define cmdHelpCmd              0x1001  // Run help app: Commands
#define cmdHelpProc             0x1002  // Run help app: Procedures
#define cmdHelpEnterMode        0x1003  // Enter help mode
#define cmdHelpExitMode         0x1004  // Exit  help mode
#define cmdHelpView             0x1005  // Run help app: Help for this view

// Other codes
#define cmdAbort                0x1800  // Abort
#define cmdBreak                0x1801  // Break
#define cmdRetry                0x1802  // Retry

#define cmdUser                 0x2000
#define cmdDummy                0xFFFF

#endif
