#if !defined(BRCARET_H) && !defined(__BEDRC__)
#define BRCARET_H
//========================================================================================
//
//     File:		BRCaret.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	November 7, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRRECT_H
#include "BRRect.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CView;
class BR_CBitmap;
class BR_CMacCaretChore;
class BR_CPoint;

//========================================================================================
// CLASS BR_CCaret
//
//        Provides a blinking insertion point to the user
//
//	Note: BR_CCaret, as written, should probably never be subclassed.  It does not define 
//		any virtual methods (except the destructor).  However, we may want to reevaluate
//		this design to allow for subclassing.
//========================================================================================

class BR_CCaret : public BR_CObject
{
public:
	typedef unsigned short int LengthUnit;

	BR_CCaret(BR_CView* pane,
			  LengthUnit width,
			  LengthUnit height);

	BR_CCaret(BR_CView* pane,
			  BR_CBitmap* bitmap);

	virtual~ BR_CCaret();

	void* operator new(size_t);
	void* operator new(size_t,
					   void*);

	void operator delete(void*);

	BR_CPoint GetPosition() const;

	void Hide();

	void SetPosition(BR_Coordinate fX,
					 BR_Coordinate fY);

	void SetPosition(const BR_CPoint& newPosition);

	void Show();

private:
	BR_CView* fPane;					// Pane that owns this caret
	BR_CPoint fPosition;						// Current position of the caret

	static void* gStorage;
#ifdef BR_DEBUG
	static short gCount;
#endif

#ifdef BR_BUILD_MAC
public:
	void BedMacBlink();
	BR_CView* BedMacGetPane() const;

private:
	void MacRefreshCaretRect();
	void MacDrawCaret();

	LengthUnit fMacWidth;							// the width of the caret
	LengthUnit fMacHeight;						// the height of the caret
	BR_CBitmap* fMacBitmap;						// it's image, if any
	BR_CMacCaretChore* fMacCaretTimerChore;		// the old ticker
	long fMacReferenceCount;					// Caret Hide() & Show() reference count
#endif

	BR_SETCLASSNAME(BR_CCaret);
};

//----------------------------------------------------------------------------------------
//	BR_CCaret::operator new
//
//	Defined simply to reexport BR_CObject::operator new(size, fMemoryPtr)
//----------------------------------------------------------------------------------------

inline void *BR_CCaret::operator new(size_t size,
				   void* fMemoryPtr)
{
	return BR_CObject::operator new(size, fMemoryPtr);
}


//----------------------------------------------------------------------------------------
//	BR_CCaret::GetPosition
//----------------------------------------------------------------------------------------

inline BR_CPoint BR_CCaret::GetPosition() const
{
	return fPosition;
}

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CCaret::BedMacGetPane
//----------------------------------------------------------------------------------------

inline BR_CView *BR_CCaret::BedMacGetPane() const
{
	return fPane;
}
#endif

//========================================================================================
//	CLASS BR_CCaretHideShowHelper
//
//		ctor	- Hides caret.
//		dtor	- Shows caret.
//========================================================================================

class BR_CCaretHideShowHelper : public _BR_CAutoDestructObject
{
public:
	BR_CCaretHideShowHelper(BR_CCaret* caret);
	~BR_CCaretHideShowHelper();
	
private:
	BR_CCaret* fCaret;
};


#endif
