#if !defined(BRBLOCK_H) && !defined(__BEDRC__)
#define BRBLOCK_H
//========================================================================================
//
//     File:		BRBlock.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	February 10, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRMESTRM_H
#include "BRMeStrm.h"
#endif

//========================================================================================
//	CLASS BR_CBlock
//========================================================================================

class BR_CBlock : public BR_CMemStream
{
public:
	typedef unsigned short int BlockSize;
	
	BR_CBlock(BlockSize theSize);
	virtual~ BR_CBlock();

	BR_Boolean Append(BR_CBlock& block,
					  StreamIndex appendAt,
					  StreamIndex appendFrom);

	BR_Boolean DeleteBytes(StreamIndex offset,
						   StreamBufferSize nBytes);

	StreamSize GetLengthAfter(StreamIndex offset) const;
	StreamSize GetSpace() const;
	StreamSize GetSpaceAfter(StreamIndex offset) const;
	StreamSize GetStartIndex() const;
	
	BR_Boolean SetLength(StreamSize newLength);
	void SetStartIndex(StreamIndex newStart);
	
	BR_Boolean Write(void* buffer,
					 StreamBufferSize& nBytes);

protected:
	virtual unsigned long GetMemSize() const;

private:
	BlockSize fBlockSize;						//Size of the fMemory block
	unsigned long fStartIndex;					//The number of the index of the first byte

	BR_SETCLASSNAME(BR_CBlock);
};

//----------------------------------------------------------------------------------------
// BR_CBlock::GetStartIndex
//----------------------------------------------------------------------------------------

inline BR_CStream::StreamSize BR_CBlock::GetStartIndex() const
{
	return (fStartIndex);
}

//----------------------------------------------------------------------------------------
// BR_CBlock::SetStartIndex
//----------------------------------------------------------------------------------------

inline void BR_CBlock::SetStartIndex(BR_CStream::StreamIndex newStart)
{
	fStartIndex = newStart;
}

//----------------------------------------------------------------------------------------
// BR_CBlock::GetSpace
//----------------------------------------------------------------------------------------

inline BR_CStream::StreamSize BR_CBlock::GetSpace() const
{
	return ((StreamSize)fBlockSize - GetLength());
}


#endif
