#if !defined(BRBEDEXC_H) && !defined(__BEDRC__)
#define BRBEDEXC_H
//========================================================================================
//
//     File:			BRBedExc.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 1992
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BREXCEPT_H
#include "BRExcept.h"
#endif


enum PlatformErrorAvailability
{
	ePlatformErrorNotAvailable, ePlatformErrorAvailable
};

typedef unsigned long PlatformError;

//========================================================================================
//	CLASS BR_XBedException
//========================================================================================

class BR_XBedException : public _BR_CException
{
public:
	PlatformErrorAvailability GetPlatformErrorAvailability() const;
	PlatformError GetPlatformError() const;

	_BR_EXCEPTION_DEFINE(BR_XBedException);
protected:
	BR_XBedException();
	BR_XBedException(PlatformError fError);

	virtual~ BR_XBedException();

private:
	const PlatformErrorAvailability fPlatformErrorAvailability;
	const PlatformError fPlatformError;
};

//========================================================================================
//	CLASS BR_XDebugBreak
//========================================================================================

class BR_XDebugBreak : public BR_XBedException
{
public:
	virtual ~BR_XDebugBreak();
	BR_XDebugBreak(const char * message);
		// Copies *message, does not adopt message
	
	const char* GetMessage() const;
		// Return pointer to debug message string

	virtual void Copy(void *p, size_t maximumObjectSize) const;
		// Perform deep copy of this object

public:	// Internal Methods
	void SetMessage(const char * message);
		// Copies *message, does not adopt message.

private:
	char * fMessage;

public:
	_BR_EXCEPTION_DEFINE(BR_XDebugBreak);
};

//----------------------------------------------------------------------------------------
// BR_XDebugBreak::GetMessage
//----------------------------------------------------------------------------------------

inline const char* BR_XDebugBreak::GetMessage() const
{
	return fMessage;
}

//========================================================================================
//	CLASS BR_XDebugBreak
//========================================================================================

class BR_XNotImplemented : public BR_XBedException
{
public:
	BR_XNotImplemented(const char * routineName);
		// retains reference to routineName, which is assumed to be static string
		
	virtual ~BR_XNotImplemented();

	const char* GetRoutineName() const;

	_BR_EXCEPTION_DEFINE(BR_XNotImplemented);
private:
	const char * fRoutineName;
};

//----------------------------------------------------------------------------------------
// BR_XBedException::GetPlatformErrorAvailability
//----------------------------------------------------------------------------------------

inline PlatformErrorAvailability BR_XBedException::GetPlatformErrorAvailability() const
{
	return fPlatformErrorAvailability;
}


//----------------------------------------------------------------------------------------
// BR_XNotImplemented::BR_XNotImplemented
//----------------------------------------------------------------------------------------

inline BR_XNotImplemented::BR_XNotImplemented(const char * routineName) :
	fRoutineName(routineName)
{
}

//----------------------------------------------------------------------------------------
// BR_XNotImplemented::GetRoutineName
//----------------------------------------------------------------------------------------

inline const char* BR_XNotImplemented::GetRoutineName() const
{
	return fRoutineName;
}

#endif