/* @(#)mmshdspt.sl	1.1 (Pixar - RenderMan Division) 3/16/90 */

/*-______________________________________________________________________
** 
** Copyright (c) 1988 PIXAR.  All rights reserved.  This program or
** documentation contains proprietary confidential information and trade
** secrets of PIXAR.  Reverse engineering of object code is prohibited.
** Use of copyright notice is precautionary and does not imply
** publication.
** 
**                      RESTRICTED RIGHTS NOTICE
** 
** Use, duplication, or disclosure by the Government is subject to
** restrictions as set forth in subdivision (b)(3)(ii) of the Rights in
** Technical Data and Computer Software clause at 252.227-7013.
** 
** Pixar
** 3240 Kerner Blvd.
** San Rafael, CA  94901
** 
** ______________________________________________________________________
*/

light
mmshdspt( 
    float  intensity = 1;
    color  lightcolor = 1;
    point  from = point "shader" (0,0,0);	/* light position */
    point  to = point "shader" (0,0,1);
    float  coneangle = radians(30);
    float  conedeltaangle = radians(5);
    float  beamdistribution = 2;
    string shadowname = "";
    float samples = 16;
    float width = 1;
)
{
    float  atten, cosangle;
    uniform point A = (to - from) / length(to - from);
    uniform float cosoutside= cos(coneangle),
		  cosinside = cos(coneangle-conedeltaangle);

    illuminate( from, A, coneangle ) {
	cosangle = L.A / length(L);
	atten = pow(cosangle, beamdistribution);
	atten *= smoothstep( cosoutside, cosinside, cosangle );
	if (shadowname != "") {
		atten *= 1-shadow(shadowname, Ps, "samples", samples,
			"swidth", width, "twidth", width);
	}
	Cl = atten * intensity * lightcolor;
    }
}
