name Sharnoa Tiger 4 (Metric)

% 00           
O >4             
N >4             
G >2             
X ->4.>3         
Y ->4.>3         
Z ->4.>3         
A ->4.>3         
I ->4.>3         
J ->4.>3         
K ->4.>3         
Q ->4.>3         
R ->4.>3         
P >40            
F >3.1           
H >2             
D >2             
T >2             
M >2             
S >4             


ModalLetters X Y Z F                  # List of letters that are modal    
ModalGs 0 1 2 3 73 74 75 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode R                             # I J or R or I J K L               
                       
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<Speed> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

cwcode                                # CW circular move                  
G<11> I<IVAL> J<JVAL> R<ARCRAD> C<STARTANG> 
G<12> C<ENDANG>
end

ccwcode                               # CCW circular move                 
G<11> I<IVAL> J<JVAL> R<ARCRAD> C<STARTANG> 
G<13> C<ENDANG>
end

StartCode                             # Start of the program              
%<0>                            
G<0> G<17> G<71> G<90>          
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
S<Speed> T<Tool> M<6>
G<75> M<Direct>
G<0> X<H> Y<V> M<Cool>
Z<RPlane>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> H<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
G<0> Z<RPlane>
M<25>
G<90> X<ToolH> Y<ToolV> M<5>
S<Speed> M<Tool> M<6>
G<75> M<Direct>
G<0> X<H> Y<V> M<Cool>
G<0> Z<RPlane>
End

EndCode                               # End of the program                
G<0> Z<RPlane>
M<25>
G<90> X<ToolH> Y<ToolV> M<5>
M<2>
%<0>
End
