name ProtoTRAK (Metric)

% 00     
/ 00     
: >8     
N >3     
G >2     
X ->2.>4 
Y ->2.>4 
Z ->2.>4 
A ->2.>4 
I ->2.>4 
J ->2.>4 
K ->2.>4 
Q ->2.>4 
R ->2.>4 
P >40    
F >2.1   
H >2     
D >2     
T >2     
M >2     
S >4     
; 00     

ModalLetters X Y Z F R                # List of letters that are modal    
ModalGs 73 74 76 80 81 82 83 84 85    # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
               
Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

ZRestart? N                           # Y or N  'New cycle if diff. depths

Drill 1                               # Drilling canned/manual cycle      
G<81> Z<D> R<Vclear> F<FRate>
G<0> X<H> Y<V>
end cancel

Peck 1                                # Pecking canned/manual cycle       
G<83> Z<D> Q<VBite> R<Vclear> F<FRate>
G<0> X<H> Y<V>
end cancel

Tap 1                                 # Tapping canned/manual cycle       
G<84> Z<D> R<Vclear> F<Frate> Q<VBite>
G<0> X<H> Y<V>
end cancel

Ream 1                                # Reaming canned/manual cycle       
G<85> Z<D> R<Vclear> F<FRate>
G<0> X<H> Y<V>
end cancel

Bore 1                                # Boring canned/manual cycle        
G<86> Z<D> R<Vclear> F<FRate>
G<0> X<H> Y<V>
end cancel

Back 1                                # Back boring canned/manual cycle   
G<87> Z<D> R<Vclear> F<FRate>
G<0> X<H> Y<V>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>:<Program#>
G<90> G<80>    
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
T<Tool> M<6>
M<Direct> S<Speed>
G<0> X<H> Y<V> 
G<45> Z<D> H<Lcomp> T<NextTool>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> D<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
G<0> M<9>
G<28> Z<ToolD>
M<6>
M<Direct> S<Speed>
G<0> X<H> Y<V>
G<45> Z<D> H<Lcomp> T<NextTool>
M<Cool>
End

EndCode                               # End of the program                
G<0> M<9>
G<28> Z<ToolD>
G<28> X<0> Y<0> M<05>
M<6>
M<30>
%<0>
End

replace "N1 " with ""
