name Mitsubishi M0 (Metric)

/ 00
L >4
N >4
G >2
X ->4.>3
Y ->4.>3
Z ->4.>3
I ->4.>3
J ->4.>3
R ->4.>3 
Q ->4.>3
P ->4.>3 
F >3.>1 
K ->4.>3 
T >2 
M >2 
S >4 
H >2 
D >2 

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 44                           # On & Off codes                    
Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<76> X<H> Y<V> Z<D> R<Vclear> Q<SClear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> Q<SClear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
L<Program#>
/<0> G<91>
/<0> G<28> X<2> Y<-2> Z<-2>
End

1stToolChange                         # First tool change                 
N<Block> T<Tool> M<6>
G<0> G<90> G<Work> G<40> G<80> X<H> Y<V>
G<43> Z<D> H<Lcomp> M<Direct> S<Speed>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> F<Plunge>
G<Side> X<H> Y<V> H<DComp> F<FRate>
end

ExactStop
G<4>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
Z<D> 
end 

ToolChange                            # Secondary tool changes            
G<91> M<9>
G<28> G<44> Z<0> S<100>
N<Block> T<Tool> M<6>
G<0> G<90> G<40> G<80> X<H> Y<V>
G<43> Z<D> H<Lcomp> M<Direct> S<Speed>
M<Cool>
End

EndCode                               # End of the program                
G<91> G<0>
G<28> G<44> Z<0> S<100>
G<28> X<0> Y<0> M<5>
M<30>
End
