name GE 2000 (Metric)

% 00
N >4
G 2
X -4.>3
Y -4.>3
R -4.>3
Z -4.>3
H -4.>3
I -4.>3
J -4.>3
Q -4.>3
P -4.>3
F 3.>2
K -4.>3
D 2
S 2
T 2
M 2
s >5
t >5 ,
u 00

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 5 5                    # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    
Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Inc/Abs G 91 90                       # Inc & Abs char. & values          
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate> 
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
s<Program#> t<Program#> u<0>
G<90> G<17>
End

Replace "s" with "(ID,PROG,"
Replace "u" with ",0)"

1stToolChange                         # First tool change                 
G<90> S<Speed> M<Direct>
T<Tool> M<6> 
G<0> X<H> Y<V> 
Z<D>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> F<FRate>
end 

ExactStop
G<4> X<.01>
end

Outfeed                               # Disable cutter comp               
G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
M<1>
G<49> Z<0> M<5>
T<Tool> 
M<6> S<Speed>
G<0> X<H> Y<V>
G<43> Z<D> H<Lcomp>
M<cool>
End

EndCode                               # End of the program                
M<9>
G<49> Z<0> M<5>
G<0> X<0> Y<0>
M<30>
End
