name GE 1050  (2 1/2 axis MILL) (Metric)

N >4
G 2
X -4.>3
Y -4.>3
A -00 X
B -00 Y
R -4.>3
Z 4.>3
I 4.>3
J 4.>3
Q -4.>3
P -4.>3
F 3.>2
K -4.>3
D 2
S 2
T 2
M 2

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 5 5                    # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    
Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Inc/Abs G 91 90                       # Inc & Abs char. & values          
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate> 
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
End

1stToolChange                         # First tool change                 
G<90> M<Direct>
G<0> X<H> Y<V> S<Speed> T<Tool> M<6>
Z<D>
End

Infeed                                # Enable cutter comp                
G<1> X<H> Y<V> F<FRate> 
G<91>
G<1> A<HVector> B<VVector>
G<Side> I<HVector> J<VVector> D<DComp>
G<90>
G<86> R<-.1> Z<D> F<Plunge> D<LComp> 
F<Frate>
end 

ExactStop
G<4> X<.01>
end

Outfeed                               # Disable cutter comp               
G<87> R<0> Z<D> D<0>
G<40>              
end

ToolChange                            # Secondary tool changes            
G<91> M<9>
G<28> Z<0> M<5>
T<Tool> 
M<6> S<Speed>
G<91> G<45> Z<0> D<LComp> M<Direct> 
G<90> G<92> X<0> Y<0> Z<1> M<Cool>
G<0> X<H> Y<V>
Z<Rplane>
End

EndCode                               # End of the program                
G<91> M<9>
G<28> Z<0> M<5>
G<28> X<0> Y<0> 
T<1>
M<6> S<21>
M<30>
End
