name Bridgeport BOSS (Metric)

% 00
: >5
N >4
G >2
X ->4.>3
x ->4.>3 X
Y ->4.>3  
y ->4.>3 Y
Z ->4.>3  
z >4.>3 Z Incfrom Z 
w >4.>3 Z Incfrom Z 
I ->4.>3
J ->4.>3
R ->4.>3
K ->4.>3
P >40
F >3.1 Limit 0.1 100.0
H >2
T >2
M >2
S >4 Limit 60 4200

ModalLetters X Y Z R                  # List of letters that are modal    
ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 5 5                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ' '                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
               
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

ZRestart? Y                           # Y or N  'New cycle if diff. depths

Drill 1                               # Drilling canned/manual cycle      
G<81> x<H> y<V> z<D> F<FRate>
x<H> y<V>
end cancel

Peck 1                                # Pecking canned/manual cycle       
G<83> x<H> y<V> z<D> w<VBite> F<FRate>
x<H> y<V>
end cancel

Tap 1                                 # Tapping canned/manual cycle       
G<84> x<H> y<V> z<D> F<FRate>
x<H> y<V>
end cancel

Ream 1                                # Reaming canned/manual cycle       
G<85> x<H> y<V> z<D> F<FRate>
x<H> y<V>
end cancel

Bore 1                                # Boring canned/manual cycle        
G<86> x<H> y<V> z<D> F<FRate>
x<H> y<V>
end cancel

Back 1                                # Back boring canned/manual cycle   
G<87> x<H> y<V> z<D> F<FRate>
x<H> y<V>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>                    
:<Program#>             
G<90> G<80> G<40> G<17> 
End

1stToolChange                         # First tool change                 
G<0> G<90> T<Tool> M<26>
G<0> G<97> X<WorkH> Y<WorkV>   
X<H> Y<V>
Z<Vclear> M<Cool>
End

Infeed                                # Enable cutter comp                
G<1> G<Side> X<H> Y<V> H<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
M<CoolantOff>
G<0> G<90> T<Tool> M<26>
G<0> X<H> Y<V>
Z<Vclear> M<Cool>
End

EndCode                               # End of the program                
M<9>
G<0> G<90> M<22>                           
M<02>
End

replace "x" with "X"
replace "y" with "Y"
replace "z" with "Z"
replace "w" with "Z"
