name Cincinatti (Metric)

O >4
N >3
G >2
X ->43
Z ->43
I ->43
K ->43
U ->43
W ->43
P ->43
Q ->43
R ->43
F >33
V 2
T 4
S >4
M >2

ModalGs 0 1 2 3 73 76 80 81 82 83 84 85  # List of g codes that are modal    

First#? N                             # Y or N  'Output 1st sequence no.  
Sequence#s N 1 10 10                  # Char, freq, incr & start          
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 13 14 19                      # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 

ByDiameter? N                         # Y or N  'Output X val. by diameter
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<21>                            # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<22>                              # Circular move clockwise           
Ccw G<23>                             # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<33>
End

Drill                                 # Drilling canned/manual cycle      
G<0> Z<SClear>
G<1> Z<H>
G<0> Z<SClear>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>  
end cancel

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>  
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
end

1stToolChange                         # First tool change                 
O<Comp> G<90> S<Speed> M<42>
G<FeedType> M<31>
G<92> S<MaxRPM>
G<0> X<.4> Z<.4>
M<Direct>
V<77> T<Tool> M<6>
G<0> X<V> Z<H> M<32>
G<SpeedType> R<V> S<Speed>
End

ToolChange                            # Secondary tool changes            
O<Comp> G<90> S<Speed> M<42>
G<FeedType> M<31>
G<92> S<MaxRPM>
G<0> X<.4> Z<.4>
M<Direct>
V<77> T<Tool> M<6>
G<0> X<V> Z<H> M<32>
G<SpeedType> R<V> S<Speed>
End

EndCode                               # End of the program                
G<0> X<EndV> Z<EndH>
M<30>
End

Infeed                                # Enable cutter comp                
G<21> X<V> Z<H> F<FRate>     
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<21> X<V> Z<H> F<FRate>     
end

name Citizen F10 Screw machine. (Metric)

O >4
N >3
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
P ->4.>3
Q ->4.>3
R ->4.>3
F >3.>5
T >2
S >2
M >2

ModalGs 0 1 2 3 4                     # List of g codes that are modal    
Sequence#s N 1 10 10                  # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 52 53 52                      # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                
ByDiameter? Y                         # Y or N  'Output X val. by diameter
RevX? N         
RevZ? Y         
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

Drill                                 # Drilling canned/manual cycle      
G<0> X<-1>
G<1> Z<H> U<0> F<FRate>
G<0> Z<SClear> T<0>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>
end

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>
end

AutoThread                            # Automatic thread canned cycle     
G<33>
End

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
O<Program#>
G<0> G<21> G<99> M<6>
G<69>
G<50> X<-.06> Z<0>
End

1stToolChange                         # First tool change                 
G<FeedType> G<SpeedType> M<Direct> S<Speed>                                                
G<0> Z<SClear>
T<Tool>
G<68>
M<Cool>
G<0> X<V> Z<SClear>
T<Comp> 
End 

ToolChange                            # Secondary tool changes            
T<0>
T<Tool>
G<FeedType> G<SpeedType> M<Direct> S<Speed>
M<Cool>
G<0> Z<SClear>
G<68>
T<Comp> 
End

EndCode                               # End of the program                
M<7>
G<0> X<-.06> Z<0> T<0>
M<2>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>     
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H>              
end

name Fanuc 0T  (Metric)

% 00
O >4
N >3
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
P ->4.>3
A 60 P
Q ->4.>3
q >4 Q
R ->4.>3
F >3.>6
T 2
t 2
S >4
M >2

ModalGs 0 1 2 3 73 76 80 81 82 83 84 85  # List of g codes that are modal    

First#? N                             # Y or N  'Output 1st sequence no.  
Sequence#s N 0 1 1                    # Char, freq, incr & start          
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
Dcomp 41 42 40                        # Left, Right & Cancel m codes      
                     
ByDiameter? Y                         # Y or N  'Output X val. by diameter
RevX? Y
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<3>                               # Circular move clockwise           
Ccw G<2>                              # Circular move counter clockwise   

Drill                                 # Drilling canned/manual cycle      
G<74> R<Depth>
G<74> Z<Depth> F<FRate>                   
end

Peck                                  # Pecking canned/manual cycle       
G<74> R<Depth>
G<74> Z<H> Q<SBite> F<FRate> 
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>   
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>   
end cancel

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>  
end

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> R<StartAng> P<Depth> q<Peck1> F<Frate>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>
O<Program#>
end

1stToolChange                         # First tool change                 
T<Tool>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Tool> t<Lcomp> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> Z<ToolH> T<Tool> t<0> M<9>
M<1>
T<Tool>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Tool> t<Lcomp> M<Cool>
End

EndCode                               # End of the program                
G<0> X<ToolH> Z<ToolH> T<Tool> t<0> M<9>
M<5>
M<30>
%<0>
End

Infeed                                # Enable cutter comp                
G<1> G<Side> X<V> Z<H> F<FRate>        
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>        
end

Replace "t" with ""

name Fanuc 10T Lathe (Metric)

% 00
O >4
N >3
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
A 60 P
P ->4.>3
Q ->4.>3
q >4 Q
R ->4.>3
F >3.>3
T 2
t 2
S >4
M >2

ModalLetters X Z I K F S M            # List of letters that are modal    

ModalGs 0 1 2 3 80 81 82 83 84 85     # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
Dcomp 41 42 40                        # Left, Right & Cancel m codes      

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode R                             # I J or R or I J K L               
                         
ByDiameter? Y                         # Y or N  'Output X val. by diameter
RevX? Y                
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

Drill                                 # Drilling canned/manual cycle      
G<74> R<Depth>
G<74> Z<Depth> F<FRate>                
end

Peck                                  # Pecking canned/manual cycle       
G<74> R<Depth>
G<74> Z<H> Q<SBite> F<FRate>           
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>     
end

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>   
end

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>    
end

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> P<Peck1> Q<VLeave> R<0> F<Frate>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

Infeed                                # Enable cutter comp                
G<1> G<41> X<V> Z<H> F<FRate>              
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<V> Z<H> F<FRate> 
end


Ask <Val1> "Enter the X <radius> home value: " "5.0"
Ask <Val2> "Enter the Z home value: " "10.0"

StartCode                             # Start of the program              
%<0>
O<Program#>
End

1stToolChange                         # First tool change                 
G<0> X<Val1> Z<Val2>
T<Tool> t<0>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Tool> t<Lcomp> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> T<LastTool> t<0> Z<Val2> M<5>
T<Tool> t<0>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Tool> t<Lcomp> M<Cool>
End

EndCode                               # End of the program                
G<0> X<Val1> Z<Val2> T<Tool> t<0> M<5>
M<30>
%<0>
End

Replace "t" with ""

name Fanuc 5T - (For controls that have no 'Drill cycles')  (Metric)

O >4
N >3
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
P ->4.>3
A 60 P
Q ->4.>3
q >4 Q
R ->4.>3
F >3.>3
T 2
S >4
M >2

RevSigns X I                          # List of letters to reverse signs  
ModalGs 0 1 2 3 73 76 80 81 82 83 84 85  # List of g codes that are modal    

First#? N                             # Y or N  'Output 1st sequence no.  
Sequence#s N 0 1 1                    # Char, freq, incr & start          
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                      
ByDiameter? Y                         # Y or N  'Output X val. by diameter
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> R<StartAng> P<Depth> q<Peck1> F<Frate>
end

Drill                                 # Drilling canned/manual cycle      
G<1> Z<H> F<Frate>         
G<0> Z<SClear>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<78> Z<H> F<FRate>                          
end cancel

Ream                                  # Reaming canned/manual cycle       
G<1> Z<H> F<FRate>                          
G<0> Z<SClear>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
O<Program#>
T<0>
G<28> W<0>
G<28> U<0>
G<50> X<0> Z<0>
end

1stToolChange                         # First tool change                 
T<Tool>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> Z<ToolH> M<5>
T<0>
T<Tool>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

EndCode                               # End of the program                
G<0> Z<ToolH>
G<28> W<0> M<5>
G<28> U<0>
M<30>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>        
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>        
end

name Fanuc 6T - (For controls that have no 'Drill cycles') (Metric)

O >4
N >3
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
P ->4.>3
A 60 P
Q ->4.>3
q ->4.>3 Q
R ->4.>3
F >3.>3
T 2
S >4
M >2

RevSigns X I                          # List of letters to reverse signs  
ModalGs 0 1 2 3 73 76 80 81 82 83 84 85  # List of g codes that are modal    

First#? N                             # Y or N  'Output 1st sequence no.  
Sequence#s N 0 1 1                    # Char, freq, incr & start          
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                     
ByDiameter? Y                         # Y or N  'Output X val. by diameter
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> R<StartAng> P<Depth> q<Peck1> F<Frate>
end

Drill                                 # Drilling canned/manual cycle      
G<1> Z<H> F<Frate>        
G<0> Z<SClear>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<78> Z<H> F<FRate>                         
end cancel

Ream                                  # Reaming canned/manual cycle       
G<1> Z<H> F<FRate>                       
G<0> Z<SClear>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
O<Program#>
T<0>
G<28> W<0>
G<28> U<0>
G<50> X<0> Z<0>
end

1stToolChange                         # First tool change                 
T<Tool>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> Z<ToolH> M<5>
T<0>
T<Tool>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

EndCode                               # End of the program                
G<0> Z<ToolH>
G<28> W<0> M<5>
G<28> U<0>
M<30>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>             
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>             
end

name GE 550 Lathe (Absolute) (Metric)

N 3
G 2
X ->43
Z ->43
I ->43
K ->43
F >33
T 3
S 2
M 2

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 43 44 45                      # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            

CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid F<80>                           # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<32>
End

Drill                                 # Drilling canned/manual cycle      
Z<Depth> F<FRate>  
Z<H>
end
Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
Z<H> F<FRate>   
end cancel
Ream                                  # Reaming canned/manual cycle       
Z<H> F<FRate>   
end cancel

Bore                                  # Boring canned/manual cycle        
Z<H> F<FRate>    
Z<SClear>
end

Cancel                                # Cancel a canned/manual cycle      
end

StartCode                             # Start of the program              
G<1> X<WorkV> Z<WorkH> F<80>
End

1stToolChange                         # First tool change                 
G<92> X<0> Z<Length>
G<90> T<Tool> M<Direct>
G<94> S<Speed> M<Cool>
G<1> X<V> Z<H> F<80>
End

ToolChange                            # Secondary tool changes            
G<1> X<0> Z<LastLength> F<80>
T<0> M<1>
G<92> X<0> Z<Length>
G<90> T<Tool> M<Direct>
G<94> S<Speed> M<Cool>
G<1> X<V> Z<H> F<80>
End

EndCode                               # End of the program                
G<1> X<0> Z<LastLength> F<80> M<24>
M<25>
T<0> M<1>
G<1> X<EndV> Z<EndH> F<80>
M<30>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate> 
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate> 
end

name GE 550 Lathe (Incremental) (Metric)

N 3
G >2
X ->4.3
Z ->4.3
I ->4.3
K ->4.3
F >3.3
A >3.3 F
S 2
T 3

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          

Incremental? Y                        # Y or N  'Inc or abs output        
HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            

CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed                                  # Linear move                       
Rapid A<0.1>                          # Rapid positioning word            
Cw                                    # Circular move clockwise           
Ccw                                   # Circular move counter clockwise   

Drill                                 # Drilling canned/manual cycle      
Z<Depth> F<FRate>    
Z<H> A<0.1>
end

AutoThread                            # Automatic thread canned cycle     
G<33>
End

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
Z<H> F<FRate>      
end cancel

Ream                                  # Reaming canned/manual cycle       
Z<H> F<FRate>      
end cancel

Bore                                  # Boring canned/manual cycle        
Z<H> F<FRate>      
Z<SClear> A<0.1>   
end

Cancel                                # Cancel a canned/manual cycle      
end

StartCode                             # Start of the program              
End

1stToolChange                         # First tool change                 
S<9> T<Tool> 
X<V> Z<H> A<0.1>
End

ToolChange                            # Secondary tool changes            
T<0>
X<ToolV> Z<ToolH> A<0.1>
S<9> T<Tool>
X<V> Z<H>
End

EndCode                               # End of the program                
T<0>
X<ToolV> Z<ToolH> A<0.1>
End

Infeed                                # Enable cutter comp                
X<V> Z<H> F<FRate>             
end

ExactStop
end

Outfeed                               # Disable cutter comp               
X<V> Z<H>          
end

name Mitsubishi L0 (Metric)

O >4
N >4
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
D ->4.>3
H >2
F >3.>3
T 4
S >4
M >2

Revsigns X I                          # List of letters to reverse signs  

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

RevTurret2? Y
HCode2 Z
VCode2 X

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                      
ByDiameter? Y                         # Y or N  'Output X val. by diameter
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<32>
End

Drill                                 # Drilling canned/manual cycle      
G<1> Z<H> F<Frate>         
G<0> Z<SClear>
end

Peck                                  # Pecking canned/manual cycle       
none
end 

Tap                                   # Tapping canned/manual cycle       
G<78> Z<H> F<FRate>                        
end cancel

Ream                                  # Reaming canned/manual cycle       
G<1> Z<H> F<FRate>                         
G<0> Z<SClear>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
O<Program#>
T<0>
G<28> W<0>
G<28> U<0>
G<50> X<0> Z<0>
M<1>
End

1stToolChange                         # First tool change                 
T<Tool>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> Z<ToolH> M<5>
T<0>
M<1>

T<Tool>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

EndCode                               # End of the program                
G<0> Z<ToolH> X<ToolV>
G<28> W<0> M<5>
G<28> U<0>
M<30>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>              
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>              
end

name Mori-Seiki w/ Stock stop @ beginning. (Metric)

% 00
N >4
G 2
X ->43
Z ->43
I ->43
K ->43
U ->43
W ->43
P ->43
A 60 P
Q ->43
q ->43 Q
R ->43
F >43
T 4
S >4
M 2

ModalGs 0 1 2 3 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 10 10                  # Char, freq, incr & start          
First#? y                             # Y or N  'Output 1st sequence no.  
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Coolant 8 9 8                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                     
ByDiameter? Y                         # Y or N  'Output X val. by diameter
RevX? y              
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<3>                               # Circular move clockwise           
Ccw G<2>                              # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> R<StartAng> P<Depth> q<Peck1> F<Frate>
end

Drill                                 # Drilling canned/manual cycle      
G<1> Z<Depth> F<FRate>                   
G<0> Z<SClear>
end

Peck                                  # Pecking canned/manual cycle       
None                                    
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>    
end

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>    
end

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>    
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>
G<0> M<1>
G<50> X<0> Z<0>
G<0> T<100>           
G<0> X<0> Z<0> T<101>
M<11>
M<10>
G<0> X<0> Z<0> T<100>
End

1stToolChange                         # First tool change                 
T<Tool>           
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Comp> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> Z<SClear>
X<0> T<LastTool>
T<Tool>                        
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Comp> M<Cool>
End

EndCode                               # End of the program                
G<0> X<0> Z<0> T<Tool>
M<5>
M<30>
%<0>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>        
end

ExactStop
G<4> U<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>        
end

name Yasnac 2000B (Metric)

% 00
N >4 Mult 10
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
P ->4.>3
A 60 P
Q ->4.>3
q ->4.>3 Q
R ->4.>3
F >3.>3
T 2              Valid Tool #'s 01-08
t 2 ""           Valid offset #'s 00-16 
S >4
M >2

RevSigns X I                          # List of letters to reverse signs  
ModalGs 0 1 2 3 73 76 80 81 82        # List of g codes that are modal    

Spaces? N                             # Y or N  'Spaces between words     
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 
Sequence#s N 0 1 1                    # Char, freq, incr & start          
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                   
ByDiameter? Y                         # Y or N  'Output X val. by diameter
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<3>                               # Circular move clockwise           
Ccw G<2>                              # Circular move counter clockwise   

Drill                                 # Drilling canned/manual cycle      
G<1> Z<H> F<Frate>     
G<0> Z<SClear>
end

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> R<StartAng> P<Depth> q<Peck1> F<Frate>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<78> Z<H> F<FRate>                 
end cancel

Ream                                  # Reaming canned/manual cycle       
G<1> Z<H> F<FRate>                  
G<0> Z<SClear>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>   
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>   
end

StartCode                             # Start of the program              
N<Block>
G<50> X<8.0> Z<5.0>
end

1stToolChange                         # First tool change                 
T<Tool> t<Lcomp>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> X<8.0> Z<5.0> M<5>
T<LastTool> t<00>
N<Block>
G<50> X<8.0> Z<5.0>
T<Tool> t<Lcomp>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

EndCode                               # End of the program                
G<0> X<8.0> Z<5.0>
G<28> W<0> M<5>
G<28> U<0> T<00> t<00>
M<30>
%<0>
End
