name Mitsubishi L0 (Metric)

O >4
N >4
G >2
X ->4.>3
Z ->4.>3
I ->4.>3
K ->4.>3
U ->4.>3
W ->4.>3
D ->4.>3
H >2
F >3.>3
T 4
S >4
M >2

Revsigns X I                          # List of letters to reverse signs  

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

RevTurret2? Y
HCode2 Z
VCode2 X

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
                      
ByDiameter? Y                         # Y or N  'Output X val. by diameter
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<32>
End

Drill                                 # Drilling canned/manual cycle      
G<1> Z<H> F<Frate>         
G<0> Z<SClear>
end

Peck                                  # Pecking canned/manual cycle       
none
end 

Tap                                   # Tapping canned/manual cycle       
G<78> Z<H> F<FRate>                        
end cancel

Ream                                  # Reaming canned/manual cycle       
G<1> Z<H> F<FRate>                         
G<0> Z<SClear>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
O<Program#>
T<0>
G<28> W<0>
G<28> U<0>
G<50> X<0> Z<0>
M<1>
End

1stToolChange                         # First tool change                 
T<Tool>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> Z<ToolH> M<5>
T<0>
M<1>

T<Tool>
G<0> X<V>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
Z<H> M<Cool>
End

EndCode                               # End of the program                
G<0> Z<ToolH> X<ToolV>
G<28> W<0> M<5>
G<28> U<0>
M<30>
End

Infeed                                # Enable cutter comp                
G<1> X<V> Z<H> F<FRate>              
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> X<V> Z<H> F<FRate>              
end
