name GE 550 Lathe (Incremental) (Metric)

N 3
G >2
X ->4.3
Z ->4.3
I ->4.3
K ->4.3
F >3.3
A >3.3 F
S 2
T 3

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          

Incremental? Y                        # Y or N  'Inc or abs output        
HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            

CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed                                  # Linear move                       
Rapid A<0.1>                          # Rapid positioning word            
Cw                                    # Circular move clockwise           
Ccw                                   # Circular move counter clockwise   

Drill                                 # Drilling canned/manual cycle      
Z<Depth> F<FRate>    
Z<H> A<0.1>
end

AutoThread                            # Automatic thread canned cycle     
G<33>
End

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
Z<H> F<FRate>      
end cancel

Ream                                  # Reaming canned/manual cycle       
Z<H> F<FRate>      
end cancel

Bore                                  # Boring canned/manual cycle        
Z<H> F<FRate>      
Z<SClear> A<0.1>   
end

Cancel                                # Cancel a canned/manual cycle      
end

StartCode                             # Start of the program              
End

1stToolChange                         # First tool change                 
S<9> T<Tool> 
X<V> Z<H> A<0.1>
End

ToolChange                            # Secondary tool changes            
T<0>
X<ToolV> Z<ToolH> A<0.1>
S<9> T<Tool>
X<V> Z<H>
End

EndCode                               # End of the program                
T<0>
X<ToolV> Z<ToolH> A<0.1>
End

Infeed                                # Enable cutter comp                
X<V> Z<H> F<FRate>             
end

ExactStop
end

Outfeed                               # Disable cutter comp               
X<V> Z<H>          
end
