name Cincinatti (Metric)

O >4
N >3
G >2
X ->43
Z ->43
I ->43
K ->43
U ->43
W ->43
P ->43
Q ->43
R ->43
F >33
V 2
T 4
S >4
M >2

ModalGs 0 1 2 3 73 76 80 81 82 83 84 85  # List of g codes that are modal    

First#? N                             # Y or N  'Output 1st sequence no.  
Sequence#s N 1 10 10                  # Char, freq, incr & start          
Comment ( )                           # Begin End comment char.           

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Spindle 13 14 19                      # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 

                    
ByDiameter? N                         # Y or N  'Output X val. by diameter
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode K I                           # I J or R or I J K L               

Feed G<21>                            # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<22>                              # Circular move clockwise           
Ccw G<23>                             # Circular move counter clockwise   

AutoThread                            # Automatic thread canned cycle     
G<33>
End

Drill                                 # Drilling canned/manual cycle      
G<0> Z<SClear>
G<1> Z<H>
G<0> Z<SClear>
end

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>  
end cancel

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>  
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
end

1stToolChange                         # First tool change                 
O<Comp> G<90> S<Speed> M<42>
G<FeedType> M<31>
G<92> S<MaxRPM>
G<0> X<.4> Z<.4>
M<Direct>
V<77> T<Tool> M<6>
G<0> X<V> Z<H> M<32>
G<SpeedType> R<V> S<Speed>
End

ToolChange                            # Secondary tool changes            
O<Comp> G<90> S<Speed> M<42>
G<FeedType> M<31>
G<92> S<MaxRPM>
G<0> X<.4> Z<.4>
M<Direct>
V<77> T<Tool> M<6>
G<0> X<V> Z<H> M<32>
G<SpeedType> R<V> S<Speed>
End

EndCode                               # End of the program                
G<0> X<EndV> Z<EndH>
M<30>
End

Infeed                                # Enable cutter comp                
G<21> X<V> Z<H> F<FRate>     
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<21> X<V> Z<H> F<FRate>     
end
