name Fanuc 10T Lathe

% 00
O >4
N >3
G >2
X ->3.>4
Z ->3.>4
I ->3.>4
K ->3.>4
U ->3.>4
W ->3.>4
A 60 P
P ->3.>4
Q ->3.>4
q >4 Q
R ->3.>4
F >3.>3
T 2
t 2
S >4
M >2

ModalLetters X Z I K F S M            # List of letters that are modal    

ModalGs 0 1 2 3 80 81 82 83 84 85     # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode Z                               # X or X U  'Horizontal char.       
VCode X                               # Y or Y V  'Vertical char.         
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
SpeedType 96 97                       # CSS and RPM g codes               
FeedType 95 94                        # IPR & IPM g codes                 
Dcomp 41 42 40                        # Left, Right & Cancel m codes      

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode R                             # I J or R or I J K L               
                         
ByDiameter? Y                         # Y or N  'Output X val. by diameter
RevX? Y                
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

Drill                                 # Drilling canned/manual cycle      
G<74> R<Depth>
G<74> Z<Depth> F<FRate>                
end

Peck                                  # Pecking canned/manual cycle       
G<74> R<Depth>
G<74> Z<H> Q<SBite> F<FRate>           
end

Tap                                   # Tapping canned/manual cycle       
G<84> Z<H> F<FRate>     
end

Ream                                  # Reaming canned/manual cycle       
G<85> Z<H> F<FRate>   
end

Bore                                  # Boring canned/manual cycle        
G<74> R<0>
G<74> Z<H> R<SClear> F<FRate>    
end

AutoThread                            # Automatic thread canned cycle     
G<76> A<TParams> Q<VBite> R<0>
G<76> X<V> Z<H> P<Peck1> Q<VLeave> R<0> F<Frate>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

Infeed                                # Enable cutter comp                
G<1> G<41> X<V> Z<H> F<FRate>              
end

ExactStop
G<4> X<.1>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<V> Z<H> F<FRate> 
end


Ask <Val1> "Enter the X <radius> home value: " "5.0"
Ask <Val2> "Enter the Z home value: " "10.0"

StartCode                             # Start of the program              
%<0>
O<Program#>
End

1stToolChange                         # First tool change                 
G<0> X<Val1> Z<Val2>
T<Tool> t<0>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Tool> t<Lcomp> M<Cool>
End

ToolChange                            # Secondary tool changes            
G<0> T<LastTool> t<0> Z<Val2> M<5>
T<Tool> t<0>
G<FeedType> G<SpeedType> S<Speed> M<Direct>
G<0> X<V> Z<H> T<Tool> t<Lcomp> M<Cool>
End

EndCode                               # End of the program                
G<0> X<Val1> Z<Val2> T<Tool> t<0> M<5>
M<30>
%<0>
End

Replace "t" with ""
