name Maho XY Plane (G17)

% 00
N >5
G >2
X ->3.>4   
x ->3.>4 X 
Y ->3.>4   
y ->3.>4 Y 
Z ->3.>4   
z ->3.>4 Z 
I ->3.>4   
J ->3.>4   
K ->3.>4   
B ->3.>4   
F >3.1     
T >2       
M >2       
S >4       
W 00    

ModalLetters X Y z Z F                # List of letters that are modal    
ModalGs 0 1 2 3 81 83 84              # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

Drill 2                               # Drilling canned/manual cycle      
G<81> z<D> B<Rplane> F<Frate> Y<Vclear>
G<79> x<H> z<Sclear> y<V>
G<79> x<H> z<Sclear> y<V>
end        

Peck                                  # Pecking canned/manual cycle       
G<83> Z<D> B<RPlane> F<Frate> Y<Vclear> I<VBite> K<VBite>
G<79> x<H> z<Sclear> y<V> 
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> Z<D> B<RPlane> F<Frate> Y<Vclear> 
G<79> x<H> z<Sclear> y<v>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> Z<D> B<RPlane> F<Frate> Y<Vclear>
G<79> x<H> z<Sclear> y<V>
end cancel

Bore                                  # Boring canned/manual cycle        
end cancel

Back                                  # Back boring canned/manual cycle   
end cancel

Cancel                                # Cancel a canned/manual cycle      
end

StartCode                             # Start of the program              
%<0>        
N<Program#> 
G<18>
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
T<Tool> M<6>
M<Direct> S<Speed>
G<Work>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<1> Y<D> F<Plunge>
G<43> X<H> Y<V> F<FRate>
G<Side>
end

Outfeed                               # Disable cutter comp               
G<40>
G<1> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
G<0> X<ToolH> Y<ToolV> Z<ToolD> M<9>
T<Tool> M<6>
M<Direct> S<Speed>
G<Work>
End

EndCode                               # End of the program                
G<0> X<ToolH> Y<ToolV> Z<ToolD> M<9>
M<30>
W<0>
End

Replace "%" with "%PM"
