name Heidenhain TNC 155 Conversational

O >4                      
e >4                      
i 00                      
N >4 ""                   
t >2                      
u >2                      
L 00                      
l +->3.>4 L               
C >2                      
X +->3.>4
Y +->3.>4
Z +->3.>4 Force
G >2
d >2.1                            
H 00 Z                            
W >2                              
Q ->3.>4                          
R ->3.>4 Force Modal              
r >2                              
F >31 Force Modal                 
M >2 Force Modal
m 00 M                            
S >4.1
s ->3.>4                          
z ->3.>4                          
w >3.>4                           

RevSigns s Q                          # List of letters to reverse signs  

Comment ( )                           # Begin End comment char.           

Replace "O" with "BEGIN PGM "     
Replace "i" with "INCH"
Replace "e" with "END PGM "
Replace "R0 " with "R "
Replace "G41 " with "RL "
Replace "G42 " with "RR "
Replace "G40 " with "R0 F M"
Replace "t" with "TOOL DEF "
Replace "u" with "TOOL CALL "
Replace "W0" with "R F M"         
Replace "W" with "R F M"          
Replace "r0" with "R F6000 M"     
Replace "r" with "R F6000 M"      

Replace "G2 " with "DR- "         
Replace "G3 " with "DR+ "
Replace "C1 " with "CC "
Replace "C0 " with "C "

Replace "d" with "CYCL DEF "      
Replace "EF 0.0 " with "EF 0.0 DRILL"
Replace "EF 1.0" with "EF 1.0 PECKING"
Replace "EF 2.0" with "EF 2.0 TAPPING"
Replace "s" with "SET UP "
Replace "z" with "DEPTH "
Replace "Q" with "PECKG "
Replace "w" with "DWELL "

ModalGs                               # List of g codes that are modal    

Sequence#s N 1 1 1                    # Char, freq, incr & start          
First#? Y                             # Y or N  'Output 1st sequence no.  
Last#? Y                              # Y or N  'Output last sequence no. 

ModalLetters X Y                      # List of letters that are modal    

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Feed L<10>                            # Linear move                       
Rapid L<10> r<0>                      # Rapid positioning word            

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    
                         
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

LTap 5                                # Left handed tapping cycle         
d<2>   
d<2.1> s<RPlane>
d<2.2> z<D>
d<2.3> w<Dwell>
d<2.4> F<FRate>
L<10> X<H> Y<V> R<0> F<600> M<99>
end

Drill 6                               # Drilling canned/manual cycle      
d<0>          
d<0.1> s<RPlane>
d<0.2> z<D>
d<0.3> Q<D>
d<0.4> w<Dwell>
d<0.5> F<FRate>
L<10> X<H> Y<V> R<0> F<600> M<99>
end

Peck 7                                # Pecking canned/manual cycle       
d<1>    p<0>
d<1.1> s<RPlane>
d<1.2> z<D>
d<1.3> Q<VBite>
d<1.4> w<Dwell>
d<1.5> F<FRate>
L<10> X<H> Y<V> r<99>
L<10> X<H> Y<V> W<99>
end

Tap 5                                 # Tapping canned/manual cycle       
d<2>   p<0>
d<2.1> s<RPlane>
d<2.2> z<D>
d<2.3> w<Dwell>
d<2.4> F<FRate>
L<10> X<H> Y<V> R<0> F<600> M<99>
end

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
O<Program#> i<0>
End

1stToolChange                         # First tool change                 
t<Tool> l<0> R<ToolRad>
u<Tool> H<Lcomp> S<Speed>
L<10> X<H> Y<V> R<0> F<600> M<6>
L<10> Z<D> r<13>
End

Infeed                                # Enable cutter comp                
L<10> X<H> Y<V> G<Side> F<FRate> m<0>           
end

LineCode                              # Linear move                       
L<10> X<H> Y<V> Z<D> R<0> F<FRate> m<0>     
end

CWCODE                                # CW circular move                  
C<1> X<HCtr> Y<VCtr>
C<0> X<H> Y<V> G<2> W<0>                   
end

CCWCODE                               # CCW circular move                 
C<1> X<HCtr> Y<VCtr>
C<0> X<H> Y<V> G<3> W<0>                  
end

ExactStop
end

Outfeed                               # Disable cutter comp               
L<10> G<40> X<H> Y<V>   
end

ToolChange                            # Secondary tool changes            
L<10> Z<0> R<0> F<600> M<91>
t<Tool> l<0> R<ToolRad>
u<Tool> H<Lcomp> S<Speed>
L<10> X<H> Y<V> R<0> F<600> M<6>
L<10> Z<D> R<0> F<600> M<13>
End

EndCode                               # End of the program                
L<10> Z<0> R<0> F<600> M<91>
L<10> X<0> Y<0> M<2>
e<Program#> i<0>
End
