name Fanuc 6MB

% 00      
/ 00      
O >4      
N >4      
G >2      
X ->3.>4  
Y ->3.>4  
Z ->3.>4  
A ->3.>4  
I ->3.>4  
J ->3.>4  
K ->3.>4  
Q ->3.>4  
R ->3.>4  
P >40     
F >3.1    
H >2      
D >2      
T >2      
M >2      
S >4      
c 00

ModalLetters X Y Z F R                # List of letters that are modal    
ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
               
Spaces? N                             # Y or N  'Spaces between words     
Incremental? Y                        # Y or N  'Inc or abs output        
CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<Frate> Q<VBite>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> X<H> Y<V> Z<D> Q<VBite> R<Vclear> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate> Q<VBite>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
%<0>                   
O<Program#>
c<0>
G<91> G<28> Z<0>
G<90> G<80> G<40> G<17>
End

Replace "c" with "(TOOL 1 IN SPINDLE)"

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
M<Direct> S<Speed>
G<0> G<Work> X<H> Y<V> 
T<NextTool>
G<43> Z<D> H<Lcomp>
M<Cool>
End

Infeed                                # Enable cutter comp                
G<Side> X<H> Y<V> D<DComp> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
G<91> G<28> Z<0> M<9>
M<6>
M<Direct> S<Speed>
G<90> G<0> X<H> Y<V>
T<NextTool>
G<43> Z<D> H<Lcomp>
M<Cool>
End

EndCode                               # End of the program                
G<91> G<28> Z<0> M<9>
G<91> G<28> X<0> Y<0> M<5>
T<Tool1>
M<6> 
M<30>
%<0>
End
