name DeVlieg

N 4
G 2
D 2
X -34
Y -34
Z -34
R -34
W -34
I 34
J 34
K 34
H 34
F 31
S 2
M 2
B 3

ModalGs 0 1 2 3 80 81 82 84 85        # List of g codes that are modal    

Sequence#s N 1 1 100                  # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

LTap                                  # Left handed tapping cycle         
G<74> X<H> Y<V> Z<D> R<Vclear> F<FRate>  
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> X<H> Y<V> Z<D> R<Vclear> F<FRate>  
end cancel

Peck                                  # Pecking canned/manual cycle       
none
end

Tap                                   # Tapping canned/manual cycle       
G<84> X<H> Y<V> Z<D> R<Vclear> F<FRate>  
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> X<H> Y<V> Z<D> R<Vclear> F<FRate>  
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> X<H> Y<V> Z<D> R<Vclear> F<FRate>  
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> X<H> Y<V> Z<D> R<Vclear> F<FRate>  
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
G<90>
G<0> D<0> X<0> Y<0> Z<0> W<ToolD>
End

1stToolChange                         # First tool change                 
G<0> D<LComp> X<H> Y<V>
G<17>
W<0> S<Speed> M<Cool>
Z<VClear> M<Direct>
End

ToolChange                            # Secondary tool changes            
G<0> W<0>
D<0> Z<0> M<5>
M<0>
G<0> D<LComp> Z<0> W<ToolD>
G<0> X<H> Y<V> W<0> S<Speed> M<Cool>
D<LComp> Z<VClear> M<Direct>
G<17>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> F<Plunge>
G<Side> X<H> Y<V> D<DComp> F<FRate> 
end

ExactStop
G<4> X<.01>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V> 
Z<D>
end

EndCode                               # End of the program                
G<0> W<ToolD>
D<0> Z<0> M<5>
M<30>
End
