name CintiMatic AC-8 (60 cam positions)

% 00
N >4
G >2
W >2 Limit 1 60
X ->34  
Y ->3.>4
Z 00 "" 
I ->34  
J ->34  
P ->34  
Q ->34  
T >4    
M >2    
S >4    
F >31   

ModalLetters X Y Z F M                # List of letters that are modal    
ModalGs 0 2 3 73 74 76 78 79 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 1 5 5                    # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode                                 # Depth char.                       
FeedCode F                            # Feed rate char.                   
Cdc P Q                               # Cincinnati style DComp vectors    

Comment ( )                           # Begin End comment char.           

Spindle 13 14 15                      # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               
                
Spaces? N                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

Drill                                 # Drilling canned/manual cycle      
G<81> 
X<H> Y<V> F<FRate>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84>
X<H> Y<V> F<Frate>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> 
X<H> Y<V> F<FRate>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80> W<00>
end

StartCode                             # Start of the program              
%<0>
End

ExactStop
G<4>
end

1stToolChange                         # First tool change                 
M<01>
G<0> S<Speed> F<Frate>
X<H> Y<V> M<Direct>
G<78> W<Tool>
End

Infeed                                # Enable cutter comp                
G<1> X<H> Y<V> F<FRate> P<Hcdc> Q<Vcdc>
end

Outfeed                               # Disable cutter comp               
G<1> X<H> Y<V> P<Hcdc> Q<Vcdc>
end

Replace "G1" with "G79"

ToolChange                            # Secondary tool changes            
G<81> M<26>
G<80> W<00>
M<00>
S<Speed> F<Frate>
X<H> Y<V> M<Direct>
G<78> W<Tool>
End

EndCode                               # End of the program                
G<81> M<26>
G<80> W<00>
M<5>
M<2>
%<0>
End
