name Bridgeport TNC-151

N >4       
% >4
G 2       
X +->3,>4   
Y +->3,>4   
Z +->3,>4   
I +->3,>4   
J +->3,>4   
K +->3,>4 
T >2
L +->3,>4  
R +>3,>4
F >31     
f 4 F
M >2       
S >4 
a >3,>4                     
b >3,>4 
c >3,>4 
d >3 
e >3>1
* 00                        

ModalLetters G X Y Z F                # List of letters that are modal    

ModalGs                               # List of g codes that are modal    

Sequence#s N 1 10 10                  # Char, freq, incr & start          
First#? N                             # Y or N  'Output 1st sequence no.  
Last#? N                              # Y or N  'Output last sequence no. 

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

Feed G<01>                            # Linear move                       
Rapid G<01> f<3999>                   # Rapid positioning word            
Inc/Abs G 91 90                       # Inc & Abs char. & values          
CtrCode I J                           # I J or R or I J K L               

Spaces? Y                             # Y or N  'Spaces between words     
Incremental? N                        # Y or N  'Inc or abs output        
CtrIncremental? N                     # Y or N  'Inc or abs I & J         
ByQuadrants? Y                        # Y or N  'Break arcs at quadrants  

Each *<0>                             # End of block word                 

Drill 3                               # Drilling canned/manual cycle      
G<01> Z<Vclear> f<3999>
G<83> a<Vclear> b<D> c<Vbite> d<Dwell> e<FRate>
G<79>
G<01> X<H> Y<V> M<99>
end cancel

Peck 3                                # Pecking canned/manual cycle       
G<01> Z<Vclear> f<3999>
G<83> a<Vclear> b<D> c<Vbite> d<Dwell> e<FRate>
G<79>
G<01> X<H> Y<V> M<99>
end cancel

Cancel                                # Cancel a canned/manual cycle      
end

Replace "a" with "P01 -"
Replace "b" with "P02 -"
Replace "c" with "P03 -"
Replace "d" with "P04 "
Replace "e" with "P05 "
Replace "--" with "-"

CwCode                                # CW circular move                  
G<90> I<HCtr> J<VCtr>
G<02> X<H> Y<V>
end

CcwCode                               # CCW circular move                 
G<90> I<HCtr> J<VCtr>
G<03> X<H> Y<V>
end

StartCode                             # Start of the program              
%<Program#> G<70>                         
End

ExactStop
end

1stToolChange                         # First tool change                 
G<99> T<Tool> L<0> R<ToolRad>
T<Tool> G<17> S<Speed>
G<01> X<H> Y<V> f<3999> M<Direct>
G<01> Z<D>
End

Infeed                                # Enable cutter comp                
G<01> G<Side> X<H> Y<V> F<FRate>
end

Outfeed                               # Disable cutter comp               
G<01> G<40> X<H> Y<V>
end

ToolChange                            # Secondary tool changes            
G<38> M<25>
G<99> T<Tool> L<0> R<ToolRad>
T<Tool> G<17> S<Speed>
G<01> X<H> Y<V> f<3999> M<Direct>
G<01> Z<D> 
End

EndCode                               # End of the program                
G<38> M<25>
N<9999> %<Program#> G<70>
End
