name Bandit III

N >4
G 2
T 2
X ->3.>4
Y ->3.>4
Z ->3.>4
I ->3.>4
J ->3.>4
Q 2 P
R ->3.>4
P ->3.>4
F >3.>1
M 2
L >2
W >2
C >2
S >4

ModalGs 0 1 2 3 73 74 76 80 81 82 83 84 85  # List of g codes that are modal    

Sequence#s N 0 1 1                    # Char, freq, incr & start          

HCode X                               # X or X U  'Horizontal char.       
VCode Y                               # Y or Y V  'Vertical char.         
Dcode Z                               # Depth char.                       
FeedCode F                            # Feed rate char.                   

Comment ( )                           # Begin End comment char.           

Spindle 3 4 5                         # Cw, ccw & stop m codes            
Coolant 8 9 7                         # On, Off & Mist m codes            
DComp 41 42 40                        # Left, Right & Cancel m codes      
LComp 43 49                           # On & Off codes                    

CtrIncremental? Y                     # Y or N  'Inc or abs I & J         
ByQuadrants? N                        # Y or N  'Break arcs at quadrants  
CtrCode I J                           # I J or R or I J K L               

Feed G<1>                             # Linear move                       
Rapid G<0>                            # Rapid positioning word            
Cw G<2>                               # Circular move clockwise           
Ccw G<3>                              # Circular move counter clockwise   

LTap                                  # Left handed tapping cycle         
G<74> Z<D> F<FRate>   
G<0> X<H> Y<V>
end cancel

Drill                                 # Drilling canned/manual cycle      
G<81> Z<D> I<VBite> F<FRate>  
G<0> X<H> Y<V>
end cancel

Peck                                  # Pecking canned/manual cycle       
G<83> Z<D> I<VBite> F<FRate> 
G<0> X<H> Y<V>
end cancel

Tap                                   # Tapping canned/manual cycle       
G<84> Z<D> F<FRate>    
G<0> X<H> Y<V>
end cancel

Ream                                  # Reaming canned/manual cycle       
G<85> Z<D> F<FRate>   
G<0> X<H> Y<V>
end cancel

Bore                                  # Boring canned/manual cycle        
G<86> Z<D> F<FRate>   
G<0> X<H> Y<V>
end cancel

Back                                  # Back boring canned/manual cycle   
G<87> Z<D> F<FRate>   
G<0> X<H> Y<V>
end cancel

Cancel                                # Cancel a canned/manual cycle      
G<80>
end

StartCode                             # Start of the program              
End

1stToolChange                         # First tool change                 
G<90>
N<Block> G<0> X<ToolH> Y<ToolV> M<Direct> F<Frate>
T<Tool> Z<D>
G<0> X<H> Y<V>
End

ToolChange                            # Secondary tool changes            
Q<99>
M<0>
N<Block> G<90>
G<0> X<ToolH> Y<ToolV> M<Direct> F<Frate>
T<Tool> Z<D>
G<0> X<H> Y<V>
End

Infeed                                # Enable cutter comp                
G<1> Z<D> F<Plunge>
G<Side> X<H> Y<V> F<FRate> 
end

ExactStop
G<4>
end

Outfeed                               # Disable cutter comp               
G<1> G<40> X<H> Y<V>  
Z<D>
end

EndCode                               # End of the program                
Q<28>
Q<99>
M<2>
End
