macro_file INTERCEP;
/* ******************************************************************************
Contains a means of intercepting and filtering keystrokes for various purposes.

	INTERCEP - The main intercept macro.

The remaining macros are simply examples of just a few things that can be done
with INTERCEP:

	ASCICODE - Constantly displays the ASCII code of the current character.
	CURCOLOR - An interface for setting the color for HIGHLITE.
	HILITE - Displays the cursor line in a different color.
	ASM_CAPS - Provides an interesting language support for Assembly.

								Copyright 1989 by American Cybernetics, Inc.
****************************************************************************** */

macro INTERCEP {
/* ******************************************************************************
															 MULTI-EDIT MACRO

NAME:  INTERCEP

DESCRIPTION:  Intercepts all keystrokes and can be used to process keystrokes
based on whatever conditions the user wishes to add.  Once inside this macro,
the only way you can get out is by exiting the editor, or pressing a special
"hot" key currently defined as <ALTQ>.

							 (C) Copyright 1989 by American Cybernetics, Inc.
****************************************************************************** */

/* This simply initializes the color for the macro HILITE */
if(  (GLOBAL_INT('Cursor_Line_Color') == 0)  ) {
	SET_GLOBAL_INT('Cursor_Line_Color',Error_Color);
};

DO_READ_KEY:

/* Here is a macro that unconditionally gets run after every keystroke. It
displays the ASCII code of the character at the cursor in decimal and Hex.  If
you don't like it, simply comment out the following line and the similar line
before the GOTO EXIT statement. */
	Run_Macro('ASCICODE /D=Y');

/* Here is another macro that unconditionally gets run after every keystroke. It
displays the Line the Cursor is on in a user defined color.  Here again, you
may wish to comment it out, along with the matching exit call.
	Run_Macro('HILITE /D=Y');
 */
	Read_Key;

/* Here is the "escape hatch" */
  if(  ((Key1 == 0) & (Key2 == 16))  ) {                  /* if ALT-Q was pressed */
		Run_Macro('ASCICODE /D=N');
/*    Run_Macro('HILITE /D=N'); */
		Goto EXIT;
  };

/* The following is an example of a special condition to process keystrokes if the
extension is .ASM for assembly language editing.  If you don't like this one,
comment out the next 3 lines plus the 6th line down.
	IF (Caps(Get_Extension(File_Name)) = 'ASM') THEN
		Run_Macro('ASM_CAPS');
  ELSE */
/* Otherwise, the keystroke will be passed to the editor normally */
		Pass_Key(Key1,Key2);
/*  END; */

/* This is to trap any errors generated by macros */
  if(  (Error_Level)  ) {
		Run_Macro('Meerror');
  };

	Goto DO_READ_KEY;

EXIT:
};

macro ASCICODE {
/* ******************************************************************************
															 MULTI-EDIT MACRO

NAME:  ASCICODE

DESCRIPTION:  Constantly displays the decimal and hex ASCII code of the
character at the cursor.

							 (C) Copyright 1989 by American Cybernetics, Inc.
****************************************************************************** */

  int ASCII_Code,X_Offset;
  str Ascii_String;
/* Set up X coordinate according to window coordinates and whether or not window
is in document mode */
    X_Offset = Win_X1 + (Doc_Mode * 7) + 3;

/* Check to see if parameter was passed to turn display off */
  if(  (Parse_Str('/D=',MParm_Str) == 'N')  ) {
		Write('',X_Offset,Win_Y1,0,B_color);
		Goto EXIT;
  };

/* Store decimal ascii value in integer and string variables */
    ASCII_Code = Ascii(Cur_Char);
    Ascii_String = Str(Ascii_Code);
/* Write outlines and zero character padding for decimal */
		Write('D:   H:',X_Offset,Win_Y1,0,B_color);
		Write('000',X_Offset + 2,3,0,S_color);
/* Write decimal value */
		Write(Ascii_String,X_Offset + 5 - Length(Ascii_String),Win_Y1,0,
																																	S_color);
/* Write hex value */
    Write(Copy('0123456789ABCDEF',(ASCII_Code >> 4) + 1,1) +
                            Copy('0123456789ABCDEF',(ASCII_Code & 15) + 1,1),
																		X_Offset + 8,Win_Y1,0,S_color);
EXIT:
};

macro CURCOLOR {
/* ******************************************************************************
															 MULTI-EDIT MACRO

NAME:  CURCOLOR

DESCRIPTION:  Allows the user to set the background and foreground colors for
the macro HILITE

							 (C) Copyright 1989 by American Cybernetics, Inc.
****************************************************************************** */
  int X1,Y1,Temp_Fore,Temp_Back;

/* Initialize variables */
  X1 = 20;
  Y1 = 4;
  Temp_Fore = GLOBAL_INT('Cursor_Line_Color') & $0F;
  Temp_Back = GLOBAL_INT('Cursor_Line_Color') >> 4;
	Put_Box(X1,Y1 - 1,X1 + 34,Y1 + 4,0,M_B_Color,'CURSOR LINE COLOR',true);

COLOR_LOOP:
  write(' to change foreground color  ',X1 + 1,Y1,0,(Temp_Back << 4) | (Temp_Fore & $0F));
  write('|27|26 to change background color. ',X1 + 1,Y1 + 1,0,(Temp_Back << 4) | (Temp_Fore & $0F));
  write('<ENTER> to accept, <ESC> aborts',X1 + 1,Y1 + 2,0,(Temp_Back << 4) | (Temp_Fore & $0F));

	Read_Key;

  if(  (Key1 == 27)  ) {
		Goto EXIT;
  };
  if(  (Key1 == 13)  ) {
    SET_GLOBAL_INT('Cursor_Line_Color',(Temp_Back << 4) | (Temp_Fore & $0F));
		Goto EXIT;
  };
  if(  (Key1 == 0)  ) {
    if(  (Key2 == 72)  ) {
			--Temp_Fore;
    };
    if(  (Key2 == 80)  ) {
			++Temp_Fore;
    };
    if(  (Key2 == 75)  ) {
			--Temp_Back;
    };
    if(  (Key2 == 77)  ) {
			++Temp_Back;
    };
  };
	Goto Color_LOOP;

EXIT:
	Kill_Box;

};

macro HILITE {
/* ******************************************************************************
															 MULTI-EDIT MACRO

NAME:  HILITE

DESCRIPTION:  Constantly displays the line the cursor is on in a user
definable color.  This macro cannot address the problem of horizontal
scrolling or changed lines.

							 (C) Copyright 1989 by American Cybernetics, Inc.
****************************************************************************** */

  if(  (Parse_Str('/D=',MParm_Str) == 'N')  ) {
/* Exit routine, sets display back to normal */
		Redraw;
		Goto EXIT;
  };

  if(  (Marking)  ) {
		Goto EXIT;
  };

  str Temp_String[132];
  int Width,Jx,Jy,Jz,Reverse;

  Reverse = ((Global_Int('Cursor_Line_Color') & $0F) << 4) | (GLOBAL_INT('Cursor_Line_Color') >> 4);

  Width = Win_X2 - Win_X1 - 1;

/* If an arrow key was pressed, then write the previously hilited line in normal
colors */
  if(  ((Key1 == 0) & (Key2 == 72))  ) { /* Up Arrow */
/* Go to the line below */
		Down;
/* Store displayable part of the line into a variable with enough space padding
to allow for blank lines.  The padding is neccesary if the background color is
different than the regular background color */
    Temp_String = Copy(Get_Line +
				'                                                                  ' +
				'                                                                  '
																											,1,Width);
/* Change the tab characters to space characters */
    if(  Not(Display_Tabs)  ) {
			Tabs_To_Spaces(Temp_String);
    };
/* Write it */
    if(  (Line_Changed)  ) {
			Write(Temp_String,Win_X1 + 1,WhereY,0,C_Color);
    } else {
			Write(Temp_String,Win_X1 + 1,WhereY,0,T_Color);
    };
/* If we happen to be on a line with a block defined, then write the block in
reverse video */
    if(  (Block_Stat)  ) {
      if(  ((C_Line >= Block_Line1) & (C_Line <= Block_Line2))  ) {
        if(  (Block_Stat == 1)  ) { /* Line blocks */
					Write(Temp_String,Win_X1 + 1,WhereY,0,H_Color);
        };
        if(  (Block_Stat == 2)  ) { /* Column blocks */
          if(  (Block_Col1 <= Width)  ) {
            Jx = Block_Col2;
            if(  (Jx > Width)  ) {
              Jx = Width;
            };
						Write(Copy(Temp_String,Block_Col1,Jx - Block_Col1 + 1),
																			Block_Col1,WhereY,0,H_Color);
          };
        };
        if(  (Block_Stat == 3)  ) { /* Stream blocks */
          Jx = 1;
          Jy = Width;
          Jz = Jx;
          if(  (C_Line == Block_Line1)  ) {
            if(  (Block_Col1 <= Width)  ) {
              Jx = Block_Col1;
              Jy = Width - Block_Col1 + 1;
              Jz = Block_Col1;
            } else {
							Goto SKIP1;
            };
          };
          if(  (C_Line == Block_Line2)  ) {
            if(  (Block_Col2 <= Width)  ) {
              Jy = Block_Col2 - Jx + 1;
            } else {
              Jy = Width - Jx + 1;
            };
          };
					Write(Copy(Temp_String,Jx,Jy),Jz,WhereY,0,H_Color);
        };
      };
    };
SKIP1:
/* Now, move back where your supposed to be! */
		Up;
  };
  if(  ((Key1 == 0) & (Key2 == 80))  ) { /* Down Arrow */
		Up;
    Temp_String = Copy(Get_Line +
				'                                                                  ' +
				'                                                                  '
																											,1,Width);
    if(  Not(Display_Tabs)  ) {
			Tabs_To_Spaces(Temp_String);
    };
    if(  (Line_Changed)  ) {
			Write(Temp_String,Win_X1 + 1,WhereY,0,C_Color);
    } else {
			Write(Temp_String,Win_X1 + 1,WhereY,0,T_Color);
    };
    if(  (Block_Stat)  ) {
      if(  ((C_Line >= Block_Line1) & (C_Line <= Block_Line2))  ) {
        if(  (Block_Stat == 1)  ) { /* Line blocks */
					Write(Temp_String,Win_X1 + 1,WhereY,0,H_Color);
        };
        if(  (Block_Stat == 2)  ) { /* Column blocks */
          if(  (Block_Col1 <= Width)  ) {
            Jx = Block_Col2;
            if(  (Jx > Width)  ) {
              Jx = Width;
            };
						Write(Copy(Temp_String,Block_Col1,Jx - Block_Col1 + 1),
																			Block_Col1,WhereY,0,H_Color);
          };
        };
        if(  (Block_Stat == 3)  ) { /* Stream blocks */
          Jx = 1;
          Jy = Width;
          Jz = Jx;
          if(  (C_Line == Block_Line1)  ) {
            if(  (Block_Col1 <= Width)  ) {
              Jx = Block_Col1;
              Jy = Width - Block_Col1 + 1;
              Jz = Block_Col1;
            } else {
							Goto SKIP2;
            };
          };
          if(  (C_Line == Block_Line2)  ) {
            if(  (Block_Col2 <= Width)  ) {
              Jy = Block_Col2 - Jx + 1;
            } else {
              Jy = Width - Jx + 1;
            };
          };
					Write(Copy(Temp_String,Jx,Jy),Jz,WhereY,0,H_Color);
        };
      };
    };
SKIP2:
		Down;
  };
/* This is the same as above, except it is written to the screen in the alternate
color */
    Temp_String = Copy(Get_Line +
				'                                                                  ' +
				'                                                                  '
																											,1,Width);
    if(  Not(Display_Tabs)  ) {
			Tabs_To_Spaces(Temp_String);
    };
	Write(Temp_String,Win_X1 + 1,WhereY,0,Global_Int('Cursor_Line_Color'));
    if(  (Block_Stat)  ) {
      if(  ((C_Line >= Block_Line1) & (C_Line <= Block_Line2))  ) {
        if(  (Block_Stat == 1)  ) { /* Line blocks */
					Write(Temp_String,Win_X1 + 1,WhereY,0,Reverse);
        };
        if(  (Block_Stat == 2)  ) { /* Column blocks */
          if(  (Block_Col1 <= Width)  ) {
            Jx = Block_Col2;
            if(  (Jx > Width)  ) {
              Jx = Width;
            };
						Write(Copy(Temp_String,Block_Col1,Jx - Block_Col1 + 1),
																			Block_Col1,WhereY,0,Reverse);
          };
        };
        if(  (Block_Stat == 3)  ) { /* Stream blocks */
          Jx = 1;
          Jy = Width;
          Jz = Jx;
          if(  (C_Line == Block_Line1)  ) {
            if(  (Block_Col1 <= Width)  ) {
              Jx = Block_Col1;
              Jy = Width - Block_Col1 + 1;
              Jz = Block_Col1;
            } else {
							Goto SKIP3;
            };
          };
          if(  (C_Line == Block_Line2)  ) {
            if(  (Block_Col2 <= Width)  ) {
              Jy = Block_Col2 - Jx + 1;
            } else {
              Jy = Width - Jx + 1;
            };
          };
					Write(Copy(Temp_String,Jx,Jy),Jz,WhereY,0,Reverse);
        };
      };
    };
SKIP3:
EXIT:
};

macro ASM_CAPS {
/* ******************************************************************************
															 MULTI-EDIT MACRO

NAME:  ASM_CAPS

DESCRIPTION:  This macro is called by INTERCEP.MAC.  It will simulate a forced
"Caps Lock" until a ';' comment delimiter is encountered.  Then it will pass
the keystrokes unaltered.  When <ENTER> is pressed, it will go back to caps lock.

							 (C) Copyright 1989 by American Cybernetics, Inc.
****************************************************************************** */

  int New_Key1,Caps_Lock;

/* Initialize Caps_Lock flag */
  if(  (First_Run)  ) {
		Set_Global_Int('Caps_Lock',True);
  };

/* Save keycode into a variable */
  New_Key1 = Key1;
  if(  (New_Key1 == 13)  ) {                             /* if <ENTER> was pressed */
		Set_Global_Int('Caps_Lock',True);
  };
  if(  (New_Key1 == 59)  ) {                                   /* if ; was pressed */
		Set_Global_Int('Caps_Lock',False);
  };
/* Check status of Caps_Lock flag */
  if(  (Global_Int('Caps_Lock'))  ) {
    if(  (New_Key1 > 96) & (New_Key1 < 123)  ) {
/* "Upper case" the key code */
      New_Key1 = New_Key1 - 32;
    };
  };
/* Pass the altered keystoke to the editor */
	Pass_Key(New_Key1,Key2);

};
