macro_file Fortran;
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	FORTRAN

Description: Language support for FORTRAN

FOR_IND - Smart indenting for FORTRAN
FORTEMP - Template editing for FORTRAN
FORMTCH - A dummy macro so you won't get 5001 error message.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

macro For_Ind {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:   For_ind

Description:  This macro will perform a smart indent when the <ENTER> key is
							pressed.  This macro is called by the macro CR.
							If checks for the keywords:
											IF DO & ELSE

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str c_str;
	int t_col, T_col2;

	T_col2 = c_col;
	First_word;
	T_col = c_col;
	if(  (t_col2 < t_col)  ) {
		t_col = t_col2;
		goto_col(T_Col);
	}

	if(  (Cur_char != '|0')  ) {
		set_indent_level;
	}
	t_col = c_col;

	c_str = remove_space(Get_word(' (123456789'));
	Goto_col(T_col2);
	Cr;

	if(  (T_col != T_col2) & (Length(C_str) != 0) & (pos(caps(c_str),'IF DO ELSE') != 0)  ) {
		Indent;
	}

}

/*****************************************************************************
																MULTI-EDIT MACRO

Name:	FORSETX

Description:	Fortran file name extension initialization code.  Sets up the .FOR
							specific global variable for template expansion

		'C=' = Expansion case type.
								0 = case sensitive.    Keyword  - case sensitive
																			Expansion - verbatim.
								1 = case insensitive.  Keyword  - case insensitive
																			Expansion - All caps.
								2 = case insensitive.  Keyword  - case insensitive
																			Expansion - First letter caps.
								3 = case insensitive.  Keyword  - case insensitive
																			Expansion - dependent on keyword.
		'M=' = Minimum number of characters in keyword required for an
							expansion to occurr.
	238 - '' = Parameter delimiter
	127 - '' = Field separator
	 20 - '' = Carriage return (Run CR macro)
	174 - '' = Carriage return (Goto starting column)
	196 - '' = Record cursor position
	 17 - '' = Move cursor left
	 16 - '' = Move cursor right
	 24 - '' = Move cursor up
	 25 - '' = Move cursor down
	 64 - '@' = Translate next character literally
	168 - '' = Remember current column position
	173 - '' = Goto remembered column number
	240 - '' = Goto starting column
	241 - '' = Toggle Insert mode
	251 - '' = Run macro:  "/*C^CCOMMENT"
	252 - '' = Expand template for preceding character (be carefull about
								infinite loops)

							 (C) Copyright 1992 by American Cybernetics, Inc.
******************************************************************************/
macro FORSETX
{
	if ( "" == Global_Str("!FOR.Tmplt0") )
	Set_Global_Str("!FOR.Tmplt0", "C=3M=1"+
	"if () thenendif"+
	"include ''"+
	"do  = ,enddo"+
	"else"+
	"subroutine ()end;"+
	"");
}

macro Formtch {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	FORMTCH

Description: A dummy macro since there is no matching for FORTRAN

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
}
