macro_file DBASE;
/*******************************************************************************
														MULTI-EDIT MACRO FILE

Name: DBASE

Description:  Contains language support for DBase style languages.

DBAMTCH - Construct matching for DBase
DBA_IND - Smart indenting for DBase
DBATEMP - Template editing for DBase

							 (C) Copyright 1991 by American Cybernetics, Inc.
********************************************************************************/

macro DBAMTCH TRANS {
/*******************************************************************************
																MULTI-EDIT MACRO

 Name: DBAMTCH

 Description:  This macro will match occurances of
		 IF / ENDIF, CASE / ENDCASE, DO WHILE / ENDDO, TEXT / ENDTEXT, ( / )
							 (C) Copyright 1991 by American Cybernetics, Inc.
													 Contributed by Julius Nadas
*******************************************************************************/

	str  Str1, Str2, S_var,            /* Match strings */
					 Xtr2,
					 T_Str, S_str, FStr ;

	int  Direction,   /* 1 = search forward, 0 = backward */
					 B_Count,     /* Match count.  0 = match found */
					 I_var,       /* just a temp variable */
					 temp_case,   /* save ignore_case flag */
					 S_Res;      /* Search result */

	Refresh = False;     /* Turn screen refresh off */
	temp_case = ignore_case;
	ignore_case = true;

	Mark_Pos;             /*  return here if no find  */

	if(  (Cur_Char == '(')  ) {   /* Setup match for '(' */
		Str1 = '(';
		Xtr2 = ')';
		Str2 = ')';
		Direction = 1;
		S_Str = '(||)||$';
		GOTO Start_Match;
	}

	if(  (Cur_Char == ')')  ) {   /* Setup match for ')' */
		Str1 = ')';
		Xtr2 = '(';
		Str2 = '(';
		Direction = 0;
		S_Str = Str1+'||'+Str2+'||%';
		GOTO Start_Match;
	}

 /* go to the first word */
	goto_col(1);

Match_Construct:

	if(XPos(Cur_Char,'|9|255 ',1)) {      /* If we are on a blank space then find a word */
		Word_Right;
	}

	T_Str = copy( Caps( Get_Word('|9|255 ') ),1,4);  /* Get the current word */

	if(  (T_Str == 'ELSE') | (T_Str == 'IF')  ) {
		Str1 = 'IF';
		Xtr2 = 'ENDIF';
		Str2 = 'ENDI';
		S_Str = '{%[|9 ]*IF}||{%[|9 ]*ENDI}';
		GOTO Match_Down;
	}

	if(  T_Str == 'ENDI'  ) {
		Str1 = 'ENDI';
		Xtr2 = 'IF';
		Str2 = 'IF';
		S_Str = '{%[|9 ]*IF}||{%[|9 ]*ENDI}';
		GOTO Match_Up;
	}

	if(  (T_Str == 'TEXT')  ) {
		Str1 = 'TEXT';
		Xtr2 = 'ENDTEXT';
		Str2 = 'ENDT';
		S_Str = '{%[|9 ]*TEXT}||{%[|9 ]*ENDT}';
		GOTO Match_Down;
	}

	if(  T_Str == 'ENDT'  ) {
		Str1 = 'ENDT';
		Xtr2 = 'TEXT';
		Str2 = 'TEXT';
		S_Str = '{%[|9 ]*TEXT}||{%[|9 ]*ENDT}';
		GOTO Match_Up;
	}

	if(  T_Str == 'DO'  ) {
		Word_Right;
		T_Str = copy( Caps( Get_Word(' ') ),1,4);  /* Get the current word */
	}

	/*  check for either a DO WHILE or a simple WHILE or LOOP or EXIT  */
	if(  (T_Str == 'WHIL') | (T_Str == 'EXIT') | (T_Str == 'LOOP')  ) {
		Str1 = 'DO WHIL';
		Xtr2 = 'ENDDO';
		Str2 = 'ENDD';
		S_Str = '{%[|9 ]*DO[|9 ]+WHIL}||{%[|9 ]*ENDD}';
		GOTO Match_Down;
	}

	/*  check for either a DO CASE or  simple CASE or OTHERWISE  */
	if(  (T_Str == 'CASE') | (T_str == 'OTHE')  ) {
		Str1 = 'DO CASE';
		Xtr2 = 'ENDCASE';
		Str2 = 'ENDC';
		S_Str = '{%[|9 ]*DO[|9 ]+CASE}||{%[|9 ]*ENDC}';
		GOTO Match_Down;
	}

	if(  T_Str == 'ENDD'  ) {
		Str1 = 'ENDD';
		Xtr2 = 'DO WHILE';
		Str2 = 'DO WHIL';
		S_Str = '{%[|9 ]*DO[|9 ]+WHIL}||{%[|9 ]*ENDD}';
		GOTO Match_Up;
	}

	if(  T_Str == 'ENDC'  ) {
		Str1 = 'ENDC';
		Xtr2 = 'DO CASE';
		Str2 = 'DO CASE';
			S_Str = '{%[|9 ]*DO[|9 ]+CASE}||{%[|9 ]*ENDC}';
		GOTO Match_Up;
	}

	Make_Message('Looking for the Next Control Word');
	GOTO_MARK;
	S_Str = '{%[|9 ]*IF}||{%[|9 ]*ENDI}||{%[|9 ]*DO[|9 ]+WHIL}||{%[|9 ]*DO[|9 ]+CASE}||{%[|9 ]*ENDD}||{%[|9 ]*ENDC}||{%[|9 ]*TEXT}||{%[|9 ]*ENDT}';
	S_Res = Search_Fwd(S_Str,0);
	if(  (S_res == true)  ) {
		Make_Message('Next Control Word');
	} else {
		Make_message('no control word found');
	}
	GOTO Macro_Exit;

Match_Up:
	Direction = 0;
	goto_col(1);
	GOTO Start_Match;

Match_Down:
	Direction = 1;

Start_Match:
	Reg_Exp_Stat = True;
	Ignore_Case = True;
	B_Count = 1;
	S_Res = 1;
	Make_Message('Matching...  Press <ESC> to Stop.');
	Working;

MATCH_LOOP:   /* Main loop */

					/* If the <ESC> key is pressed while matching then abort the search */
	if(  check_key  ) {
		if(  key1 == 27  ) {
			GOTO_MARK;
			Make_Message('Match Aborted.');
			goto macro_exit;
		}
	}

	if(  B_Count == 0  ) { /* If match count is 0 then success */
		GOTO Found_Exit;
	}

	if(  Direction == 1  ) { /* Perform search based on direction */
		Right;
		S_Res = Search_Fwd(S_Str,0);
	} else {
		Left;
		S_Res = Search_Bwd(S_Str,0);
	}

	if(  S_Res == 0  ) {   /* If search failed then exit */
		GOTO Error_Exit;
	}

	FStr = Found_Str;
	tabs_to_spaces( fstr );
	fstr = Caps(remove_space( fstr ));

											 /* Get the found string and capitalize it */
												/* If we found the first match string then */
	if(  FStr == STR1  ) {
		B_Count = B_Count + 1;   /* Inc the match count */
	} else {
		if(  FStr == STR2  ) {          /* If we found the second match string then */
			B_Count = B_Count - 1;    /*   decrement the match count */
		}                         /* ignore everything else */
	}

	GOTO Match_Loop;


Error_Exit:     /* Go here for unsucessfull match */
	GOTO_MARK;
	Make_Message('Did Not Find '+Xtr2);
	GOTO Macro_Exit;

Found_Exit:     /* Go here for successfull match */
	POP_MARK;
	Make_Message('Found '+Xtr2);

Macro_Exit:
	ignore_case = temp_case;
	Refresh = True;
	Redraw;
}
/*  */
macro DBA_IND {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: DBA_IND

Description:  This macro will perform a smart indent when the <ENTER> key is
	pressed.  This macro is called by the macro CR.

							 (C) Copyright 1991 by American Cybernetics, Inc.
												Contributed by Terry Lovegrove
*******************************************************************************/

	str C_STR,S_STR,U_STR;          /* Word to check for indent */
	int T_COL,T_COL2;   /* Temp column positions */
	int sig_char_found,ind_count,jx;
	char found_char;

	MARK_POS;
	Reg_Exp_Stat = True;
	Refresh = False;
	LEFT;
	/* Check to see if we are inside a comment */
	/* Don't go back farther than 20 lines in order to improve speed */
	if(  Search_Bwd('@{||@}||{(@*}||{@*)}',20)  ) {
		if(  (Cur_Char == '{') | (Cur_Char == '(')  ) {
			if(  (Cur_Char == '{')  ) {
				RIGHT;
			} else {
				RIGHT;
				RIGHT;
			}
			Set_Indent_Level;
			GOTO_MARK;
			Refresh = True;
			CR;
			GOTO MAC_EXIT;
		}
	}

	GOTO_MARK;
	MARK_POS;

	CALL SKIP_CLIP_NOISE1;
	FOUND_CHAR = CUR_CHAR;
	GOTO_MARK;
	REFRESH = TRUE;

	T_COL2 = C_COL;         /* Store current position */
	FIRST_WORD;              /* Go to the first word on the line */
	T_COL = C_COL;          /* Store this position */

	if(  T_COL2 < T_COL  ) {   /* If this position is greater than the original */
		T_COL = T_COL2;       /*   then store the original */
		GOTO_COL(T_COL);       /*   and go there */
	}
	if(  Cur_Char != '|0'  ) { /* If we are beyond the end of the line then */
		SET_INDENT_LEVEL;      /*   set the indent level */
	}

	T_COL = C_COL;          /* Store the current position */
													 /* Get the current word, removing any extra space */
	C_STR = ' ' + REMOVE_SPACE(CAPS( GET_WORD('; (,{') )) + ' ';
	if(  XPOS(C_STR,' PROCEDURE FUNCTION DO CASE NEXT OTHERWISE IF FOR ',1) &
		XPOS(' END',C_STR,1) &
		XPOS(' ELSE',C_STR,1)  ) {
		GOTO MAC_EXIT;
	}
	Right;
	S_STR = ' ' + REMOVE_SPACE(CAPS( GET_WORD('; (,{') )) + ' ';
	GOTO_COL(T_COL2);        /* Put cursor on original position */
	CR;                      /* Perform a carriage return */

													 /* If word in this list and not just after */
													 /*  a DO CASE then pull out the word */
	if(  (XPOS(' END',C_STR,1) != 0) |
		(XPOS(' ELSE',C_STR,1) != 0) |
		(XPOS(C_STR,' NEXT OTHERWISE ',1)!= 0)  ) {
			CALL OUTDENT;
			if(  C_STR == ' ENDCASE '  ) {
				CALL OUTDENT;
			}
	} else {
			if(  (C_STR == ' CASE ')  ) {
				Mark_Pos;
				Up;
				Up;
				First_Word;
				U_STR = ' ' + REMOVE_SPACE(CAPS( GET_WORD('; (,{') )) + ' ';
				Right;
				U_STR = U_STR + REMOVE_SPACE(CAPS( GET_WORD('; (,{') )) + ' ';
				Goto_Mark;
				if(  (U_STR != ' DO CASE ')  ) {
					CALL OUTDENT;
				}
			}
	}
														/* If DO CASE or DO WHILE indent */
	if(  (C_STR == ' DO ') & (XPOS(S_STR,' CASE WHILE ',1)!= 0)  ) {
		INDENT;
	}

													 /* If the word is in this list indent */
	if(  (T_COL != T_COL2) & (LENGTH(C_STR) != 0) &
		((XPOS(C_STR,' PROCEDURE FUNCTION FOR CASE OTHERWISE IF ',1)!= 0)
		| (XPOS(' ELSE',C_STR,1) != 0))  ) {
			INDENT;
	}
	GOTO MAC_EXIT;

OUTDENT:
				UNDENT;
				T_Col = C_Col;
				UP;
				MARK_POS;
				FIRST_WORD;
				T_Col = C_Col - T_Col;
				GOTO_MARK;
				if(  T_Col > 0  ) { DEL_CHARS(T_Col); }
				DOWN;
				RET;

SKIP_CLIP_NOISE1:

/*  Here we look for the nearest preceding nonblank character.  If it is a
	closing comment then we find the  nearest opening comment.
	 */

	if(  (SEARCH_BWD('[~ ]', 1))  ) {
		if(  (CUR_CHAR == ')')  ) {
			LEFT;
			if(  (CUR_CHAR == '*')  ) {
				JX = SEARCH_BWD('(@*', 0);
				LEFT;
				GOTO SKIP_CLIP_NOISE1;
			}
			RIGHT;
			SIG_CHAR_FOUND = TRUE;
			GOTO EXIT_SKIP_CLIP;
		} else {
			if(  (CUR_CHAR == '}')  ) {
				JX = SEARCH_BWD('@{', 0);
				LEFT;
				GOTO SKIP_CLIP_NOISE1;
			}
		}

		SIG_CHAR_FOUND = TRUE;
		GOTO EXIT_SKIP_CLIP;
	}

/*  If we failed to find a nonblank character on the current line, and the
	cursor is on line 1, we failed to find a significant character; otherwise,
	we back up a line and try again.  */

	if(  (C_LINE == 1)  ) {
		SIG_CHAR_FOUND = FALSE;
		GOTO EXIT_SKIP_CLIP;
	}
	UP;
	EOL;
	GOTO SKIP_CLIP_NOISE1;

EXIT_SKIP_CLIP:
	REFRESH = TRUE;
	RET;



MAC_EXIT:

}
/*  */
macro DBATEMP TRANS {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: DBATEMP

Description: Creates DBase language constructs based on a single character
						 to the left of the current cursor position.
The following constructs are created from the following templates:

			HEADF   creates a complete header for a function
			HEADP   creates a complete header for a program file
			f       For/Next
			c       CLEAR
			*       *******************************
			I       If/EndIF
			IE      If/Else/EndIF
			D       DO/EndDO
			DW      DO/While/EndDO
			DC      DO/Case/CASE/OTHERWISE/EndCASE
			F       FUNCTION/RETURN .T.
			FP      FUNCTION/RETURN .T./PARAMETERS
			U       USE
			UI      USE  INDEX
			P       PROCEDURE/RETURN
			PA      PARAMETERS
			PR      PRIVATE
			PU      PUBLIC
			PP      PROCEDURE/PARAMETERS/RETURN
			C       CASE
			@       @ ,
			@       @ Row()+1,
			@S      @ ,  SAY
			@G      @ ,   GET
			@P      @ ,   PROMPT
			K       KEYBOARD
			NORM    SET COLOR TO
			RS      RESTORE SCREEN
			RSF     RESTORE SCREEN FROM
			REV     SET COLOR TO N/W
			S       SELECT
			SS      SAVE SCREEN
			SST     SAVE SCREEN TO
			SE      SET ESCAPE OFF
			SC      SET CURSOR OFF
			SK      SET KEY
			SKT     SET KEY  TO
			SW      SET WRAP  OFF
			SM      SET MESSAGE TO
			SO      SET ON
			SF      SET OFF

							 (C) Copyright 1991 by American Cybernetics, Inc.
													Contributed by Terry Lovegrove
*******************************************************************************/

	int Temp_Col,Temp_Row,
					Temp_Insert,F_Col,
					S_Pos,Par_Cnt;
	str XStr,C_STR;
	char F_CHAR;

	Temp_Insert = Insert_Mode;
	Insert_Mode = True;
	Temp_Col = C_COL;
	FIRST_WORD;
	F_Char = Caps(Cur_Char);
	C_STR = Caps(GET_WORD(' '));
	FIRST_WORD;
	Set_Indent_Level;
	F_Col = C_Col;

	if(  (C_Str == 'HEADF')  ) {
		GOTO MAKEHEADF;
	}

	if(  (C_Str == 'HEADP')  ) {
		GOTO MAKEHEADP;
	}

	/* Case sensitive templates */
	if(  (Cur_Char == 'f')  ) {
		GOTO MAKEFOR;
	}
	if(  (Cur_Char == 'c')  ) {
		GOTO MAKECLEAR;
	}

	/* Non-Case sensitive templates */
	if(  (F_Char == '*')  ) {
		Del_Char;
		TEXT('*******************************');Cr;
		Goto End_of_Mac;
	}

	if(  (F_Char == 'I')  ) {
		GOTO MAKEIF;
	}

	if(  (F_Char == 'D')  ) {
		GOTO MAKEDO;
	}

	if(  (F_Char == 'U')  ) {
		GOTO MAKEUSE;
	}

	if(  (F_Char == 'P')  ) {
		if(  (C_Str == 'PA')  ) {
			 GOTO MAKEPARAM;
		} else {
		if(  (C_Str == 'PR')  ) {
			 GOTO MAKEPRIV;
		} else {
		if(  (C_Str == 'PU')  ) {
			 GOTO MAKEPUBL;
		} else {
			 GOTO MAKEPROCEDURE;
		}};}
	}

	if(  (F_Char == 'F')  ) {
		GOTO MAKEFUNCTION;
	}

	if(  (F_Char == 'C')  ) {
		GOTO MAKECASE;
	}

	if(  (F_Char == '@')  ) {
		GOTO MAKEAT;
	}

	if(  (F_Char == 'K')  ) {
		GOTO MAKEKEYBRD;
	}

	if(  (C_STR == 'NORM')  ) {
		GOTO MAKENORM;
	}

	if(  (F_Char == 'R')  ) {
		if(  (C_Str == 'REV')  ) {
			GOTO MAKEREV;
		} else {
			GOTO MAKEREST;
		}
	}

	if(  (F_Char == 'S')  ) {
		if(  Length(C_Str) > 1  ) {
			if(  XPos('S',C_Str,2) != 0  ) {
				 GOTO MAKESAVE;
			} else {
				 GOTO MAKESET;
			}
		} else {
			GOTO MAKESELECT;
		}
	}

	/* Not a proper template string */
	Goto_Col(Temp_Col);
	GOTO END_OF_MAC;

MAKEIF:
	Del_Chars(Length(C_Str));
	TEXT('If ');
	EOL;
	Cr;
	Cr;
	TEXT('EndIF');
	Up;
	Goto_Col(F_Col);
	if(  C_Str == 'IE'  ) {
		Cr;
		TEXT('Else ');
		EOL;
		Cr;
		Goto_Col(F_Col);
		Up;
		Up;
	}
	Indent;
	GOTO END_OF_MAC;

MAKEDO:
	Del_Chars(Length(C_Str));
	TEXT('DO ');

	if(  C_Str == 'DW'  ) {
		TEXT('While ');

		EOL;
	} else {
		if(  C_Str == 'DC'  ) {
			TEXT('Case');

			Cr;
			Cr;
			Indent;
			TEXT('OTHERWISE');

			Cr;
			Undent;
			TEXT('EndCASE');

			Goto_Col(F_Col);
			Up;
			Up;
			Indent;
			TEXT('CASE ');

			GOTO END_OF_MAC;
		}
	}
	Cr;
	Cr;
	TEXT('EndDO');

	Up;
	Goto_Col(F_Col);
	Indent;
	GOTO END_OF_MAC;


MAKEFOR:
	Del_Char;
	TEXT('For ');

	Cr;
	Cr;
	TEXT('Next');

	Goto_Col(F_Col);
	Up;
	Indent;
	GOTO END_OF_MAC;

MAKECLEAR:
	Del_Char;
	TEXT('CLEAR');

	Cr;
	GOTO END_OF_MAC;

MAKEUSE:
	Del_Chars(Length(C_Str));
	TEXT('USE ');

	EOL;
	if(  C_Str == 'UI'  ) {
		TEXT(' INDEX ');
	} else {
		Cr;
	}
	GOTO END_OF_MAC;

MAKEPARAM:
	Del_Chars(Length(C_STR));
	TEXT('PARAMETERS ');
	EOL;
	Cr;
	GOTO END_OF_MAC;

MAKEPRIV:
	Del_Chars(Length(C_STR));
	TEXT('PRIVATE ');
	Eol;
	Cr;
	GOTO END_OF_MAC;

MAKEPUBL:
	Del_Chars(Length(C_STR));
	TEXT('PUBLIC ');
	Eol;
	Cr;
	GOTO END_OF_MAC;

MAKEPROCEDURE:
	Del_Chars(Length(C_STR));
	TEXT('PROCEDURE ');

	EOL;
	Cr;
	Cr;
	TEXT('RETURN');

	Goto_Col(F_Col);
	Up;
	Indent;
	if(  C_STR == 'PP'  ) {
		TEXT('PARAMETERS ');

	}
	GOTO END_OF_MAC;

MAKEFUNCTION:
	Del_Chars(Length(C_STR));
	TEXT('FUNCTION ');

	EOL;
	Cr;
	Cr;
	TEXT('RETURN .T.');

	Goto_Col(F_Col);
	Up;
	Indent;
	if(  C_STR == 'FP'  ) {
		TEXT('PARAMETERS ');

	}
	GOTO END_OF_MAC;

MAKECASE:
	Del_Char;
	TEXT('CASE ');

	EOL;
	Cr;
	Indent;
	GOTO END_OF_MAC;

MAKEAT:
	Del_Chars(Length(C_Str));
	Temp_Col = FALSE;
	if(  XPos('R',C_Str,2) != 0  ) {
		TEXT('@ Row()+1,');
	} else {
		TEXT('@ ,');
		Temp_Col = C_Col - 1;
	}

	if(  XPos('C',C_Str,2) != 0  ) {
		CALL GETCOL;
		TEXT(XSTR);
	} else {
		TEXT('  ');
		Temp_Col = C_Col - 1;
	}
	if(  XPos('S',C_Str,2) != 0  ) {
		TEXT('SAY ');
		if(  Temp_Col == 0  ) {
			Temp_Col = C_Col;
		}
	}
	if(  XPos('G',C_Str,2) != 0  ) {
		if(  XPos('S',C_Str,2)  ) {
			EOL;
		}
		TEXT (' GET ');
	}
	if(  XPos('P',C_Str,2) != 0  ) {
		if(  XPos('S',C_Str,2)  ) {
			EOL;
		}
		TEXT (' PROMPT ');
	}

	if(  Temp_Col  ) {
		Goto_Col(Temp_Col);
	}
	GOTO END_OF_MAC;

GETCOL:
	MARK_POS;
	Up;
	Goto_Col(1);
	if(  Search_Fwd('{,}{ *}{(}',1) == 0  ) {
		XStr = ' ';
	} else {
		Right;
		S_Pos = C_Col;
		Par_Cnt = 0;
		while(  Search_Fwd('[()]',1) != 0  ) {
			if(  Cur_Char == ')'  ) {
				Par_Cnt = Par_Cnt - 1;
			} else {
			if(  Cur_Char == '('  ) {
				Par_Cnt = Par_Cnt + 1;
			}};
			Right;
		}
		if(  Par_Cnt == 0  ) {
			XStr = Copy(GET_LINE,S_Pos,C_Col-S_Pos);
		} else {
			XStr = ' ';
		}
	}
	GOTO_MARK;
	RET;

MAKEKEYBRD:
	Del_Chars(Length(C_Str));
	TEXT('KEYBOARD ');
	Eol;
	Cr;
	GOTO END_OF_MAC;

MAKEREV:
	Del_Chars(Length(C_Str));
	TEXT('SET COLOR TO N/W');
	Cr;
	GOTO END_OF_MAC;

MAKENORM:
	Del_Chars(Length(C_Str));
	TEXT('SET COLOR TO ');
	Eol;
	Cr;
	GOTO END_OF_MAC;

MAKEREST:
	Del_Chars(Length(C_Str));
	TEXT('RESTORE SCREEN ');
	if(  XPos('F',C_Str,3) != 0  ) {
		TEXT('FROM ');
	}
	Eol;
	Cr;
	GOTO END_OF_MAC;

MAKESAVE:
	Del_Chars(Length(C_Str));
	TEXT('SAVE SCREEN ');
	if(  XPos('T',C_Str,3) != 0  ) {
		TEXT('TO ');
	}
	EOL;
	Cr;
	GOTO END_OF_MAC;

MAKESET:
	Del_Chars(Length(C_Str));
	TEXT('SET');
	if(  XPos('E',C_Str,2) != 0  ) {
		TEXT(' ESCAPE');
	} else {
	if(  XPos('C',C_Str,2) != 0  ) {
		TEXT(' CURSOR');
	} else {
	if(  XPos('K',C_Str,2) != 0  ) {
		TEXT(' KEY ');
		EOL;
		if(  XPos('T',C_Str,2) != 0  ) {
			TEXT(' TO');
		}
		GOTO END_OF_MAC;
	} else {
	if(  XPos('W',C_Str,2) != 0  ) {
		TEXT(' WRAP ');
	} else {
	if(  XPos('M',C_Str,2) != 0  ) {
		TEXT(' MESSAGE TO ');
		GOTO END_OF_MAC;
	}};
	}};}
	if(  XPos('O',C_Str,2) != 0  ) {
		TEXT(' ON');
	} else {
		TEXT(' OFF');
	}
	Cr;
	GOTO END_OF_MAC;


MAKESELECT:
	Del_Chars(Length(C_Str));
	TEXT('SELECT ');
	EOL;
	Cr;
	GOTO END_OF_MAC;

MAKEHEADF:
	Del_Chars(Length(C_Str));
	TEXT('*******************************');Cr;
	TEXT('*Function:');Cr;
	TEXT('*Notes:');Cr;
	TEXT('*');Cr;Cr;
	TEXT('*** End of          ***********');Cr;
	Up;Up;Up;Up;Up;Eol;Right;
	GOTO End_of_mac;

MAKEHEADP:
	Del_Chars(Length(c_Str));
	TEXT('*******************************');Cr;
	TEXT('*File:');Cr;
	TEXT('*Author:');Cr;
	TEXT('*Date:');Cr;
	TEXT('*Version:');cr;
	TEXT('*Notes:');cr;
	TEXT('*');Cr;Cr;
	TEXT('*** End of         .PRG *******');Cr;
	Up;Up;Up;Up;Up;Up;Up;Up;Eol;Right;
	GOTO End_of_mac;

END_OF_MAC:
	Insert_Mode = Temp_Insert;

}
