
; Residue Template for HyperChem.
;
; $Id: chem.tpl,v 1.6 1993/03/17 06:44:22 hurst Exp $
;
; [ResidueName]{A|N|*}
; A - amino acid
; N - nucleic acid
; * - unclassified residued.
; e.g.  ALANINE would be [ALA]A
;       CYTOSINE would be [C]N
;


;
;
;*****************************************************************************
;*
;*	Templates for Amino Acids
;*
;*****************************************************************************
;


; ALANINE
[ALA]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000	imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50
CB:		C	(CA s 1HB s 2HB s 3HB s)	\
				opls	C3	0.0000	\
				amber	CT	-0.0980	\
				bio+	CH3E	0.0000	\
				int CA   1.525 N    111.10
1HB 1DB HB1:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
3HB 3DB HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090


; GLYCINE
[GLY]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s 1HA s 2HA s C s)		\
				opls	JQ	0.2000	\
				amber	CT	0.0350	\
				bio+	CH2E	0.1000	\
				int N    1.449 -3   121.90 -2   180.00
1HA 1DA HA1:	H	(CA s)				\
				opls	none	\
				amber	HC	0.0320	\
				bio+	none	\
				int CA   1.090
2HA 2DA HA2:	H	(CA s)				\
				opls	none	\
				amber	HC	0.0320	\
				bio+	none	\
				int CA   1.090
C:		C  3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    110.40 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00


; SERINE
[SER]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(OG s CA s 1HB s 2HB s)		\
				opls	C2	0.2650	\
				amber	CT	0.0180	\
				bio+	CH2E	0.2500	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.1190	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.1190	\
				bio+	none	\
				int CB   1.090
OG:		O	(CB s HG s)			\
				opls	OH	-0.7000	\
				amber	OH	-0.5500	\
				bio+	OH1	-0.6500	\
				int CB   1.430 CA   109.47 N    180.00
HG DG HOG:		H	(OG s)				\
				opls	HO	0.4350	\
				amber	HO	0.3100	\
				bio+	H	0.4000	\
				int OG   0.960 CB   109.47 CA   180.00


; THREONINE
[THR]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s OG1 s CG2 s HB s)		\
				opls	JZ	0.2650 imp CG2 CB CA OG1\
				amber	CT	0.1700	\
				bio+	CH1E	0.2500	imp CB OG1 CG2 CA \
				int CA   1.525 N    111.10 -3    60.00
HB DB 1HB:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0820	\
				bio+	none	\
				int CB   1.090
OG1:		O	(CB s HG1 s)			\
				opls	OH	-0.7000	\
				amber	OH	-0.5500	\
				bio+	OH1	-0.6500	\
				int CB   1.430 CA   109.47 N     60.00
HG1 DG1 HOG:	H	(OG1 s)				\
				opls	HO	0.4350	\
				amber	HO	0.3100	\
				bio+	H	0.4000	\
				int OG1  0.960 CB   109.47 CA   180.00
CG2:		C	(CB s 1HG2 s 2HG2 s 3HG2 s)	\
				opls	C3	0.0000	\
				amber	CT	-0.1910	\
				bio+	CH3E	0.0000	\
				int CB   1.525 CA   109.47 N    300.00
1HG2 1DG2 HG21:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0650	\
				bio+	none	\
				int CG2  1.090
2HG2 2DG2 HG22:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0650	\
				bio+	none	\
				int CG2  1.090
3HG2 3DG2 HG23:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0650	\
				bio+	none	\
				int CG2  1.090


; LEUCINE
[LEU]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s CG s 1HB s 2HB s)		\
				opls	C2	0.0000	\
				amber	CT	-0.0610	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0330	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0330	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s HG s CD1 s CD2 s)		\
				opls	JZ	0.0000	imp CD1 CG CB CD2\
				amber	CT	-0.0100	\
				bio+	CH1E	0.0000	imp CG CD2 CD1 CB \
				int CB   1.525 CA   109.47 N    180.00
HG DG:		H	(CG s)				\
				opls	none	\
				amber	HC	0.0310	\
				bio+	none	\
				int CG   1.090 CB   109.50 CA   300.00
CD1:		C	(CG s 1HD1 s 2HD1 s 3HD1 s)	\
				opls	C3	0.0000	\
				amber	CT	-0.1070	\
				bio+	CH3E	0.0000	\
				int CG   1.525 CB   109.47 CA    60.00
1HD1 1DD1 HD11:	H	(CD1 s)				\
				opls	none	\
				amber	HC	0.0340	\
				bio+	none	\
				int CD1  1.090
2HD1 2DD1 HD12:	H	(CD1 s)				\
				opls	none	\
				amber	HC	0.0340	\
				bio+	none	\
				int CD1  1.090
3HD1 3DD1 HD13:	H	(CD1 s)				\
				opls	none	\
				amber	HC	0.0340	\
				bio+	none	\
				int CD1  1.090
CD2:		C	(CG s 1HD2 s 2HD2 s 3HD2 s)	\
				opls	C3	0.0000	\
				amber	CT	-0.1070	\
				bio+	CH3E	0.0000	\
				int CG   1.525 CB   109.47 CA   180.00
1HD2 1DD2 HD21:	H	(CD2 s)				\
				opls	none	\
				amber	HC	0.0340	\
				bio+	none	\
				int CD2  1.090
2HD2 2DD2 HD22:	H	(CD2 s)				\
				opls	none	\
				amber	HC	0.0340	\
				bio+	none	\
				int CD2  1.090
3HD2 3DD2 HD23:	H	(CD2 s)				\
				opls	none	\
				amber	HC	0.0340	\
				bio+	none	\
				int CD2  1.090


; ISOLEUCINE
[ILE ILU]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG1 s CG2 s CA s HB s)		\
				opls	JZ	0.0000	imp CG2 CB CA CG1\
				amber	CT	-0.0120	\
				bio+	CH1E	0.0000	imp CB CG1 CG2 CA \
				int CA   1.525 N    109.47 -3    60.00
HB DB 1HB:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0220	\
				bio+	none	\
				int CB   1.090
CG1:		C	(CB s CD1 s 1HG1 s 2HG1 s)	\
				opls	C2	0.0000	\
				amber	CT	-0.0490	\
				bio+	CH2E	0.0000	\
				int CB   1.525 CA   109.47 N    180.00
1HG1 1DG1 HG11:	H	(CG1 s)				\
				opls	none	\
				amber	HC	0.0270	\
				bio+	none	\
				int CG1  1.090
2HG1 2DG1 HG12:	H	(CG1 s)				\
				opls	none	\
				amber	HC	0.0270	\
				bio+	none	\
				int CG1  1.090
CG2:		C	(CB s 1HG2 s 2HG2 s 3HG2 s)	\
				opls	C3	0.0000	\
				amber	CT	-0.0850	\
				bio+	CH3E	0.0000	\
				int CB   1.525 CA   109.47 N     60.00
1HG2 1DG2 HG21:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0290	\
				bio+	none	\
				int CG2  1.090
2HG2 2DG2 HG22:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0290	\
				bio+	none	\
				int CG2  1.090
3HG2 3DG2 HG23:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0290	\
				bio+	none	\
				int CG2  1.090
CD1:		C	(CG1 s 1HD1 s 2HD1 s 3HD1 s)	\
				opls	JV	0.0000	\
				amber	CT	-0.0850	\
				bio+	CH3E	0.0000	\
				int CG1  1.525 CB   109.47 CA   180.00
1HD1 1DD1 HD11 HD1:	H	(CD1 s)				\
				opls	none	\
				amber	HC	0.0280	\
				bio+	none	\
				int CD1  1.090
2HD1 2DD1 HD12 HD2:	H	(CD1 s)				\
				opls	none	\
				amber	HC	0.0280	\
				bio+	none	\
				int CD1  1.090
3HD1 3DD1 HD13 HD3:	H	(CD1 s)				\
				opls	none	\
				amber	HC	0.0280	\
				bio+	none	\
				int CD1  1.090


; VALINE
[VAL]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s CG1 s CG2 s HB s)		\
				opls	JZ	0.0000	imp CG1 CB CA CG2\
				amber	CT	-0.0120	\
				bio+	CH1E	0.0000	imp CB CG2 CG1 CA \
				int CA   1.525 N    111.10 -3    60.00
HB DB 1HB:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0240	\
				bio+	none	\
				int CB   1.090
CG1:		C	(CB s 1HG1 s 2HG1 s 3HG1 s)	\
				opls	C3	0.0000	\
				amber	CT	-0.0910	\
				bio+	CH3E	0.0000	\
				int CB   1.525 CA   109.47 N     60.00
1HG1 1DG1 HG11:	H	(CG1 s)				\
				opls	none	\
				amber	HC	0.0310	\
				bio+	none	\
				int CG1  1.090
2HG1 2DG1 HG12:	H	(CG1 s)				\
				opls	none	\
				amber	HC	0.0310	\
				bio+	none	\
				int CG1  1.090
3HG1 3DG1 HG13:	H	(CG1 s)				\
				opls	none	\
				amber	HC	0.0310	\
				bio+	none	\
				int CG1  1.090
CG2:		C	(CB s 1HG2 s 2HG2 s 3HG2 s)	\
				opls	C3	0.0000	\
				amber	CT	-0.0910	\
				bio+	CH3E	0.0000	\
				int CB   1.525 CA   109.47 N    180.00
1HG2 1DG2 HG21:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0310	\
				bio+	none	\
				int CG2  1.090
2HG2 2DG2 HG22:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0310	\
				bio+	none	\
				int CG2  1.090
3HG2 3DG2 HG23:	H	(CG2 s)				\
				opls	none	\
				amber	HC	0.0310	\
				bio+	none	\
				int CG2  1.090


; ASPARAGINE
[ASN ASX]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	0.0000	\
				amber	CT	-0.0860	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
CG:		C	(OD1 d ND2 s CB s)		\
				opls	C	0.5000	imp CB ND2 CG OD1 \
				amber	C	0.6750	imp CB ND2 CG OD1 \
				bio+	C	0.4500	imp CG OD1 ND2 CB \
				int CB   1.522 CA   111.10 N    180.00
OD1 AD1:	O	(CG d)				\
				opls	O	-0.5000	\
				amber	O	-0.4700	\
				bio+	O	-0.4500	\
				int CG   1.229 CB   120.50 CA     0.00
ND2 AD2:	N	(CG s 1HD2 s 2HD2 s)		\
				opls	N	-0.8500	imp CG 1HD2 ND2 2HD2 \
				amber	N	-0.8670	imp CG 1HD2 ND2 2HD2 \
				bio+	NH2	-0.6000	imp ND2 1HD2 2HD2 CG \
				int CG   1.335 CB   116.60 CA   180.00
1HD2 1DD2 HD21 HND1:	H	(ND2 s)				\
				opls	H	0.4250	\
				amber	H	0.3440	\
				bio+	H	0.3000	\
				int ND2  1.010 CG   119.80 CB     0.00
2HD2 2DD2 HD22 HND2:	H	(ND2 s)				\
				opls	H	0.4250	\
				amber	H	0.3440	\
				bio+	H	0.3000	\
				int ND2  1.010 CG   119.80 CB   180.00


; GLUTAMINE
[GLN GLX]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s CG s 1HB s 2HB s)		\
				opls	C2	0.0000	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD s 1HG s 2HG s)		\
				opls	C2	0.0000	\
				amber	CT	-0.1020	\
				bio+	CH2E	0.0000	\
				int CB   1.525 CA   109.47 N    180.00
1HG 1DG HG1 HG3:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0570	\
				bio+	none	\
				int CG   1.090
2HG 2DG HG2:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0570	\
				bio+	none	\
				int CG   1.090
CD:		C	(CG s OE1 d NE2 s)		\
				opls	C	0.5000	imp CG NE2 CD OE1 \
				amber	C	0.6750	imp CG NE2 CD OE1 \
				bio+	C	0.4500	imp CD OE1 NE2 CG \
				int CG   1.522 CB   111.10 CA   180.00
OE1 AE1:	O	(CD d)				\
				opls	O	-0.5000	\
				amber	O	-0.4700	\
				bio+	O	-0.4500	\
				int CD   1.229 CG   120.50 CB     0.00
NE2 AE2:	N	(CD s 1HE2 s 2HE2 s)		\
				opls	N	-0.8500	imp CD 1HE2 NE2 2HE2 \
				amber	N	-0.8670	imp CD 1HE2 NE2 2HE2 \
				bio+	NH2	-0.6000	imp NE2 1HE2 2HE2 CD \
				int CD   1.335 CG   116.60 CB   180.00
1HE2 1DE2 HE21 HNE1:	H	(NE2 s)				\
				opls	H	0.4250	\
				amber	H	0.3440	\
				bio+	H	0.3000	\
				int NE2  1.010 CD   119.80 CG     0.00
2HE2 2DE2 HE22 HNE2:	H	(NE2 s)				\
				opls	H	0.4250	\
				amber	H	0.3440	\
				bio+	H	0.3000	\
				int NE2  1.010 CD   119.80 CG   180.00


; ARGININE
[ARG]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	0.0000	\
				amber	CT	-0.0800	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0560	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0560	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD s 1HG s 2HG s)		\
				opls	C2	0.0700	\
				amber	CT	-0.1030	\
				bio+	CH2E	0.0000	\
				int CB   1.525 CA   109.47 N    180.00
1HG 1DG HG1 HG3:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0740	\
				bio+	none	\
				int CG   1.090
2HG 2DG HG2:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0740	\
				bio+	none	\
				int CG   1.090
CD:		C	(CG s NE s 1HD s 2HD s)		\
				opls	C2	0.3100	\
				amber	CT	-0.2280	\
				bio+	CH2E	0.1000	\
				int CG   1.525 CB   109.47 CA   180.00
1HD 1DD HD1 HD3:	H	(CD s)				\
				opls	none	\
				amber	HC	0.1330	\
				bio+	none	\
				int CD   1.090
2HD 2DD HD2:	H	(CD s)				\
				opls	none	\
				amber	HC	0.1330	\
				bio+	none	\
				int CD   1.090
NE:		N	(CD s CZ s HE s)		\
				opls	N2	-0.7000	\
				amber	N2	-0.3240	imp CD CZ NE HE \
				bio+	NH1	-0.4000	imp NE CD CZ HE \
				int CD   1.480 CG   111.00 CB   180.00
HE DE HNE:		H	(NE s)				\
				opls	H3	0.4400	\
				amber	H3	0.2690	\
				bio+	H	0.3000	\
				int NE   1.010 CD   118.50 CG     0.00
CZ:		C	(NE s NH1 a NH2 a)		\
				opls	J4	0.6400	imp NE NH1 CZ NH2 \
				amber	CA	0.7600	imp NE NH1 CZ NH2 \
				bio+	C	0.5000	imp CZ NH1 NH2 NE \
				int NE   1.330 CD   123.00 CG   180.00
NH1:		N	(CZ a 1HH1 s 2HH1 s)		\
				opls	N2	-0.8000	\
				amber	N2	-0.6240	imp CZ 2HH1 NH1 1HH1 \
				bio+	NC2	-0.4500	\
				int CZ   1.330 NE   122.00 CD     0.00
1HH1 1DH1 HH11 HN11:	H	(NH1 s)				\
				opls	H3	0.4600	\
				amber	H3	0.3610	\
				bio+	HC	0.3500	\
				int NH1  1.010 CZ   119.80 NE     0.00
2HH1 2DH1 HH12 HN12:	H	(NH1 s)				\
				opls	H3	0.4600	\
				amber	H3	0.3610	\
				bio+	HC	0.3500	\
				int NH1  1.010 CZ   119.80 NE   180.00
NH2:		N	(CZ a 1HH2 s 2HH2 s)		\
				opls	N2	-0.8000	\
				amber	N2	-0.6240	imp CZ 2HH2 NH2 1HH2 \
				bio+	NC2	-0.4500	\
				int CZ   1.330 NE   118.00 CD   180.00
1HH2 1DH2 HH21 HN21:	H	(NH2 s)				\
				opls	H3	0.4600	\
				amber	H3	0.3610	\
				bio+	HC	0.3500	\
				int NH2  1.010 CZ   119.80 NE     0.00
2HH2 2DH2 HH22 HN22:	H	(NH2 s)				\
				opls	H3	0.4600	\
				amber	H3	0.3610	\
				bio+	HC	0.3500	\
				int NH2  1.010 CZ   119.80 NE   180.00


; HISTIDINE DELTAH
[HID]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	0.1150	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD2 a ND1 a)		\
				opls	JK	0.0150	\
				amber	CC	-0.0320	\
				bio+	C	0.1000	imp CG ND1 CD2 CB \
				int CB   1.510 CA   115.00 N    180.00
ND1 AD1: 	N	(CG a CE1 a HD1 s)		\
				opls	NA	-0.5700	imp CG CE1 ND1 HD1 \
				amber	NA	-0.1460	imp CG CE1 ND1 HD1 \
				bio+	NH1	-0.4000	imp ND1 CG CE1 HD1 \
				int CG   1.390 CB   122.00 CA   180.00
HD1 DD1 HND:	H	(ND1 s)				\
				opls	H	0.4200	\
				amber	H	0.2280	\
				bio+	H	0.3000	\
				int ND1  1.010 CG   126.00 CD2  180.00
CD2 AD2: 	C	(CG a NE2 a HD2 s)		\
				opls	JK	-0.0150	\
				amber	CV	0.1950	\
				bio+	CR1E	0.1000	\
				int NE2  1.360 CE1  110.00 ND1    0.00
HD2 DD2 HD:		H	(CD2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0180	\
				bio+	none	\
				int CD2  1.090 CG   120.00 ND1  180.00
CE1 AE1: 	C	(ND1 a NE2 a HE1 s)		\
				opls	JK	0.2950	\
				amber	CR	0.2410	\
				bio+	CR1E	0.3000	\
				int ND1  1.320 CG   108.00 CB   180.00
HE1 DE1 HE:		H	(CE1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0360	\
				bio+	none	\
				int CE1  1.090 ND1  120.00 CG   180.00
NE2 AE2: 	N	(CD2 a CE1 a)			\
				opls	NB	-0.4900	\
				amber	NB	-0.5020	\
				bio+	NR	-0.4000	\
				int CE1  1.310 ND1  109.00 CG     0.00


; HISTIDINE EPSILONH
[HIE]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s CG s 1HB s 2HB s)		\
				opls	C2	0.1150	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD2 a ND1 a)		\
				opls	JK	-0.0150	\
				amber	CC	0.2510	\
				bio+	C	0.1000	imp CG ND1 CD2 CB \
				int CB   1.510 CA   115.00 N    180.00
ND1 AD1:	N	(CG a CE1 a)			\
				opls	NB	-0.4900	\
				amber	NB	-0.5020	\
				bio+	NR	-0.4000	\
				int CG   1.390 CB   122.00 CA   180.00
CD2 AD2:	C	(CG a NE2 a HD2 s)		\
				opls	JK	0.0150	\
				amber	CW	-0.1840	\
				bio+	CR1E	0.1000	\
				int NE2  1.360 CE1  110.00 ND1    0.00
HD2 DD2 HD:		H	(CD2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1140	\
				bio+	none	\
				int CD2  1.090 CG   120.00 ND1  180.00
CE1 AE1:	C	(ND1 a NE2 a HE1 s)		\
				opls	JK	0.2950	\
				amber	CR	0.2410	\
				bio+	CR1E	0.3000	\
				int ND1  1.320 CG   108.00 CB   180.00
HE1 DE1 HE:		H	(CE1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0360	\
				bio+	none	\
				int CE1  1.090 ND1  120.00 CG   180.00
NE2 AE2:	N	(CD2 a CE1 a HE2 s)		\
				opls	NA	-0.5700	imp CE1 CD2 NE2 HE2 \
				amber	NA	-0.1460	imp CE1 CD2 NE2 HE2 \
				bio+	NH1	-0.4000	imp NE2 CE1 CD2 HE2 \
				int CE1  1.310 ND1  109.00 CG     0.00
HE2 DE2 HNE:	H	(NE2 s)				\
				opls	H	0.4200	\
				amber	H	0.2280	\
				bio+	H	0.3000	\
				int NE2  1.010 CE1  125.00 ND1  180.00


; HISTIDINE PLUS
[HIP]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s CG s 1HB s 2HB s)		\
				opls	C2	0.1150	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.1000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0860	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0860	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD2 a ND1 a)		\
				opls	JK	0.2150	\
				amber	CC	0.0580	\
				bio+	C	0.1500 imp CG ND1 CD2 CB \
				int CB   1.510 CA   115.00 N    180.00
ND1 AD1:	N	(CG a CE1 a HD1 s)		\
				opls	NA	-0.5400	imp CG CE1 ND1 HD1 \
				amber	NA	-0.0580	imp CG CE1 ND1 HD1 \
				bio+	NH1	-0.3000	imp ND1 CG CE1 HD1 \
				int CG   1.390 CB   122.00 CA   180.00
HD1 DD1 HND:	H	(ND1 s)				\
				opls	H	0.4600	\
				amber	H	0.3060	\
				bio+	H	0.3500	\
				int ND1  1.010 CG   126.00 CD2  180.00
CD2 AD2:	C	(CG a NE2 a HD2 s)		\
				opls	JK	0.2150	\
				amber	CW	-0.0370	\
				bio+	CR1E	0.2000	\
				int NE2  1.360 CE1  110.00 ND1    0.00
HD2 DD2 HD:		H	(CD2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1530	\
				bio+	none	\
				int CD2  1.090 CG   120.00 ND1  180.00
CE1 AE1:	C	(ND1 a NE2 a HE1 s)		\
				opls	JK	0.3850	\
				amber	CR	0.1140	\
				bio+	CR1E	0.4500	\
				int ND1  1.320 CG   108.00 CB   180.00
HE1 DE1 HE:		H	(CE1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1580	\
				bio+	none	\
				int CE1  1.090 ND1  120.00 CG   180.00
NE2 AE2:	N	(CD2 a CE1 a HE2 s)		\
				opls	NA	-0.5400	imp CE1 CD2 NE2 HE2 \
				amber	NA	-0.0580	imp CE1 CD2 NE2 HE2 \
				bio+	NH1	-0.3000	imp NE2 CD2 CE1 HE2 \
				int CE1  1.310 ND1  109.00 CG     0.00
HE2 DE2 HNE:	H	(NE2 s)				\
				opls	H	0.4600	\
				amber	H	0.3060	\
				bio+	H	0.3500	\
				int NE2  1.010 CE1  125.00 ND1  180.00


; HISTIDINE GENERIC (same as HISTIDINE PLUS [HIP] above)
[HIS]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s CG s 1HB s 2HB s)		\
				opls	C2	0.1150	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0860	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0860	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD2 a ND1 a)		\
				opls	JK	0.2150	\
				amber	CC	0.0580	\
				bio+	C	0.1500 imp CG ND1 CD2 CB \
				int CB   1.510 CA   115.00 N    180.00
ND1 AD1:	N	(CG a CE1 a HD1 s)		\
				opls	NA	-0.5400	imp CG CE1 ND1 HD1 \
				amber	NA	-0.0580	imp CG CE1 ND1 HD1 \
				bio+	NH1	-0.3000	imp ND1 CG CE1 HD1 \
				int CG   1.390 CB   122.00 CA   180.00
HD1 DD1 HND:	H	(ND1 s)				\
				opls	H	0.4600	\
				amber	H	0.3060	\
				bio+	H	0.3500	\
				int ND1  1.010
CD2 AD2:	C	(CG a NE2 a HD2 s)		\
				opls	JK	0.2150	\
				amber	CW	-0.0370	\
				bio+	CR1E	0.2000	\
				int NE2  1.360 CE1  110.00 ND1    0.00
HD2 DD2 HD:		H	(CD2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1530	\
				bio+	none	\
				int CD2  1.090
CE1 AE1:	C	(ND1 a NE2 a HE1 s)		\
				opls	JK	0.3850	\
				amber	CR	0.1140	\
				bio+	CR1E	0.4500	\
				int ND1  1.320 CG   108.00 CB   180.00
HE1 DE1 HE:		H	(CE1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1580	\
				bio+	none	\
				int CE1  1.090
NE2 AE2:	N	(CD2 a CE1 a HE2 s)		\
				opls	NA	-0.5400	imp CE1 CD2 NE2 HE2 \
				amber	NA	-0.0580	imp CE1 CD2 NE2 HE2 \
				bio+	NH1	-0.3000	imp NE2 CD2 CE1 HE2 \
				int CE1  1.310 ND1  109.00 CG     0.00
HE2 DE2 HNE:	H	(NE2 s)				\
				opls	H	0.4600	\
				amber	H	0.3060	\
				bio+	H	0.3500	\
				int NE2  1.010


; TRYPTOPHAN
[TRP TRY]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	0.1150	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD1 a CD2 a)		\
				opls	JK	-0.1700	\
				amber	C*	-0.1350	\
				bio+	C	-0.0300	imp CG CD1 CD2 CB \
				int CB   1.510 CA   115.00 N    180.00
CD1:		C	(CG a NE1 a HD1 s)		\
				opls	JK	0.0150	\
				amber	CW	0.0440	\
				bio+	CR1E	0.0600	\
				int CG   1.340 CB   127.00 CA   180.00
HD1 DD1 HD:		H	(CD1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0930	\
				bio+	none	\
				int CD1  1.090 
CD2:		C	(CG a CE2 a CE3 a)		\
				opls	JB	-0.0550	\
				amber	CB	0.1460	\
				bio+	C	0.1000	\
				int CE3  1.400 CZ3  117.00 CH2    0.00
NE1:		N	(CD1 a CE2 a HE1 s)		\
				opls	NA	-0.5700	imp CD1 CE2 NE1 HE1 \
				amber	NA	-0.3520	imp CD1 CE2 NE1 HE1 \
				bio+	NH1	-0.3600	imp NE1 CD1 CE2 HE1 \
				int CD1  1.430 CG   107.00 CB   180.00
HE1 DE1 HNE:	H	(NE1 s)				\
				opls	H	0.4200	\
				amber	H	0.2710	\
				bio+	H	0.3000	\
				int NE1  1.010 
CE2:		C	(CD2 a NE1 a CZ2 a)		\
				opls	JN	0.1300	\
				amber	CN	0.1540	\
				bio+	C	-0.0400	\
				int NE1  1.310 CD1  109.00 CG     0.00
CE3:		C	(CD2 a CZ3 a HE3 s)		\
				opls	JK	-0.1150	imp CZ3 CD2 CE3 HE3 \
				amber	CA	-0.1730	imp CZ3 CD2 CE3 HE3 \
				bio+	CR1E	-0.0300	\
				int CZ3  1.410 CH2  122.00 CZ2    0.00
HE3 DE3 HE:		H	(CE3 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0860	\
				bio+	none	\
				int CE3  1.090 
CZ2:		C	(CE2 a CH2 a HZ2 s)		\
				opls	JK	-0.1150	imp CE2 CH2 CZ2 HZ2 \
				amber	CA	-0.1680	imp CE2 CH2 CZ2 HZ2 \
				bio+	CR1E	0.0000	\
				int CE2  1.400 NE1  128.00 CD1  180.00
HZ2 DZ2:	H	(CZ2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0840	\
				bio+	none	\
				int CZ2  1.090 
CZ3:		C	(CE3 a CH2 a HZ3 s)		\
				opls	JK	-0.1150	imp CH2 CE3 CZ3 HZ3 \
				amber	CA	-0.0660	imp CH2 CE3 CZ3 HZ3 \
				bio+	CR1E	0.0000	\
				int CH2  1.350 CZ2  121.00 CE2    0.00
HZ3 DZ3:	H	(CZ3 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0570	\
				bio+	none	\
				int CZ3  1.090 
CH2:		C	(CZ2 a CZ3 a HH2 s)		\
				opls	JK	-0.1150	imp CZ2 CZ3 CH2 HH2 \
				amber	CA	-0.0770	imp CZ2 CZ3 CH2 HH2 \
				bio+	CR1E	0.0000	\
				int CZ2  1.390 CE2  116.00 NE1  180.00
HH2 DH2 HH:		H	(CH2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0740	\
				bio+	none	\
				int CH2  1.090 


; PHENYLALANINE
[PHE]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s CG s 1HB s 2HB s)		\
				opls	C2	0.1150	\
				amber	CT	-0.1000	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.1080	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.1080	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD1 a CD2 a)		\
				opls	JK	-0.1150	\
				amber	CA	-0.1000	\
				bio+	C	0.0000	imp CG CD1 CD2 CB \
				int CB   1.510 CA   115.00 N    180.00
CD1:		C	(CG a CE1 a HD1 s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.1500	\
				bio+	CR1E	0.0000	\
				int CG   1.400 CB   120.00 CA   180.00
HD1 DD1:		H	(CD1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1500	\
				bio+	none	\
				int CD1  1.090
CD2:		C	(CG a CE2 a HD2 s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.1500	\
				bio+	CR1E	0.0000	\
				int CE2  1.400 CZ   120.00 CE1    0.00
HD2 DD2:		H	(CD2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1500	\
				bio+	none	\
				int CD2  1.090
CE1:		C	(CD1 a CZ a HE1 s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.1500	\
				bio+	CR1E	0.0000	\
				int CD1  1.400 CG   120.00 CB   180.00
HE1 DE1:		H	(CE1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1500	\
				bio+	none	\
				int CE1  1.090
CE2:		C	(CD2 a CZ a HE2 s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.1500	\
				bio+	CR1E	0.0000	\
				int CZ   1.400 CE1  120.00 CD1    0.00
HE2 DE2:		H	(CE2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1500	\
				bio+	none	\
				int CE2  1.090
CZ:		C	(CE1 a CE2 a HZ s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.1500	\
				bio+	CR1E	0.0000	\
				int CE1  1.400 CD1  120.00 CG     0.00
HZ DZ HZ1:		H	(CZ s)				\
				opls	HK	0.1150	\
				amber	HC	0.1500	\
				bio+	none	\
				int CZ   1.090


; TYROSINE
[TYR]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	0.1150	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD1 a CD2 a)		\
				opls	JK	-0.1150	\
				amber	CA	-0.0300	\
				bio+	C	0.0000	imp CG CD1 CD2 CB \
				int CB   1.510 CA   109.47 N    180.00
CD1:		C	(CG a CE1 a HD1 s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.0020	\
				bio+	CR1E	0.0000	\
				int CG   1.400 CB   120.00 CA   180.00
HD1 DD1:		H	(CD1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0640	\
				bio+	none	\
				int CD1  1.090
CD2:		C	(CG a CE2 a HD2 s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.0020	\
				bio+	CR1E	0.0000	\
				int CE2  1.400 CZ   120.00 CE1    0.00
HD2 DD2:		H	(CD2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.0640	\
				bio+	none	\
				int CD2  1.090
CE1:		C	(CD1 a CZ a HE1 s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.2640	\
				bio+	CR1E	0.0000	\
				int CD1  1.400 CG   120.00 CB   180.00
HE1 DE1:		H	(CE1 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1020	\
				bio+	none	\
				int CE1  1.090
CE2:		C	(CD2 a CZ a HE2 s)		\
				opls	JK	-0.1150	\
				amber	CA	-0.2640	\
				bio+	CR1E	0.0000	\
				int CZ   1.400 CE1  120.00 CD1    0.00
HE2 DE2:		H	(CE2 s)				\
				opls	HK	0.1150	\
				amber	HC	0.1020	\
				bio+	none	\
				int CE2  1.090
CZ:		C	(CE1 a CE2 a OH s)		\
				opls	JA	0.2650	\
				amber	C	0.4620	\
				bio+	C	0.2500	imp CZ CE1 CE2 OH \
				int CE1  1.400 CD1  120.00 CG     0.00
OH:		O	(CZ s HH s)			\
				opls	OH	-0.7000	\
				amber	OH	-0.5280	\
				bio+	OH1	-0.6500	\
				int CZ   1.360 CE1  120.00 CD1  180.00
HH DH HOH: 	H	(OH s)				\
				opls	HO	0.4350	\
				amber	HO	0.3340	\
				bio+	H	0.4000	\
				int OH   0.960 CZ   113.00 CE1    0.00


; GLUTAMIC ACID
[GLU]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	0.0000	\
				amber	CT	-0.1840	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0920	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0920	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD s 1HG s 2HG s)		\
				opls	C2	-0.1000	\
				amber	CT	-0.3980	\
				bio+	CH2E	-0.1600	\
				int CB   1.510 CA   109.47 N    180.00
1HG 1DG HG1 HG3:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0710	\
				bio+	none	\
				int CG   1.090
2HG 2DG HG2:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0710	\
				bio+	none	\
				int CG   1.090
CD:		C	(CG s OE1 a OE2 a)		\
				opls	C	0.7000	imp CG OE1 CD OE2 \
				amber	C	0.7140	imp CG OE1 CD OE2 \
				bio+	C	0.3600	imp CD OE1 OE2 CG \
				int CG   1.527 CB   109.47 CA   180.00
OE1:		O	(CD a)				\
				opls	O2	-0.8000	\
				amber	O2	-0.7210	\
				bio+	OC	-0.6000	\
				int CD   1.260 CG   117.20 CB    90.00
OE2:		O	(CD a)				\
				opls	O2	-0.8000	\
				amber	O2	-0.7210	\
				bio+	OC	-0.6000	\
				int CD   1.260 CG   117.20 CB   270.00


; ASPARTIC ACID
[ASP]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	-0.1000	\
				amber	CT	-0.3980	\
				bio+	CH2E	-0.1600	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0710	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0710	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s OD1 a OD2 a)		\
				opls	C	0.7000	imp CB OD1 CG OD2 \
				amber	C	0.7140	imp CB OD1 CG OD2 \
				bio+	C	0.3600	imp CG OD1 OD2 CB \
				int CB   1.527 CA   109.47 N    180.00
OD1:		O	(CG a)				\
				opls	O2	-0.8000	\
				amber	O2	-0.7210	\
				bio+	OC	-0.6000	\
				int CG   1.260 CB   117.20 CA    90.00
OD2:		O	(CG a)				\
				opls	O2	-0.8000	\
				amber	O2	-0.7210	\
				bio+	OC	-0.6000	\
				int CG   1.260 CB   117.20 CA   270.00


; LYSINE
[LYS]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	0.0000	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s CD s 1HG s 2HG s)		\
				opls	C2	0.0000	\
				amber	CT	-0.1600	\
				bio+	CH2E	0.0000	\
				int CB   1.525 CA   109.47 N    180.00
1HG 1DG HG1 HG3:	H	(CG s)				\
				opls	none	\
				amber	HC	0.1160	\
				bio+	none	\
				int CG   1.090
2HG 2DG HG2:	H	(CG s)				\
				opls	none	\
				amber	HC	0.1160	\
				bio+	none	\
				int CG   1.090
CD:		C	(CG s CE s 1HD s 2HD s)		\
				opls	C2	0.0000	\
				amber	CT	-0.1800	\
				bio+	CH2E	0.0000	\
				int CG   1.525 CB   109.47 CA   180.00
1HD 1DD HD1 HD3:	H	(CD s)				\
				opls	none	\
				amber	HC	0.1220	\
				bio+	none	\
				int CD   1.090
2HD 2DD HD2:	H	(CD s)				\
				opls	none	\
				amber	HC	0.1220	\
				bio+	none	\
				int CD   1.090
CE:		C	(CD s NZ s 1HE s 2HE s)		\
				opls	C2	0.3100	\
				amber	CT	-0.0380	\
				bio+	CH2E	0.2500	\
				int CD   1.525 CG   109.47 CB   180.00
1HE 1DE HE1 HE3:	H	(CE s)				\
				opls	none	\
				amber	HC	0.0980	\
				bio+	none	\
				int CE   1.090
2HE 2DE HE2:	H	(CE s)				\
				opls	none	\
				amber	HC	0.0980	\
				bio+	none	\
				int CE   1.090
NZ:		N	(CE s 1HZ s 2HZ s 3HZ s)	\
				opls	N3	-0.3000	\
				amber	N3	-0.1380	\
				bio+	NH3	-0.3000	\
				int CE   1.470 CD   109.47 CG   180.00
1HZ 1DZ HNZ1:	H	(NZ s)				\
				opls	H3	0.3300	\
				amber	H3	0.2940	\
				bio+	HC	0.3500	\
				int NZ   1.010
2HZ 2DZ HNZ2:	H	(NZ s)				\
				opls	H3	0.3300	\
				amber	H3	0.2940	\
				bio+	HC	0.3500	\
				int NZ   1.010
3HZ 3DZ HNZ3:	H	(NZ s)				\
				opls	H3	0.3300	\
				amber	H3	0.2940	\
				bio+	HC	0.3500	\
				int NZ   1.010


; PROLINE
[PRO]A
N:		N 1	(-3 s CA s CD s)		\
				opls	N	-0.5700	imp -3 CA N CD \
				amber	N	-0.2290	imp -3 CA N CD \
				bio+	N	-0.2000	imp N CA CD -3 \
				int -3   1.337 -2   117.00
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2850 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int CB   1.500 CG   109.5
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.5260	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5000	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50
CB:		C	(CG s CA s 1HB s 2HB s)		\
				opls	C2	0.0000	\
				amber	CT	-0.1150	\
				bio+	CH2E	0.0000	\
				int CG   1.510 CD   106.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0610	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0610	\
				bio+	none	\
				int CB   1.090
CG:		C	(CD s CB s 1HG s 2HG s)		\
				opls	C2	0.0000	\
				amber	CT	-0.1210	\
				bio+	CH2E	0.0000	\
				int CD   1.500 N    103.20
1HG 1DG HG1 HG3:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0630	\
				bio+	none	\
				int CG   1.090
2HG 2DG HG2:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0630	\
				bio+	none	\
				int CG   1.090
CD:		C	(N s CG s 1HD s 2HD s)		\
				opls	JQ	0.2850	\
				amber	CT	-0.0120	\
				bio+	CH2E	0.1000	\
				int N    1.458 -3   126.10
1HD 1DD HD1 HD3:	H	(CD s)				\
				opls	none	\
				amber	HC	0.0600	\
				bio+	none	\
				int CD   1.090
2HD 2DD HD2:	H	(CD s)				\
				opls	none	\
				amber	HC	0.0600	\
				bio+	none	\
				int CD   1.090


; CYSTEINE
[CYS CYH CSH]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s SG s 1HB s 2HB s)		\
				opls	C2	0.1800	\
				amber	CT	-0.0600	\
				bio+	CH2E	0.1900	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0380	\
				bio+	none	\
				int CB   1.090
SG:		S	(CB s HG s LP1 s LP2 s)		\
				opls	SH	-0.4500	\
				amber	SH	0.8270	\
				bio+	SH1E	-0.1900	\
				int CB   1.810 CA   116.00 N    180.00
HG DG HSG:		H	(SG s)				\
				opls	HS	0.2700	\
				amber	HS	0.1350	\
				bio+	none	\
				int SG   1.330
LP1:		LP	(SG s)				\
				opls	none	\
				amber	LP	-0.4810	\
				bio+	none	\
				int SG   0.679
LP2:		LP	(SG s)				\
				opls	none	\
				amber	LP	-0.4810	\
				bio+	none	\
				int SG   0.679


; CYSTEINE as in CYSTINE (S-S BRIDGE)
[CYX CSS]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(SG s CA s 1HB s 2HB s)		\
				opls	JQ	0.3000	\
				amber	CT	-0.0980	\
				bio+	CH2E	0.1900	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0495	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0495	\
				bio+	none	\
				int CB   1.090
SG:		S	(CB s LP1 s LP2 s)		\
				opls	S	-0.3000	\
				amber	S	0.8240	\
				bio+	S	-0.1900	\
				int CB   1.810 CA   116.00 N    180.00
LP1:		LP	(SG s)				\
				opls	none	\
				amber	LP	-0.4045	\
				bio+	none	\
				int SG   0.679
;				int SG   0.679 CB    96.70 CA    60.00
LP2:		LP	(SG s)				\
				opls	none	\
				amber	LP	-0.4045	\
				bio+	none	\
				int SG   0.679
;				int SG   0.679 CB    96.70 CA   300.00


; METHIONINE
[MET]A
N:		N 1	(H s -3 s CA s)		\
				opls	N	-0.5700	imp -3 CA N H \
				amber	N	-0.4630	imp -3 CA N H \
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:		H	(N s)				\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA:		C 2	(N s HA s C s CB s)		\
				opls	CH	0.2000 imp CB CA N C \
				amber	CT	0.0350	\
				bio+	CH1E	0.1000	imp CA N C CB \
				int N    1.449 -3   121.90 -2   180.00
HA DA:		H	(CA s)				\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
C:		C 3	(CA s O d +1 s)			\
				opls	C	0.5000	imp CA +1 C O \
				amber	C	0.6160	imp CA +1 C O \
				bio+	C	0.4500	imp C CA +1 O \
				int CA   1.522 N    111.10 -3   180.00
O:		O 4	(C d)				\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229 CA   120.50 N      0.00
CB:		C	(CA s CG s 1HB s 2HB s)		\
				opls	C2	0.0000	\
				amber	CT	-0.1510	\
				bio+	CH2E	0.0000	\
				int CA   1.525 N    111.10 -3    60.00
1HB 1DB HB1 HB3:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0270	\
				bio+	none	\
				int CB   1.090
2HB 2DB HB2:	H	(CB s)				\
				opls	none	\
				amber	HC	0.0270	\
				bio+	none	\
				int CB   1.090
CG:		C	(CB s SD s 1HG s 2HG s)		\
				opls	JQ	0.2350	\
				amber	CT	-0.0540	\
				bio+	CH2E	0.0600	\
				int CB   1.525 CA   109.47 N    180.00
1HG 1DG HG1 HG3:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0652	\
				bio+	none	\
				int CG   1.090
2HG 2DG HG2:	H	(CG s)				\
				opls	none	\
				amber	HC	0.0652	\
				bio+	none	\
				int CG   1.090
SD:		S	(CG s CE s LP1 s LP2 s)		\
				opls	S	-0.4700	\
				amber	S	0.7370	\
				bio+	S	-0.1200	\
				int CG   1.810 CB   110.00 CA   180.00
LP1:		LP	(SD s)				\
				opls	none	\
				amber	LP	-0.3810	\
				bio+	none	\
				int SD   0.679
LP2:		LP	(SD s)				\
				opls	none	\
				amber	LP	-0.3810	\
				bio+	none	\
				int SD   0.679
CE:		C	(SD s 1HE s 2HE s 3HE s)	\
				opls	JW	0.2350	\
				amber	CT	-0.1340	\
				bio+	CH3E	0.0600	\
				int SD   1.780 CG   100.00 CB   180.00
1HE 1DE HE1:	H	(CE s)				\
				opls	none	\
				amber	HC	0.0652	\
				bio+	none	\
				int CE   1.090
2HE 2DE HE2:	H	(CE s)				\
				opls	none	\
				amber	HC	0.0652	\
				bio+	none	\
				int CE   1.090
3HE 3DE HE3:	H	(CE s)				\
				opls	none	\
				amber	HC	0.0652	\
				bio+	none	\
				int CE   1.090



; Gamma-aminobutyric acid
[ABU]A*
N NG:		N 1	(1H s 2H s 3H s CG s)
1H 1D HT1 HN1:	H	(N s)
2H 2D HT2 HN2:	H	(N s)
3H 3D HT3 HN3:	H	(N s)
CA:		C 2	(1HA s 2HA s C s CB s)
1HA 1DA HA1:	H	(CA s)			\
				opls	none	\
				bio+	none
2HA 2DA HA2:	H	(CA s)			\
				opls	none	\
				bio+	none
C:		C 3	(CA s O a OXT a)
O OA OT1:	O 	(C a)
OXT OB OT2:	O 	(C a)
CB:		C	(CA s 1HB s 2HB s CG s)
1HB 1DB HB1:	H	(CB s)			\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none
CG:		C	(CB s 1HG s 2HG s N s)
1HG 1DG HG1:	H	(CG s)			\
				opls	none	\
				bio+	none
2HG 2DG HG2:	H	(CG s)			\
				opls	none	\
				bio+	none



; Beta-alanine
[ALB]A*
N NG:		N 1	(1H s 2H s 3H s CB s)
1H 1D HT1 HN1:	H	(N s)
2H 2D HT2 HN2:	H	(N s)
3H 3D HT3 HN3:	H	(N s)
CA:		C 2	(1HA s 2HA s C s CB s)
1HA 1DA HA1:	H	(CA s)			\
				opls	none	\
				bio+	none
2HA 2DA HA2:	H	(CA s)			\
				opls	none	\
				bio+	none
C:		C 3	(CA s O a OXT a)
O OA OT1:	O 	(C a)
OXT OB OT2:	O 	(C a)
CB:		C	(CA s 1HB s 2HB s N s)
1HB 1DB HB1:	H	(CB s)			\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none



; Betaine
[BET]A*
N:		N 1	(C1 s C2 s C3 s CA s)
C1 CN1:		C	(N s 1H1 s 2H1 s 3H1 s)
1H1 1D1 H11 HN11:	H	(C1 s)		\
				opls	none	\
				bio+	none
2H1 2D1 H12 HN12:	H	(C1 s)		\
				opls	none	\
				bio+	none
3H1 3D1 H13 HN13:	H	(C1 s)		\
				opls	none	\
				bio+	none
C2 CN2:		C	(N s 1H2 s 2H2 s 3H2 s)
1H2 1D2 H21 HN21:	H	(C2 s)		\
				opls	none	\
				bio+	none
2H2 2D2 H22 HN22:	H	(C2 s)		\
				opls	none	\
				bio+	none
3H2 3D2 H23 HN23:	H	(C2 s)		\
				opls	none	\
				bio+	none
C3 CN3:		C	(N s 1H3 s 2H3 s 3H3 s)
1H3 1D3 H31 HN31:	H	(C3 s)		\
				opls	none	\
				bio+	none
2H3 2D3 H32 HN32:	H	(C3 s)		\
				opls	none	\
				bio+	none
3H3 3D3 H33 HN33:	H	(C3 s)		\
				opls	none	\
				bio+	none
CA:		C 2	(N s 1HA s 2HA s C s)
1HA 1DA HA1:	H	(CA s)			\
				opls	none	\
				bio+	none
2HA 2DA HA2:	H	(CA s)			\
				opls	none	\
				bio+	none
C:		C 3	(CA s O a OXT a)
O OA OT1:	O 	(C a)
OXT OB OT2:	O 	(C a)



; Homoserine
[HSE]A*
N:		N 1	(H s -3 s CA s)
H D HN DN:		H	(N s)
CA:		C 2	(N s HA s C s CB s)
HA DA:		H	(CA s)			\
				opls	none	\
				bio+	none
C:		C 3	(CA s O d +1 s)
O:		O 4	(C d)
CB:		C	(CG s CA s 1HB s 2HB s)
1HB 1DB HB1 HB3:	H	(CB s)		\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none
CG:		C	(OD s CB s 1HG s 2HG s)
1HG 1DG HG1 HG3:	H	(CG s)		\
				opls	none	\
				bio+	none
2HG 2DG HG2:	H	(CG s)			\
				opls	none	\
				bio+	none
OD:		O	(CG s HD s)
HD DD HOD:	H	(OD s)



; 5-hydroxylysine
[HYL]A*
N:		N 1	(H s -3 s CA s)
H D HN DN:		H	(N s)
CA:		C 2	(N s HA s C s CB s)
HA DA:		H	(CA s)			\
				opls	none	\
				bio+	none
C:		C 3	(CA s O d +1 s)
O:		O 4	(C d)
CB:		C	(CG s CA s 1HB s 2HB s)
1HB 1DB HB1 HB3:	H	(CB s)		\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none
CG:		C	(CD s CB s 1HG s 2HG s)
1HG 1DG HG1 HG3:	H	(CG s)		\
				opls	none	\
				bio+	none
2HG 2DG HG2:	H	(CG s)			\
				opls	none	\
				bio+	none
CD:		C	(CG s CE1 s OE2 s HD s)
HD DD:		H	(CD s)		\
				opls	none	\
				bio+	none
OE2 OE:		O	(CD s HE2 s)
HE2 DE2 HOE:	H	(OE2 s)
CE1 CE:		C	(CD s NZ s 1HE s 2HE s)
1HE1 1DE1 HE11 HE13:	H	(CE1 s)		\
				opls	none	\
				bio+	none
2HE1 2DE1 HE12:	H	(CE1 s)			\
				opls	none	\
				bio+	none
NZ:		N	(CE s 1HZ s 2HZ s 3HZ s)
1HZ 1DZ HNZ1:	H	(NZ s)
2HZ 2DZ HNZ2:	H	(NZ s)
3HZ 3DZ HNZ3:	H	(NZ s)



; 4-hydroxyproline
[HYP]A*
N:		N 1	(-3 s CA s CD s)
CA:		C 2	(N s HA s C s CB s)
HA DA:		H	(CA s)			\
				opls	none
				bio+	none
C:		C 3	(CA s O d +1 s)
O:		O 4	(C d)
CB:		C	(CG s CA s 1HB s 2HB s)
1HB 1DB HB1 HB3:	H	(CB s)		\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none
CG:		C	(CD s CB s OG s HG s)
HG DG:		H	(CG s)		\
				opls	none	\
				bio+	none
OD1:		O 	(CG s HD1 s)
HD1 DD1 HOD:	H	(CG s)
CD2		C	(N s CG s 1HD2 s 2HD2 s)
1HD2 1DD2 HD21:	H	(CD s)		\
				opls	none	\
				bio+	none
2HD2 2DD2 HD22:	H	(CD s)			\
				opls	none	\
				bio+	none



; Ornithine
[ORN]A*
N:		N 1	(H s -3 s CA s)
H D HN DN:	H	(N s)
CA:		C 2	(N s HA s C s CB s)
HA DA:		H	(CA s)			\
				opls	none	\
				bio+	none
C:		C 3	(CA s O d +1 s)
O:		O 4	(C d)
CB:		C	(CG s CA s 1HB s 2HB s)
1HB 1DB HB1 HB3:	H	(CB s)		\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none
CG:		C	(CD s CB s 1HG s 2HG s)
1HG 1DG HG1:	H	(CG s)		\
				opls	none	\
				bio+	none
2HG 2DG HG2:	H	(CG s)		\
				opls	none	\
				bio+	none
CD:		C	(CG s NZ s 1HD s 2HD s)
1HD 1DD HD1:	H	(CD s)		\
				opls	none	\
				bio+	none
2HD 2DD HD2:	H	(CD s)		\
				opls	none	\
				bio+	none
NZ:		O	(CD s 1HZ s 2HZ s 3HZ s)
1HZ 1DZ HZ1 HNZ1:	H	(NZ s)
2HZ 2DZ HZ2 HNZ2:	H	(NZ s)
3HZ 3DZ HZ3 HNZ3:	H	(NZ s)



; Pyrrolidine carboxylic acid (pyroglutamate)
[PCA]A*
N:		N 1	(-3 s CA s CD s)
CA:		C 2	(N s HA s C s CB s)
HA DA:		H	(CA s)			\
				opls	none	\
				bio+	none
C:		C 3	(CA s O d +1 s)
O:		O 4	(C d)
CB:		C	(CG s CA s 1HB s 2HB s)
1HB 1DB HB1 HB3:	H	(CB s)		\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none
CG:		C	(CD s CB s 1HG s 2HG s)
1HG 1DG HG1 HG3:	H	(CG s)		\
				opls	none	\
				bio+	none
2HG 2DG HG2:	H	(CG s)			\
				opls	none	\
				bio+	none
CD:		C	(N s CG s OE d)
OE:		O	(CD d)



; Sarcosine
[SAR]A*
N:		N 1	(C1 s -3 s CA s)
C1 CN1:		C	(N s 1H1 s 2H1 s 3H1 s)
1H1 1D1 H11 HN11:	H	(C1 s)		\
				opls	none	\
				bio+	none
2H1 2D1 H12 HN12:	H	(C1 s)		\
				opls	none	\
				bio+	none
3H1 3D1 H13 HN13:	H	(C1 s)		\
				opls	none	\
				bio+	none
CA:		C 2	(N s 1HA s 2HA s C s)
1HA 1DA HA1:	H	(CA s)			\
				opls	none	\
				bio+	none
2HA 2DA HA2:	H	(CA s)			\
				opls	none	\
				bio+	none
C:		C  3	(CA s O d +1 s)
O:		O 4	(C d)



; Taurine
[TAU]A*
N NB:		N 1	(1H s 2H s 3H s CB s)
1H 1D HT1 HN1:	H	(N s)
2H 2D HT2 HN2:	H	(N s)
3H 3D HT3 HN3:	H	(N s)
CA:		C 2	(1HA s 2HA s C s CB s)
1HA 1DA HA1:	H	(CA s)			\
				opls	none	\
				bio+	none
2HA 2DA HA2:	H	(CA s)			\
				opls	none	\
				bio+	none
S:		S 3	(CA s O1 d O2 d O3 d)
O1:		O	(S d)
O2:		O	(S d)
O3:		O	(S d)
CB:		C	(CA s 1HB s 2HB s N s)
1HB 1DB HB1:	H	(CB s)			\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none



; Thyroxine
[THY]A*
N:		N 1	(H s -3 s CA s)
H D HN DN:		H	(N s)
CA:		C 2	(N s HA s C s CB s)
HA DA:		H	(CA s)			\
				opls	none	\
				bio+	none
C:		C 3	(CA s O d +1 s)
O:		O 4	(C d)
CB:		C	(CA s CG s 1HB s 2HB s)
1HB 1DB HB1 HB3:	H	(CB s)		\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none
CG:		C	(CB s CD1 a CD2 a)
CD1:		C	(CG a CE1 a HD1 s)
HD1 DD1:	H	(CD1 s)			\
				bio+	none
CD2:		C	(CG a CE2 a HD2 s)
HD2 DD2:	H	(CD2 s)			\
				bio+	none
CE1:		C	(CD1 a CZ a IE1 s)
IE1:		I	(CE1 s)
CE2:		C	(CD2 a CZ a IE2 s)
IE2:		I	(CE2 s)
CZ:		C	(CE1 a CE2 a OH s)
OH:		O	(CZ a CT s)
CT:		C	(OH s CI1 a CI2 a)
CI1:		C	(CT a CK1 a HI1 s)
HI1 DI1:	H	(CI1 s)			\
				bio+	none
CI2:		C	(CT a CK2 a HI2 s)
HI2 DI2:	H	(CI2 s)			\
				bio+	none
CK1:		C	(CI1 a CL a IK1 s)
IK1:		I	(CK1 s)
CK2:		C	(CI2 a CL a IK2 s)
IK2:		I	(CK2 s)
CL:		C	(CK1 a CK2 a HL s)
HL DL:		H	(CL s)			\
				bio+	none


;  ACE BEGINNING GROUP
[ACE]A
1H 1D H1:	H 	(CH3 s)			\
				opls	none	\
				amber	HC	0.0100	\
				bio+	none	\
				int CH3  1.090
CH3 CA:		C 2	(1H s 2H s 3H s C s)	\
				opls	C3	0.0000	\
				amber	CT	-0.1420	\
				bio+	CH3E	0.0000
2H 2D H2:	H 	(CH3 s)			\
				opls	none	\
				amber	HC	0.0100	\
				bio+	none	\
				int CH3  1.090
3H 3D H3:	H 	(CH3 s)			\
				opls	none	\
				amber	HC	0.0100	\
				bio+	none	\
				int CH3  1.090
C:		C 3	(CH3 s O d +1 s)	\
				opls	C	0.5000	imp CH3 +1 C O \
				amber	C	0.6160	imp CH3 +1 C O \
				bio+	C	0.4500	imp C CH3 +1 O \
				int CH3  1.530 H1   111.10
O:		O 4	(C d)			\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229


;  FOR BEGINNING GROUP
[FOR]A*
H D:		H 	(C s)			\
				opls	none	\
				amber	HC	-0.1120	\
				bio+	none	\
				int C  1.090
C:		C 3	(H s O d +1 s)	\
				opls	C	0.5000	\
				amber	C	0.6160	imp H +1 C O \
				bio+	C	0.4500	\
				int C  1.090
O:		O 4	(C d)			\
				opls	O	-0.5000	\
				amber	O	-0.5040	\
				bio+	O	-0.4500	\
				int C    1.229


;   NME ENDING GROUP
[NME]A
N:		N 1	(H s -3 s CA s)	\
				opls	N	-0.5700	\
				amber	N	-0.4630	\
				bio+	NH1	-0.3500	imp N -3 CA H \
				int -3   1.335 -2   116.60 -1   180.00
H D HN DN:	H 	(N s)			\
				opls	H	0.3700	\
				amber	H	0.2520	\
				bio+	H	0.2500	\
				int N    1.010
CA CT:		C 2	(N s H1 s H2 s H3 s)	\
				opls	JW	0.2000	\
				amber	CT	0.0670	\
				bio+	CH3E	0.1000	\
				int N    1.449 -3   121.90 -2   180.00
1HA 1DA H1 HT1:	H 	(CA s)			\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
2HA 2DA H2 HT2:	H 	(CA s)			\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090
3HA 3DA H3 HT3:	H 	(CA s)			\
				opls	none	\
				amber	HC	0.0480	\
				bio+	none	\
				int CA   1.090

;  NH2 ending group
[NH2 NHE]A*
NXT N:		N 1	(1H s 2H s -3 s)	\
				opls	N	-0.6880	\
				amber	N	-0.4630	\
				bio+	NH2	-0.5000
1H 1D H H1:		H	(NXT s)	\
				opls	H	0.3440	\
				amber	H	0.2315	\
				bio+	H	0.2500
2H 2D HA H2:		H	(NXT s)	\
				opls	H	0.3440	\
				amber	H	0.2315	\
				bio+	H	0.2500

;  O MINUS END ATOM
[OME]A*
OXT:		O 1	(-3 d)			\
				opls	O2	-0.8000	\
				amber	O2	-0.5425	\
				bio+	OC	-0.5700	\
				int -3   1.260 -2   117.20 -1   180.00

; Dummy residue needed for program internals - do not delete!
[DUM]*
C DUM:		C 3	(+1 s)	\
				opls	C	0.0	\
				amber	C	0.0	\
				bio+	C	0.0




;     Heme residue
[HEM HEME]*
FE:		FE	(N_A s N_B s N_C s N_D s)	am FE  0.2500
CHA 1CH:	C	(C1A a C4D a HHA s)		am CD -0.1100
HHA HGM HC31:	H	(CHA s)				am HC  0.1500
CHB 2CH:	C	(C4A a C1B a HHB s)		am CD -0.1100
HHB HDM HC13:	H	(CHB s)				am HC  0.1500
CHC 3CH:	C	(C4B a C1C a HHC s)		am CD -0.1100
HHC HAM HC20:	H	(CHC s)				am HC  0.1500
CHD 4CH:	C	(C4C a C1D a HHD s)		am CD -0.1100
HHD HBM HC27:	H	(CHD s)				am HC  0.1500
N_A NA 1N:	N	(FE s C1A a C4A a)		am NP -0.1800
C1A 1C1:	C	(CHA a N_A a C2A a)		am CC  0.0300
C2A 1C2:	C	(C1A a C3A a CAA s)		am CB -0.0200
C3A 1C3:	C	(C2A a C4A a CMA s)		am CB  0.0200
C4A 1C4:	C	(CHB a N_A a C3A a)		am CC  0.0200
CMA 1CM:	C	(C3A s 1HMA s 2HMA s 3HMA s)	am CT -0.2650
1HMA HM81 HC10:	H	(CMA s)				am HC  0.0750
2HMA HM82 HC11:	H	(CMA s)				am HC  0.0750
3HMA HM83 HC12:	H	(CMA s)				am HC  0.0750
CAA 1CA:	C	(C2A s CBA s 1HAA s 2HAA s)	am CT -0.1600
1HAA HP71 HC6:	H	(CAA s)				am HC  0.1000
2HAA HP72 HC7:	H	(CAA s)				am HC  0.1000
CBA 1CB:	C	(CAA s CGA s 1HBA s 2HBA s)	am CT -0.3000
1HBA HP73 HC8:	H	(CBA s)				am HC  0.1000
2HBA HP74 HC9:	H	(CBA s)				am HC  0.1000
CGA 1CG:	C	(O1A a O2A a)			am C   0.3000
O1A 1O1:	O	(CGA a)				am O2 -0.5000
O2A 1O2:	O	(CGA a)				am O2 -0.5000
N_B NB 2N:	N	(FE s C1B a C4B a)		am NO -0.1800
C1B 2C1:	C	(CHB a N_B a C2B a)		am CC  0.0300
C2B 2C2:	C	(C1B a C3B a CMB s)		am CB  0.0200
C3B 2C3:	C	(C2B a C4B a CAB s)		am CB -0.0500
C4B 2C4:	C	(CHC a N_B a C3B a)		am CC  0.0200
CMB 2CM:	C	(C2B s 1HMB s 2HMB s 3HMB s)	am CT -0.2650
1HMB HM11 HC14:	H	(CMB s)				am HC  0.0750
2HMB HM12 HC15:	H	(CMB s)				am HC  0.0750
3HMB HM13 HC16:	H	(CMB s)				am HC  0.0750
CAB 2CA:	C	(C3B s CBB d HAB s)		am CY -0.1300
HAB HV2A HC17:	H	(CAB s)				am HC  0.1500
CBB 2CB:	C	(CAB d 1HBB s 2HBB s)		am CX -0.3000
1HBB HV2C HC18:	H	(CBB s)				am HC  0.1000
2HBB HV2T HC19:	H	(CBB s)				am HC  0.1000
N_C NC 3N:	N	(FE s C1C a C4C a)		am NP -0.1800
C1C 3C1:	C	(CHC a N_C a C2C a)		am CC  0.0300
C2C 3C2:	C	(C1C a C3C a CMC s)		am CB  0.0200
C3C 3C3:	C	(C2C a C4C a CAC s)		am CB -0.0500
C4C 3C4:	C	(CHD a N_C a C3C a)		am CC  0.0200
CMC 3CM:	C	(C2C s 1HMC s 2HMC s 3HMC s)	am CT -0.2650
1HMC HM31 HC21:	H	(CMC s)				am HC  0.0750
2HMC HM32 HC22:	H	(CMC s)				am HC  0.0750
3HMC HM33 HC23:	H	(CMC s)				am HC  0.0750
CAC 3CA:	C	(C3C s CBC d HAC s)		am CY -0.1200
HAC HV4A HC24:	H	(CAC s)				am HC  0.1500
CBC 3CB:	C	(CAC d 1HBC s 2HBC s)		am CX -0.3000
1HBC HV4C HC25:	H	(CBC s)				am HC  0.1000
2HBC HV4T HC26:	H	(CBC s)				am HC  0.1000
N_D ND 4N:	N	(FE s C1D a C4D a)		am NO -0.1800
C1D 4C1:	C	(CHD a N_D a C2D a)		am CC  0.0300
C2D 4C2:	C  	(CMD s C1D a C3D a)		am CB  0.0200
C3D 4C3:	C 	(CAD s C2D a C4D a)		am CB -0.0200
C4D 4C4:	C	(CHA a N_D a C3D a)		am CC  0.0200
CMD 4CM:	C 	(C2D s 1HMD s 2HMD s 3HMD s)	am CT -0.2650
1HMD HM51 HC28:	H	(CMD s)				am HC  0.0750
2HMD HM52 HC29:	H	(CMD s)				am HC  0.0750
3HMD HM53 HC30:	H	(CMD s)				am HC  0.0750
CAD 4CA:	C 	(C3D s CBD s 1HAD s 2HAD s)	am CT -0.1600
1HAD HP61 HC32:	H	(CAD s)				am HC  0.1000
2HAD HP62 HC33:	H	(CAD s)				am HC  0.1000
CBD 4CB:	C	(CAD s CGD s 1HBD s 2HBD s)	am CT -0.3000
1HBD HP63 HC34:	H	(CBD s)				am HC  0.1000
2HBD HP64 HC35:	H	(CBD s)				am HC  0.1000
CGD 4CG:	C	(O1D a O2D a)			am C   0.3000
O1D 4O1:	O	(CGD a)				am O2 -0.5000
O2D 4O2:	O	(CGD a)				am O2 -0.5000



;
;
;*****************************************************************************
;*
;*	Templates for Nucleic Acids
;*
;*****************************************************************************
;

; Dummy residue needed for program internals - do not delete!
[DUP]*
O3* O3' DUP:		O 9	(+4 s)	\
				amber	O	0.0

; Dummy residue needed for program internals - do not delete!
[DUX]*
P DUX:			P 4	(+9 s)	\
				amber	O	0.0

;
; D-ADENOSINE
;
[DA -DA]N
P:			P 4	(O1P s O2P s O5* s -9 s)	\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int O5*  1.600 C5*  119.04 C4* -200.85 \
				int -9   1.600 -8   119.04 -7  -200.85 
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  76.68 \
				int P    1.480 -9   109.61 -8  -214.89 
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  -155.044 \
				int P    1.480 -9   109.58 -8  -342.91 
O5* O5':		O 5	(C5* s P s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C5*  1.440 C4*  110.43 C3*  -98.89 \
				int P   1.600 -9   101.43 -8   -98.89 
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)\
				opls	CT	0.0000	\
				amber	CT	0.1180	\
				int C4*  1.52 C3*  119.00 O3* -39.22 \
				int O5*  1.440 P   119.00 -9   -39.22 
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0210	\
				int C5*  1.090
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0210	\
				int C5*  1.090
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)\
				opls	CT	0.1500	\
				amber	CT	0.0360	\
				int C3*  1.530 O3*  116.52 +4  -133.00 \
				int C5*  1.520 O5*  110.00 P  -151.00 
H4* D4* H4' H_6:	H 	(C4* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0560	\
				int C4*  1.090 C5*  109.50 O5* -200.00
O4* O4':		O 	(C4* s C1* s)		\
				opls	OS	-0.5000	\
				amber	OS	-0.3680	\
				int C4*  1.460 C5*  108.86 O5*  -86.31
C1* C1':		C 	(O4* s H1* s N9 s C2* s)\
				opls	CT	0.5000	\
				amber	CT	0.3760	\
				int O4*  1.420 C4*  110.04 C5*  105.60
H1* D1* H1' H11:	H 	(C1* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0090	\
				int C1*  1.090 O4*  109.50 C4* -240.00
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)\
				opls	CT	0.1000	\
				amber	CT	0.2330	\
				int O3*  1.42 +4 119.04 +5 -157.00 \
				int C4*  1.530 C5*  115.78 O5* -329.11 
H3* D3* H3' H_8:	H 	(C3* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0250	\
				int C3*  1.090 
C2* C2':		C 	(C3* s 1H2* s 2H2* s C1* s)\
				opls	CT	-0.2000	\
				amber	CT	-0.3070	\
				int C3*  1.530 C4*  102.80 C5*  -86.30
1H2* 1D2* H2'1 1H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0810	\
				int C2*  1.090 C3*  109.50 C4*  120.00
2H2* 2D2* H2'2 2H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0810	\
				int C2*  1.090 C3*  109.50 C4*  240.00
O3* O3':		O 9	(C3* s +4 s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C3*  1.420 C4*  116.52 C5* -203.47 \
				int +4   1.600 +5 101.43 +6 -41.00
N9:			N 	(C1* s C8 a C4 a)	\
				opls	N*	-0.5000	\
				amber	N*	-0.0730	\
				int C1*  1.520 O4*  109.59 C4* -127.70
C8:			C 	(N9 a H8 s N7 a)	\
				opls	CK	0.2000	\
				amber	CK	0.2630	\
				int N9   1.370 C1*  131.20 C4   180.00 ;	\
				int N9   1.370 C1*  131.20 O4*   81.59
H8 D8 H13:		H 	(C8 s)			\
				opls	HC	0.2000	\
				amber	HC	0.0620	\
				int C8   1.080 N9   120.00 C1*    0.00 
N7:			N 	(C8 a C5 a)		\
				opls	NB	-0.4900	\
				amber	NB	-0.5430	\
				int C8   1.300 N9   113.93 C1*  177.00
C5:			C 	(N7 a C6 a C4 a)	\
				opls	CB	0.1500	\
				amber	CB	-0.0970	\
				int C4	1.363  N9   107.09 C1* -177.30	\
				int N7   1.390 C8   104.00 N9     0.00
C6:			C 	(C5 a N6 s N1 a)	\
				opls	CA	0.4400	\
				amber	CA	0.7690	\
				int C5   1.400 N7   132.42 C8   180.00
N6:			N 	(C6 s 1H6 s 2H6 s)	\
				opls	N2	-0.8100	imp C6 1H6 N6 2H6 \
				amber	N2	-0.7680	\
				int C6   1.340 C5   123.50 N7     0.00
1H6 1D6 H61 1H17:	H 	(N6 s)			\
				opls	H2	0.3550	\
				amber	H2	0.3240	\
				int N6   1.010 C6   120.00 C5     0.00
2H6 2D6 H62 2H17:	H 	(N6 s)			\
				opls	H2	0.3850	\
				amber	H2	0.3350	\
				int N6   1.010 C6   120.00 C5   180.00
N1:			N 	(C6 a C2 a)		\
				opls	NC	-0.5300	\
				amber	NC	-0.7740	\
				int C6   1.340 C5   117.43 N7   180.00
C2:			C 	(N1 a H2 s N3 a)	\
				opls	CQ	0.2200	\
				amber	CQ	0.6610	\
				int N1   1.330 C6   118.80 C5     0.00
H2 D2 H19:		H 	(C2 s)			\
				opls	HC	0.2000	\
				amber	HC	-0.0320	\
				int C2   1.080 N1   120.00 C6   180.00
N3:			N 	(C2 a C4 a)		\
				opls	NC	-0.5500	\
				amber	NC	-0.7280	\
				int C4   1.350 N9   126.74 C1*    0.0	\
				int C2   1.320 N1   129.17 C6     0.00
C4:			C 	(N3 a C5 a N9 a)	\
				opls	CB	0.3800	\
				amber	CB	0.5460	\
				int N9   1.365 C1*  123.71 O4* -101.90	\
				int N3   1.350 C2   110.80 N1     0.00

;
; THY
;
[DT T -DT]N
P:			P 4	(O1P s O2P s O5* s -9 s)		\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int O5*  1.600 C5*  119.04 C4* -200.85 \
				int -9   1.600 -8   119.04 -7  -200.85
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  76.68 \
				int P    1.480 -9   109.61 -8  -214.89 
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  -155.044 \
				int P    1.480 -9   109.58 -8  -342.91 
O5* O5':		O 5 	(C5* s P s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C5*  1.440 C4*  110.43 C3*  -98.89 \
				int P   1.600 -9   101.43 -8   -98.89
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)\
				opls	CT	0.0000	\
				amber	CT	0.1180	\
				int C4*  1.52 C3*  119.00 O3* -39.22 \
				int O5*  1.440 P   119.00 -9   -39.22
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0210	\
				int C5*  1.090
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0210	\
				int C5*  1.090
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)\
				opls	CT	0.1500	\
				amber	CT	0.0360	\
				int C3*  1.530 O3*  116.52 +4  -133.00 \
				int C5*  1.520 O5*  110.00 P  -151.00
H4* D4* H4' H_6:	H 	(C4* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0560	\
				int C4*  1.090 C5*  109.50 O5* -200.00
O4* O4':		O 	(C4* s C1* s)		\
				opls	OS	-0.5000	\
				amber	OS	-0.3680	\
				int C4*  1.460 C5*  108.86 O5*  -86.31
C1* C1':		C 	(O4* s H1* s N1 s C2* s)\
				opls	CT	0.5600	\
				amber	CT	0.3760	\
				int O4*  1.420 C4*  110.04 C5*  105.60
H1* D1* H1' H11:	H 	(C1* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0090	\
				int C1*  1.090
N1:			N 	(C1* s C6 s C2 s)	\
				opls	N*	-0.6000	\
				amber	N*	-0.2170	\
				int C1*  1.530 O4*  109.59 C4* -127.70
C6:			C 	(N1 s H6 s C5 d)	\
				opls	CM	0.0800	\
				amber	CM	0.0340	\
				int N1   1.370 C1*  123.04 C2   180.00
;	\
				int N1   1.370 C1*  123.04 O4*   81.59
H6 D6 H20:		H 	(C6 s)			\
				opls	HC	0.1000	\
				amber	HC	0.1340	\
				int C6   1.080 N1   120.00 C1*    0.00
C5:			C 	(C6 d C7 s C4 s)	\
				opls	CM	-0.0700	\
				amber	CM	-0.1760	\
				int C6   1.340 N1   121.22 C1*  177.30
C5M C7:			C 	(C5 s 1H5M s 2H5M s 3H5M s)\
				opls	CT	-0.1400	\
				amber	CT	-0.3820	\
				int C5   1.500 C6   121.63 N1   180.00
1H5M 1D5M H71 1H19:	H 	(C7 s)			\
				opls	HC	0.0800	\
				amber	HC	0.1140	\
				int C7   1.090 C5   109.50 C6    60.00
2H5M 2D5M H72 2H19:	H 	(C7 s)			\
				opls	HC	0.0800	\
				amber	HC	0.1140	\
				int C7   1.090 C5   109.50 C6   180.00
3H5M 3D5M H73 3H19:	H 	(C7 s)			\
				opls	HC	0.0800	\
				amber	HC	0.1140	\
				int C7   1.090 C5   109.50 C6   300.00
C4:			C 	(C5 s O4 d N3 s)	\
				opls	C	0.4500 imp C5 N3 C4 O4 \
				amber	C	0.8090	\
				int C5   1.440 C6   120.78 N1     0.00
O4:			O 	(C4 d)			\
				opls	O	-0.4200	\
				amber	O	-0.4640	\
				int C4   1.230 C5   125.35 C6   180.00
N3:			N 	(C4 s H3 s C2 s)	\
				opls	NA	-0.5100	imp C2 C4 N3 H3 \
				amber	NA	-0.8510	\
				int C4   1.380 C5   114.07 C6     0.00
H3 D3 H15:		H 	(N3 s)			\
				opls	H	0.3600	\
				amber	H	0.3550	\
				int N3   1.090 C4   116.77 C5   180.00
C2:			C 	(N3 s O2 d N1 s)	\
				opls	C	0.5000 imp N1 N3 C2 O2 \
				amber	C	0.8490	\
				int N1   1.370 C1*  114.7  O4* -100.92	\
				int N3   1.380 C4   126.46 C5     0.00
O2:			O 	(C2 d)			\
				opls	O	-0.4000	\
				amber	O	-0.4880	\
				int C2   1.220 N3   121.70 C4   180.00
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)\
				opls	CT	0.1000	\
				amber	CT	0.2330	\
				int O3*  1.42 +4 119.04 +5 -157.00 \
				int C4*  1.530 C5*  115.78 O5* -329.11
H3* D3* H3' H_8:	H 	(C3* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0250	\
				int C3*  1.090 
C2* C2':		C 	(C3* s 1H2* s 2H2* s C1* s)\
				opls	CT	-0.2000	\
				amber	CT	-0.3070	\
				int C3*  1.530 C4*  102.80 C5*  -86.30
1H2* 1D2* H2'1 1H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0810	\
				int C2*  1.090 C3*  109.50 C4*  120.00
2H2* 2D2* H2'2 2H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0810	\
				int C2*  1.090 C3*  109.50 C4*  240.00
O3* O3':		O 9 	(C3* s +4 s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C3*  1.420 C4*  116.52 C5* -203.47 \
				int +4   1.600 +5 101.43 +6 -41.00

;
; D-CYTOSINE
;
[DC -DC]N
P:			P 4	(O1P s O2P s O5* s -9 s)	\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int O5*  1.600 C5*  119.04 C4* -200.85 \
				int -9   1.600 -8   119.04 -7  -200.85
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  76.68 \
				int P    1.480 -9   109.61 -8  -214.89 
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  -155.044 \
				int P    1.480 -9   109.58 -8  -342.91 
O5* O5':		O 5	(C5* s P s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C5*  1.440 C4*  110.43 C3*  -98.89 \
				int P    1.600 -9   101.43 -8   -98.89
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)\
				opls	CT	0.0000	\
				amber	CT	0.1180	\
				int C4*  1.52 C3*  119.00 O3* -39.22 \
				int O5*  1.440 P  119.00 -9   -39.22
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0210	\
				int C5*  1.090
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0210	\
				int C5*  1.090
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)\
				opls	CT	0.1500	\
				amber	CT	0.0360	\
				int C3*  1.530 O3*  116.52 +4  -133.00 \
				int C5*  1.520 O5*  110.00 P  -151.00
H4* D4* H4' H_6:	H 	(C4* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0560	\
				int C4*  1.090
O4* O4':		O 	(C4* s C1* s)		\
				opls	OS	-0.5000	\
				amber	OS	-0.3680	\
				int C4*  1.460 C5*  108.86 O5*  -86.31
C1* C1':		C 	(O4* s H1* s N1 s C2* s)\
				opls	CT	0.5300	\
				amber	CT	0.3760	\
				int O4*  1.420 C4*  110.04 C5*  105.60
H1* D1* H1' H11:	H 	(C1* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0090	\
				int C1*  1.090
N1:			N 	(C1* s C6 s C2 s)	\
				opls	N*	-0.5600	\
				amber	N*	-0.1870	\
				int C1*  1.490 O4*  108.10 C4* -127.70
C6:			C 	(N1 s H6 s C5 d)	\
				opls	CM	0.1000	\
				amber	CM	0.1850	\
				int N1   1.360 C1*  121.10 C2   180.00
;	\
				int N1   1.360 C1*  121.10 O4*   81.59
H6 D6 H19:		H 	(C6 s)			\
				opls	HC	0.1000	\
				amber	HC	0.0980	\
				int C6   1.080 N1   120.00 C1*    0.00
C5:			C 	(C6 d H5 s C4 s)	\
				opls	CM	-0.0600	\
				amber	CM	-0.5760	\
				int C6   1.360 N1   121.00 C1*  180.00
H5 D5 H18:		H 	(C5 s)			\
				opls	HC	0.1000	\
				amber	HC	0.1530	\
				int C5   1.090 C6   120.00 N1   180.00
C4:			C 	(C5 s N4 s N3 d)	\
				opls	CA	0.4600	\
				amber	CA	0.9350	\
				int C5   1.430 C6   116.90 N1     0.00
N4:			N 	(C4 s 1H4 s 2H4 s)	\
				opls	N2	-0.7900 imp C4 1H4 N4 2H4 \
				amber	N2	-0.8340	\
				int C4   1.320 C5   120.10 C6   180.00
1H4 1D4 H41 1H17:	H 	(N4 s)			\
				opls	H2	0.3550	\
				amber	H2	0.3290	\
				int N4   1.010 C4   117.70 C5     0.00
2H4 2D4 H42 2H17:	H 	(N4 s)			\
				opls	H2	0.3850	\
				amber	H2	0.3510	\
				int N4   1.010 C4   120.27 C5   180.00
N3:			N 	(C4 d C2 s)		\
				opls	NC	-0.5400	\
				amber	NC	-0.8600	\
				int C4   1.330 C5   121.70 C6     0.00
C2:			C 	(N3 s O2 d N1 s)	\
				opls	C	0.5500 imp N1 N3 C2 O2 \
				amber	C	0.8590	\
				int N1   1.388 C1*  118.05 O4*  -98.41	\
				int N3   1.360 C4   120.50 C5     0.00
O2:			O 	(C2 d)			\
				opls	O	-0.4800	\
				amber	O	-0.5080	\
				int C2   1.240 N3   122.40 C4   180.00
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)\
				opls	CT	0.1000	\
				amber	CT	0.2330	\
				int O3*  1.42 +4 119.04 +5 -157.00 \
				int C4*  1.530 C5*  115.78 O5* -329.11
H3* D3* H3' H_8:	H 	(C3* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0250	\
				int C3*  1.090 
C2* C2':		C 	(C3* s 1H2* s 2H2* s C1* s)\
				opls	CT	-0.2000	\
				amber	CT	-0.3070	\
				int C3*  1.530 C4*  102.80 C5*  -86.30
1H2* 1D2* H2'1 1H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0810	\
				int C2*  1.090 C3*  109.50 C4*  120.00
2H2* 2D2* H2'2 2H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0810	\
				int C2*  1.090 C3*  109.50 C4*  240.00
O3* O3':		O 9	(C3* s +4 s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C3*  1.420 C4*  116.52 C5* -203.47 \
				int +4   1.600 +5 101.43 +6 -41.00




; D-GUANOSINE
[DG -DG]N
P:			P 4	(O1P s O2P s O5* s -9 s)		\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int O5*  1.600 C5*  119.04 C4* -200.85 \
				int -9   1.600 -8   119.04 -7  -200.85
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  76.68 \
				int P    1.480 -9   109.61 -8  -214.89 
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  -155.044 \
				int P    1.480 -9   109.58 -8  -342.91 
O5* O5':		O 5  	(C5* s P s)			\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C5*  1.440 C4*  110.43 C3*  -98.89 \
				int P  1.600 -9   101.43 -8   -98.89
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)\
				opls	CT	0.0000	\
				amber	CT	0.1180	\
				int C4*  1.52 C3*  119.00 O3* -39.22 \
				int O5*  1.440 P   119.00 -9   -39.22
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0210	\
				int C5*  1.090
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0210	\
				int C5*  1.090
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)	\
				opls	CT	0.1500	\
				amber	CT	0.0360	\
				int C3*  1.530 O3*  116.52 +4  -133.00 \
				int C5*  1.520 O5*  110.00 P -151.00
H4* D4* H4' H_6:	H 	(C4* s)	\
				opls	HC	0.1000	\
				amber	HC	0.0560	\
				int C4*  1.090
O4* O4':		O 	(C4* s C1* s)	\
				opls	OS	-0.5000	\
				amber	OS	-0.3680	\
				int C4*  1.460 C5*  108.86 O5*  -86.31
C1* C1':		C 	(O4* s H1* s N9 s C2* s)\
				opls	CT	0.5000	\
				amber	CT	0.3760	\
				int O4*  1.420 C4*  110.04 C5*  105.60
H1* D1* H1' H11:	H 	(C1* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0090	\
				int C1*  1.090
N9:			N 	(C1* s C8 s C4 s)	\
				opls	N*	-0.5000	\
				amber	N*	-0.0420	\
				int C1*  1.490 O4*  108.06 C4* -127.70
C8:			C 	(N9 s H8 s N7 d)	\
				opls	CK	0.2000	\
				amber	CK	0.2660	\
				int N9   1.380 C1*  129.20 C4   180.00
;	\
				int N9   1.380 C1*  129.20 O4*   81.59
H8 D8 H13:		H 	(C8 s)			\
				opls	HC	0.2000	\
				amber	HC	0.0460	\
				int C8   1.080 N9   120.00 C1*    0.00
N7:			N 	(C8 d C5 s)		\
				opls	NB	-0.4900	\
				amber	NB	-0.5430	\
				int C8   1.310 N9   114.00 C1* -179.90
C5:			C 	(N7 s C6 s C4 d)	\
				opls	CB	0.1200	\
				amber	CB	-0.0600	\
				int C4   1.370 N9   107.15 C1*  179.80	\
				int N7   1.390 C8   103.90 N9     0.00
C6:			C 	(C5 s O6 d N1 s)	\
				opls	C	0.5200 imp C5 N1 C6 O6 \
				amber	C	0.6900	\
				int C5   1.420 N7   130.40 C8   180.00
O6:			O 	(C6 d)			\
				opls	O	-0.5100	\
				amber	O	-0.4580	\
				int C6   1.230 C5   128.80 N7     0.00
N1:			N 	(C6 s H1 s C2 s)	\
				opls	NA	-0.5600 imp C6 C2 N1 H1 \
				amber	NA	-0.7290	\
				int C6   1.400 C5   111.38 N7   180.00
H1 D1 H18:		H 	(N1 s)			\
				opls	H	0.3800	\
				amber	H	0.3360	\
				int N1   1.000 C6   117.36 C5   179.90
C2:			C 	(N1 s N2 s N3 d)	\
				opls	CA	0.4600	\
				amber	CA	0.8710	\
				int N1   1.380 C6   125.24 C5    -0.10
N2:			N 	(C2 s 1H2 s 2H2 s)	\
				opls	N2	-0.8000 imp C2 1H2 N2 2H2 \
				amber	N2	-0.7780	\
				int C2   1.340 N1   116.02 C6   180.00
1H2 1D2 H21 1H20:	H 	(N2 s)			\
				opls	H2	0.4000	\
				amber	H2	0.3250	\
				int N2   1.010 C2   127.00 N1    -0.82
2H2 2D2 H22 2H20:	H 	(N2 s)			\
				opls	H2	0.4000	\
				amber	H2	0.3390	\
				int N2   1.010 C2   116.53 N1  -179.44
N3:			N 	(C2 d C4 s)		\
				opls	NC	-0.5100	\
				amber	NC	-0.7090	\
				int C4   1.360 N9   124.30 C1*    0.15	\
				int C2   1.330 N1   123.30 C6     0.00
C4:			C 	(N3 s C5 d N9 s)	\
				opls	CB	0.3400	\
				amber	CB	0.3910	\
				int N9   1.373 C1*  126.12 O4*  -98.51	\
				int N3   1.360 C2   112.20 N1     0.00
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)\
				opls	CT	0.1000	\
				amber	CT	0.2330	\
				int O3*  1.42 +4 119.04 +5 -157.00 \
				int C4*  1.530 C5*  115.78 O5* -329.11
H3* D3* H3' H_8:	H 	(C3* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0250	\
				int C3*  1.090 
C2* C2':		C 	(C3* s 1H2* s 2H2* s C1* s)\
				opls	CT	-0.2000	\
				amber	CT	-0.3070	\
				int C3*  1.530 C4*  102.80 C5*  -86.30
1H2* 1D2* H2'1 1H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0810	\
				int C2*  1.090 C3*  109.50 C4*  120.00
2H2* 2D2* H2'2 2H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0810	\
				int C2*  1.090 C3*  109.50 C4*  240.00
O3* O3':		O 9  	(C3* s +4 s)			\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C3*  1.420 C4*  116.52 C5* -203.47 \
				int +4   1.600 +5 101.43 +6 -41.00

;
; R-ADENOSINE
;
[RA A +A -RA]N
P:			P 4	(O1P s O2P s O5* s -9 s)	\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int O5*  1.600 C5*  119.04 C4* -200.85 \
				int -9   1.600 -8   119.04 -7  -200.85
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  76.68 \
				int P    1.480 -9   109.61 -8  -214.89 
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  -155.044 \
				int P    1.480 -9   109.58 -8  -342.91 
O5* O5':		O 5	(C5* s P s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C5*  1.440 C4*  110.43 C3*  -98.89 \
				int P   1.600 -9   101.43 -8   -98.89
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)\
				opls	CT	0.0000	\
				amber	CT	0.1800	\
				int C4*  1.52 C3*  119.00 O3* -39.22 \
				int O5*  1.440 P   119.00 -9   -39.22
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C5*  1.090
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C5*  1.090
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)\
				opls	CT	0.1500	\
				amber	CT	0.1000	\
				int C3*  1.530 O3*  116.52 +4  -133.00 \
				int C5*  1.520 O5*  110.00 P  -151.00
H4* D4* H4' H_6:	H 	(C4* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0610	\
				int C4*  1.090
O4* O4':		O 	(C4* s C1* s)		\
				opls	OS	-0.5000	\
				amber	OS	-0.3430	\
				int C4*  1.460 C5*  108.86 O5*  -86.31
C1* C1':		C 	(O4* s H1* s N9 s C2* s)\
				opls	CT	0.5000	\
				amber	CT	0.1170	\
				int O4*  1.420 C4*  110.04 C5*  105.60
H1* D1* H1' H12:	H 	(C1* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0540	\
				int C1*  1.090
N9:			N 	(C1* s C8 a C4 a)	\
				opls	N*	-0.5000	\
				amber	N*	-0.0730	\
				int C1*  1.520 O4*  109.59 C4* -127.70
C8:			C 	(N9 a H8 s N7 a)	\
				opls	CK	0.2000	\
				amber	CK	0.2630	\
				int N9   1.370 C1*  131.20 C4   180.00
;	\
				int N9   1.370 C1*  131.20 O4*   81.59
H8 D8 H14:		H 	(C8 s)			\
				opls	HC	0.2000	\
				amber	HC	0.0620	\
				int C8   1.080 N9   120.00 C1*    0.00
N7:			N 	(C8 a C5 a)		\
				opls	NB	-0.4900	\
				amber	NB	-0.5430	\
				int C8   1.300 N9   113.93 C1*  177.00
C5:			C 	(N7 a C6 a C4 a)	\
				opls	CB	0.1500	\
				amber	CB	-0.0970	\
				int C4	1.363  N9   107.09 C1* -177.30	\
				int N7   1.390 C8   104.00 N9     0.00
C6:			C 	(C5 a N6 s N1 a)	\
				opls	CA	0.4400	\
				amber	CA	0.7690	\
				int C5   1.400 N7   132.42 C8   180.00
N6:			N 	(C6 s 1H6 s 2H6 s)	\
				opls	N2	-0.8100 imp C6 1H6 N6 2H6 \
				amber	N2	-0.7680	\
				int C6   1.340 C5   123.50 N7     0.00
1H6 1D6 H61 1H18:	H 	(N6 s)			\
				opls	H2	0.3550	\
				amber	H2	0.3240	\
				int N6   1.010 C6   120.00 C5     0.00
2H6 2D6 H62 2H18:	H 	(N6 s)			\
				opls	H2	0.3850	\
				amber	H2	0.3350	\
				int N6   1.010 C6   120.00 C5   180.00
N1:			N 	(C6 a C2 a)		\
				opls	NC	-0.5300	\
				amber	NC	-0.7740	\
				int C6   1.340 C5   117.43 N7   180.00
C2:			C 	(N1 a H2 s N3 a)	\
				opls	CQ	0.2200	\
				amber	CQ	0.6610	\
				int N1   1.330 C6   118.80 C5     0.00
H2 D2 H20:		H 	(C2 s)			\
				opls	HC	0.2000	\
				amber	HC	-0.0320	\
				int C2   1.080 N1   120.00 C6   180.00
N3:			N 	(C2 a C4 a)		\
				opls	NC	-0.5500	\
				amber	NC	-0.7280	\
				int C4   1.350 N9   126.74 C1*    0.0	\
				int C2   1.320 N1   129.17 C6     0.00
C4:			C 	(N3 a C5 a N9 a)	\
				opls	CB	0.3800	\
				amber	CB	0.5460	\
				int N9   1.365 C1*  123.71 O4* -101.90	\
				int N3   1.350 C2   110.80 N1     0.00
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)\
				opls	CT	0.1000	\
				amber	CT	0.3030	\
				int O3*  1.42 +4 119.04 +5 -157.00 \
				int C4*  1.530 C5*  115.78 O5* -329.11
H3* D3* H3' H_8:	H 	(C3* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0070	\
				int C3*  1.090 
C2* C2':		C 	(C3* s H2* s O2* s C1* s)\
				opls	CT	0.1650	\
				amber	CT	0.1010	\
				int C3*  1.530 C4*  102.80 C5*  -86.30
H2* D2* H2' H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C2*  1.090 C3*  109.50 C4*  120.00
O2* O2':		O 	(C2* s HO2 s)		\
				opls	OH	-0.7000	\
				amber	OH	-0.5460	\
				int C2*  1.430 C3*  109.50 C4*  240.00
HO2 DO2 H11:		H 	(O2* s)			\
				opls	HO	0.4350	\
				amber	HO	0.3240	\
				int O2*  0.960
O3* O3':		O 9	(C3* s +4 s)			\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C3*  1.420 C4*  116.52 C5* -203.47 \
				int +4   1.600 +5 101.43 +6 -41.00

;
; URACIL
;
[RU U -RU]N
P:			P 4	(O1P s O2P s O5* s -9 s)	\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int O5*  1.600 C5*  119.04 C4* -200.85 \
				int -9   1.600 -8   119.04 -7  -200.85
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  76.68 \
				int P    1.480 -9   109.61 -8  -214.89 
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  -155.044 \
				int P    1.480 -9   109.58 -8  -342.91 
O5* O5':		O 5	(C5* s P s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C5*  1.440 C4*  110.43 C3*  -98.89 \
				int P    1.600 -9   101.43 -8   -98.89
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)\
				opls	CT	0.0000	\
				amber	CT	0.1800	\
				int C4*  1.52 C3*  119.00 O3* -39.22 \
				int O5*  1.440 P   119.00 -9   -39.22
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C5*  1.090
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C5*  1.090
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)\
				opls	CT	0.1500	\
				amber	CT	0.1000	\
				int C3*  1.530 O3*  116.52 +4  -133.00 \
				int C5*  1.520 O5*  110.00 P  -151.00
H4* D4* H4' H_6:	H 	(C4* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0610	\
				int C4*  1.090
O4* O4':		O 	(C4* s C1* s)		\
				opls	OS	-0.5000	\
				amber	OS	-0.3430	\
				int C4*  1.460 C5*  108.86 O5*  -86.31
C1* C1':		C 	(O4* s H1* s N1 s C2* s)\
				opls	CT	0.5600	\
				amber	CT	0.1170	\
				int O4*  1.420 C4*  110.04 C5*  105.60
H1* D1* H1' H12:	H 	(C1* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0540	\
				int C1*  1.090
N1:			N 	(C1* s C6 s C2 s)	\
				opls	N*	-0.6000	\
				amber	N*	-0.1590	\
				int C1*  1.530 O4*  109.59 C4* -127.70
C6:			C 	(N1 s H6 s C5 d)	\
				opls	CM	0.0800	\
				amber	CM	0.1600	\
				int N1   1.370 C1*  123.04 C2   180.00 ;	\
				int N1   1.370 C1*  123.04 O4*   81.59
H6 D6 H20:		H 	(C6 s)			\
				opls	HC	0.1000	\
				amber	HC	0.0980	\
				int C6   1.080 N1   120.00 C1*    0.00
C5:			C 	(C6 d H5 s C4 s)	\
				opls	CM	-0.0700	\
				amber	CM	-0.5290	\
				int C6   1.340 N1   121.22 C1*  177.30
H5 D5 H19:		H 	(C5 s)			\
				opls	HC	0.1000	\
				amber	HC	0.1460	\
				int C5   1.090 C6   120.00 N1   180.00
C4:			C 	(C5 s O4 d N3 s)	\
				opls	C	0.4500 imp C5 N3 C4 O4 \
				amber	C	0.8340	\
				int C5   1.440 C6   120.78 N1     0.00
O4:			O 	(C4 d)			\
				opls	O	-0.4200	\
				amber	O	-0.4740	\
				int C4   1.230 C5   125.35 C6   180.00
N3:			N 	(C4 s H3 s C2 s)	\
				opls	NA	-0.5100 imp C2 C4 N3 H3 \
				amber	NA	-0.7680	\
				int C4   1.380 C5   114.07 C6     0.00
H3 D3 H16:		H 	(N3 s)			\
				opls	H	0.3600	\
				amber	H	0.3340	\
				int N3   1.090 C4   116.77 C5   180.00
C2:			C 	(N3 s O2 d N1 s)	\
				opls	C	0.5000 imp N1 N3 C2 O2 \
				amber	C	0.7750	\
				int N1   1.370 C1*  114.70 O4* -100.92	\
				int N3   1.380 C4   126.46 C5     0.00
O2:			O 	(C2 d)			\
				opls	O	-0.4000	\
				amber	O	-0.4720	\
				int C2   1.220 N3   121.70 C4   180.00
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)\
				opls	CT	0.1000	\
				amber	CT	0.3030	\
				int O3*  1.42 +4 119.04 +5 -157.00 \
				int C4*  1.530 C5*  115.78 O5* -329.11
H3* D3* H3' H_8:	H 	(C3* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0070	\
				int C3*  1.090 
C2* C2':		C 	(C3* s H2* s O2* s C1* s)\
				opls	CT	0.1650	\
				amber	CT	0.1010	\
				int C3*  1.530 C4*  102.80 C5*  -86.30
H2* D2* H2' H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C2*  1.090 C3*  109.50 C4*  120.00
O2* O2':		O 	(C2* s HO2 s)		\
				opls	OH	-0.7000	\
				amber	OH	-0.5460	\
				int C2*  1.430 C3*  109.50 C4*  240.00
HO2 DO2 H11:		H 	(O2* s)			\
				opls	HO	0.4350	\
				amber	HO	0.3240	\
				int O2*  0.960
O3* O3':		O 9 	(C3* s +4 s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C3*  1.420 C4*  116.52 C5* -203.47 \
				int +4   1.600 +5 101.43 +6 -41.00

;
; R-GUANOSINE
;
[RG G -RG]N
P:			P 4	(O1P s O2P s O5* s -9 s)	\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int O5*  1.600 C5*  119.04 C4* -200.85 \
				int -9   1.600 -8   119.04 -7 -200.85
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  76.68 \
				int P    1.480 -9   109.61 -8  -214.89 
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  -155.044 \
				int P    1.480 -9   109.58 -8  -342.91 
O5* O5':		O 5	(C5* s P s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C5*  1.440 C4*  110.43 C3*  -98.89 \
				int P   1.600 -9   101.43 -8   -98.89
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)\
				opls	CT	0.0000	\
				amber	CT	0.1800	\
				int C4*  1.52 C3*  119.00 O3* -39.22 \
				int O5*  1.440 P   119.00 -9   -39.22
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C5*  1.090
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C5*  1.090
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)\
				opls	CT	0.1500	\
				amber	CT	0.1000	\
				int C3*  1.530 O3*  116.52 +4  -133.00 \
				int C5*  1.520 O5*  110.00 P  -151.00
H4* D4* H4' H_6:	H 	(C4* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0610	\
				int C4*  1.090
O4* O4':		O 	(C4* s C1* s)		\
				opls	OS	-0.5000	\
				amber	OS	-0.3430	\
				int C4*  1.460 C5*  108.86 O5*  -86.31
C1* C1':		C 	(O4* s H1* s N9 s C2* s)\
				opls	CT	0.5000	\
				amber	CT	0.1170	\
				int O4*  1.420 C4*  110.04 C5*  105.60
H1* D1* H1' H12:	H 	(C1* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0540	\
				int C1*  1.090
N9:			N 	(C1* s C8 s C4 s)	\
				opls	N*	-0.5000	\
				amber	N*	-0.0420	\
				int C1*  1.490 O4*  108.06 C4* -127.70
C8:			C 	(N9 s H8 s N7 d)	\
				opls	CK	0.2000	\
				amber	CK	0.2660	\
				int N9   1.380 C1*  129.20 C4   180.00
;	\
				int N9   1.380 C1*  129.20 O4*   81.59
H8 D8 H14:		H 	(C8 s)			\
				opls	HC	0.2000	\
				amber	HC	0.0460	\
				int C8   1.080 N9   120.00 C1*    0.00
N7:			N 	(C8 d C5 s)		\
				opls	NB	-0.4900	\
				amber	NB	-0.5430	\
				int C8   1.310 N9   114.00 C1* -179.90
C5:			C 	(N7 s C6 s C4 d)	\
				opls	CB	0.1200	\
				amber	CB	-0.0600	\
				int C4   1.370 N9   107.15 C1*  179.80	\
				int N7   1.390 C8   103.90 N9     0.00
C6:			C 	(C5 s O6 d N1 s)	\
				opls	C	0.5200 imp C5 N1 C6 O6 \
				amber	C	0.6900	\
				int C5   1.420 N7   130.40 C8   180.00
O6:			O 	(C6 d)			\
				opls	O	-0.5100	\
				amber	O	-0.4580	\
				int C6   1.230 C5   128.80 N7     0.00
N1:			N 	(C6 s H1 s C2 s)	\
				opls	NA	-0.5600 imp C6 C2 N1 H1 \
				amber	NA	-0.7290	\
				int C6   1.400 C5   111.38 N7   180.00
H1 D1 H19:		H 	(N1 s)			\
				opls	H	0.3800	\
				amber	H	0.3360	\
				int N1   1.000 C6   117.36 C5   179.90
C2:			C 	(N1 s N2 s N3 d)	\
				opls	CA	0.4600	\
				amber	CA	0.8710	\
				int N1   1.380 C6   125.24 C5    -0.10
N2:			N 	(C2 s 1H2 s 2H2 s)	\
				opls	N2	-0.8000 imp C2 1H2 N2 2H2 \
				amber	N2	-0.7780	\
				int C2   1.340 N1   116.02 C6   180.00
1H2 1D2 H21 1H21:	H 	(N2 s)			\
				opls	H2	0.4000	\
				amber	H2	0.3250	\
				int N2   1.010 C2   127.00 N1    -0.82
2H2 2D2 H22 2H21:	H 	(N2 s)			\
				opls	H2	0.4000	\
				amber	H2	0.3390	\
				int N2   1.010 C2   116.53 N1  -179.44
N3:			N 	(C2 d C4 s)		\
				opls	NC	-0.5100	\
				amber	NC	-0.7090	\
				int C4   1.360 N9   124.30 C1*    0.15	\
				int C2   1.330 N1   123.30 C6     0.00
C4:			C 	(N3 s C5 d N9 s)	\
				opls	CB	0.3400	\
				amber	CB	0.3910	\
				int N9   1.373 C1*  126.12 O4*  -98.51	\
				int N3   1.360 C2   112.20 N1     0.00
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)\
				opls	CT	0.1000	\
				amber	CT	0.3030	\
				int O3*  1.42 +4 119.04 +5 -157.00 \
				int C4*  1.530 C5*  115.78 O5* -329.11
H3* D3* H3' H_8:	H 	(C3* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0070	\
				int C3*  1.090 
C2* C2':		C 	(C3* s H2* s O2* s C1* s)\
				opls	CT	0.1650	\
				amber	CT	0.1010	\
				int C3*  1.530 C4*  102.80 C5*  -86.30
H2* D2* H2' H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C2*  1.090 C3*  109.50 C4*  120.00
O2* O2':		O 	(C2* s HO2 s)		\
				opls	OH	-0.7000	\
				amber	OH	-0.5460	\
				int C2*  1.430 C3*  109.50 C4*  240.00
HO2 DO2 H11:		H 	(O2* s)			\
				opls	HO	0.4350	\
				amber	HO	0.3240	\
				int O2*  0.960
O3* O3':		O 9 	(C3* s +4 s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C3*  1.420 C4*  116.52 C5* -203.47 \
				int +4   1.600 +5 101.43 +6 -41.00

;
; R-CYTOSINE
;
[RC C +C -RC]N
P:			P 4 	(O1P s O2P s O5* s -9 s)		\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int O5*  1.600 C5*  119.04 C4* -200.85 \
				int -9   1.600 -8   119.04 -7  -200.85
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  76.68 \
				int P    1.480 -9   109.61 -8  -214.89 
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 O5*  109.58 C5*  -155.044 \
				int P    1.480 -9   109.58 -8  -342.91 
O5* O5':		O 5	(C5* s P s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C5*  1.440 C4*  110.43 C3*  -98.89 \
				int P    1.600 -9   101.43 -8   -98.89
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)\
				opls	CT	0.0000	\
				amber	CT	0.1800	\
				int C4*  1.52 C3*  119.00 O3* -39.22 \
				int O5*  1.440 P   119.00 -9   -39.22
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C5*  1.090
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C5*  1.090
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)\
				opls	CT	0.1500	\
				amber	CT	0.1000	\
				int C3*  1.530 O3*  116.52 +4  -133.00 \
				int C5*  1.520 O5*  110.00 P  -151.00
H4* D4* H4' H_6:	H 	(C4* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0610	\
				int C4*  1.090
O4* O4':		O 	(C4* s C1* s)		\
				opls	OS	-0.5000	\
				amber	OS	-0.3430	\
				int C4*  1.460 C5*  108.86 O5*  -86.31
C1* C1':		C 	(O4* s H1* s N1 s C2* s)\
				opls	CT	0.5300	\
				amber	CT	0.1170	\
				int O4*  1.420 C4*  110.04 C5*  105.60
H1* D1* H1' H12:	H 	(C1* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0540	\
				int C1*  1.090
N1:			N 	(C1* s C6 s C2 s)	\
				opls	N*	-0.5600	\
				amber	N*	-0.1870	\
				int C1*  1.490 O4*  108.10 C4* -127.70
C6:			C 	(N1 s H6 s C5 d)	\
				opls	CM	0.1000	\
				amber	CM	0.1850	\
				int N1   1.360 C1*  121.10 C2   180.00 ;	\
				int N1   1.360 C1*  121.10 O4*   81.59
H6 D6 H20:		H 	(C6 s)			\
				opls	HC	0.1000	\
				amber	HC	0.0980	\
				int C6   1.080 N1   120.00 C1*    0.00
C5:			C 	(C6 d H5 s C4 s)	\
				opls	CM	-0.0600	\
				amber	CM	-0.5760	\
				int C6   1.360 N1   121.00 C1*  180.00
H5 D5 H19:		H 	(C5 s)			\
				opls	HC	0.1000	\
				amber	HC	0.1530	\
				int C5   1.090 C6   120.00 N1   180.00
C4:			C 	(C5 s N4 s N3 d)	\
				opls	CA	0.4600	\
				amber	CA	0.9350	\
				int C5   1.430 C6   116.90 N1     0.00
N4:			N 	(C4 s 1H4 s 2H4 s)	\
				opls	N2	-0.7900 imp C4 1H4 N4 2H4 \
				amber	N2	-0.8340	\
				int C4   1.320 C5   120.10 C6   180.00
1H4 1D4 H41 1H18:	H 	(N4 s)			\
				opls	H2	0.3550	\
				amber	H2	0.3290	\
				int N4   1.010 C4   117.70 C5     0.00
2H4 2D4 H42 2H18:	H 	(N4 s)			\
				opls	H2	0.3850	\
				amber	H2	0.3510	\
				int N4   1.010 C4   120.27 C5   180.00
N3:			N 	(C4 d C2 s)		\
				opls	NC	-0.5400	\
				amber	NC	-0.8600	\
				int C4   1.330 C5   121.70 C6     0.00
C2:			C 	(N3 s O2 d N1 s)	\
				opls	C	0.5500 imp N1 N3 C2 O2 \
				amber	C	0.8590	\
				int N1   1.388 C1*  118.05 O4*  -98.41	\
				int N3   1.360 C4   120.50 C5     0.00
O2:			O 	(C2 d)			\
				opls	O	-0.4800	\
				amber	O	-0.5080	\
				int C2   1.240 N3   122.40 C4   180.00
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)\
				opls	CT	0.1000	\
				amber	CT	0.3030	\
				int O3*  1.42 +4 119.04 +5 -157.00 \
				int C4*  1.530 C5*  115.78 O5* -329.11
H3* D3* H3' H_8:	H 	(C3* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0070	\
				int C3*  1.090 
C2* C2':		C 	(C3* s H2* s O2* s C1* s)\
				opls	CT	0.1650	\
				amber	CT	0.1010	\
				int C3*  1.530 C4*  102.80 C5*  -86.30
H2* D2* H2' H10:	H 	(C2* s)			\
				opls	HC	0.1000	\
				amber	HC	0.0080	\
				int C2*  1.090 C3*  109.50 C4*  120.00
O2* O2':		O 	(C2* s HO2 s)		\
				opls	OH	-0.7000	\
				amber	OH	-0.5460	\
				int C2*  1.430 C3*  109.50 C4*  240.00
HO2 DO2 H11:		H 	(O2* s)			\
				opls	HO	0.4350	\
				amber	HO	0.3240	\
				int O2*  0.960
O3* O3':		O 9 	(C3* s +4 s)		\
				opls	OS	-0.4300	\
				amber	OS	-0.5090	\
				int C3*  1.420 C4*  116.52 C5* -203.47 \
				int +4   1.600 +5 101.43 +6 -41.00

;
; D-OH BEGIN Simulute Existing 3' Terminus to begin a strand
;
[5CAP 5CA -5CA]N
OXT O3* O3':		O 9	(H s +4 s)	\
				amber	OH	-0.5770	\
				int +4 1.48 +5 109.417221 +6 0.0
H3* D3* H3' H:			H 	(OXT s)	\
				amber	HO	0.2430	\
				int OXT 0.96 +4 109.471 +5 180.


;
; PHOSMI D
;
[3CAP 3CA -3CA]N
P:			P  4	(O1P s O2P s -9 s)	\
				opls	P	0.7800	\
				amber	P	1.3850	\
				int -9   1.600 -8   119.04 -7  -200.85
O1P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 -9   109.61 -8  -214.89
O2P:			O 	(P s)			\
				opls	O2	-0.6600	\
				amber	O2	-0.8470	\
				int P    1.480 -9   109.58 -8  -342.91


;
; H BEGINNING
;
[HB]*
H D:			H 	()	\
				opls	HO	0.5	\
				amber	HO	0.2790	\
				int -3   1.000

; H END
[HE]*
H D:			H 	()	\
				opls	HO	0.5	\
				amber	HO	0.3060	\
				int -3   0.960

;
; 1-Methyl Adenosine
;
[1MA]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N9 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N9:			N 	(C1* s C8 a C4 a)	
C8:			C 	(N9 a H8 s N7 a)	
H8 D8 H14:		H 	(C8 s)			
N7:			N 	(C8 a C5 a)		
C5:			C 	(N7 a C6 a C4 a)	
C6:			C 	(C5 a N6 s N1 s)	
N6:			N 	(C6 s 1H6 s 2H6 s)	
1H6 1D6 H61 1H18:	H 	(N6 s)			
2H6 2D6 H62 2H18:	H 	(N6 s)			
N1:			N 	(C6 s C2 s) 
C1:			C	(N1 s 1H1 s 2H1 s 3H1 s)
1H1 1D1 H11:		H	(C1 s)
2H1 2D1 H12:		H	(C1 s)
3H1 3D1 H13:		H	(C1 s)
C2:			C 	(N1 s H2 s N3 a)	
H2 D2:			H 	(C2 s)			
N3:			N 	(C2 a C4 a)		
C4:			C 	(N3 a C5 a N9 a)	
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)			
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)			
O2* O2':		O 	(C2* s HO2 s)		
HO2 DO2 H11:		H 	(O2* s)			
O3* O3':		O 9	(C3* s +4 s)			


;
;	5-Methyl Cytodine
;
[5MC]N*
P:			P 4 	(O1P s O2P s O5* s -9 s)
O1P:			O 	(P s)
O2P:			O 	(P s)
O5* O5':		O 5	(C5* s P s)
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)
O4* O4':		O 	(C4* s C1* s)
C1* C1':		C 	(O4* s H1* s N1 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)
N1:			N 	(C1* s C6 s C2 s)
C6:			C 	(N1 s H6 s C5 d)
H6 D6:			H 	(C6 s)
C5:			C 	(C6 d C5A s C4 s)
C5A:			C 	(C5 s 1H5A s 2H5A s 3H5A s)
1H5A 1D5A H5A1:		H	(C5A s)
2H5A 2D5A H5A2:		H	(C5A s)
3H5A 3D5A H5A3:		H	(C5A s)
C4:			C 	(C5 s N4 s N3 d)
N4:			N 	(C4 s 1H4 s 2H4 s)
1H4 1D4 H41 1H17:	H 	(N4 s)
2H4 2D4 H42 2H17:	H 	(N4 s)
N3:			N 	(C4 d C2 s)
C2:			C 	(N3 s O2 d N1 s)
O2:			O 	(C2 d)
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)
O2* O2':		O 	(C2* s HO2 s)
HO2 DO2 H11:		H 	(O2* s)
O3* O3':		O 9 	(C3* s +4 s)


;
; 2'-O-methyl-cytidine
;
[OMC]N*
P:			P 4 	(O1P s O2P s O5* s -9 s)
O1P:			O 	(P s)
O2P:			O 	(P s)
O5* O5':		O 5	(C5* s P s)
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)
O4* O4':		O 	(C4* s C1* s)
C1* C1':		C 	(O4* s H1* s N1 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)
N1:			N 	(C1* s C6 s C2 s)
C6:			C 	(N1 s H6 s C5 d)
H6 D6:			H 	(C6 s)
C5:			C 	(C6 d H5 s C4 s)
H5 D5 H19:		H 	(C5 s)
C4:			C 	(C5 s N4 s N3 d)
N4:			N 	(C4 s 1H4 s 2H4 s)
1H4 1D4 H41 1H17:	H 	(N4 s)
2H4 2D4 H42 2H17:	H 	(N4 s)
N3:			N 	(C4 d C2 s)
C2:			C 	(N3 s O2 d N1 s)
O2:			O 	(C2 d)
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)
O2* O2':		O 	(C2* s C2A s)
C2A:			C	(O2* s 1H2A s 2H2A s 3H2A s)
1H2A 1D2A H2A1:		H	(C2A s)
2H2A 2D2A H2A2:		H	(C2A s)
3H2A 3D2A H2A3:		H	(C2A s)
O3* O3':		O 9 	(C3* s +4 s)


;
; 1-methyl-guanosine
;
[1MG]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N9 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N9:			N 	(C1* s C8 s C4 s)	
C8:			C 	(N9 s H8 s N7 d)	
H8 D8 H14:		H 	(C8 s)			
N7:			N 	(C8 d C5 s)		
C5:			C 	(N7 s C6 s C4 d)	
C6:			C 	(C5 s O6 d N1 s)	
O6:			O 	(C6 d)			
N1:			N 	(C6 s C1 s C2 s)	
C1A C1:			C	(N1 s 1H1 s 2H1 s 3H1 s)
1H1 1D1 H11:		H	(C1A s)
2H1 2D1 H12:		H	(C1A s)
3H1 3D1 H13:		H	(C1A s)
C2:			C 	(N1 s N2 s N3 d)	
N2:			N 	(C2 s 1H2 s 2H2 s)	
1H2 1D2 H21 1H21:	H 	(N2 s)
2H2 2D2 H22 2H21:	H 	(N2 s)
N3:			N 	(C2 d C4 s)
C4:			C 	(N3 s C5 d N9 s)
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)
O2* O2':		O 	(C2* s HO2 s)
HO2 DO2 H11:		H 	(O2* s)
O3* O3':		O 9 	(C3* s +4 s)

;
;	N2-methyl-guanosine
;
[2MG]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N9 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N9:			N 	(C1* s C8 s C4 s)	
C8:			C 	(N9 s H8 s N7 d)	
H8 D8 H14:		H 	(C8 s)			
N7:			N 	(C8 d C5 s)		
C5:			C 	(N7 s C6 s C4 d)	
C6:			C 	(C5 s O6 d N1 s)	
O6:			O 	(C6 d)			
N1:			N 	(C6 s H1 s C2 s)	
H1 D1 H19:		H 	(N1 s)			
C2:			C 	(N1 s N2 s N3 d)	
N2:			N 	(C2 s H2 s C2A s)	
H2 D2:			H 	(N2 s)
C2A:			C	(N2 s 1H2A s 2H2A s 3H2A s)
1H2A 1D2A H2A1:		H	(C2A s)
2H2A 2D2A H2A2:		H	(C2A s)
3H2A 3D2A H2A3:		H	(C2A s)
N3:			N 	(C2 d C4 s)
C4:			C 	(N3 s C5 d N9 s)
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)
O2* O2':		O 	(C2* s HO2 s)
HO2 DO2 H11:		H 	(O2* s)
O3* O3':		O 9 	(C3* s +4 s)

;
; N2-dimethyl guanosine.
;
[M2G]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N9 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N9:			N 	(C1* s C8 s C4 s)	
C8:			C 	(N9 s H8 s N7 d)	
H8 D8 H14:		H 	(C8 s)			
N7:			N 	(C8 d C5 s)		
C5:			C 	(N7 s C6 s C4 d)	
C6:			C 	(C5 s O6 d N1 s)	
O6:			O 	(C6 d)			
N1:			N 	(C6 s H1 s C2 s)	
H1 D1 H19:		H 	(N1 s)			
C2:			C 	(N1 s N2 s N3 d)	
N2:			N 	(C2 s C2A s C2B s)	
C2A:			C	(N2 s 1H2A s 2H2A s 3H2A s)
1H2A 1D2A H2A1:		H	(C2A s)
2H2A 2D2A H2A2:		H	(C2A s)
3H2A 3D2A H2A3:		H	(C2A s)
C2B:			C	(N2 s 1H2B s 2H2B s 3H2B s)
1H2B 1D2B H2B1:		H	(C2B s)
2H2B 2D2B H2B2:		H	(C2B s)
3H2B 3D2B H2B3:		H	(C2B s)
N3:			N 	(C2 d C4 s)
C4:			C 	(N3 s C5 d N9 s)
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)
O2* O2':		O 	(C2* s HO2 s)
HO2 DO2 H11:		H 	(O2* s)
O3* O3':		O 9 	(C3* s +4 s)
;
; 7-methyl-guanosine.
;
[7MG]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N9 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N9:			N 	(C1* s C8 s C4 s)	
C8:			C 	(N9 s H8 s N7 d)	
H8 D8 H14:		H 	(C8 s)			
N7:			N 	(C8 d C5 s C7 s) 
C7:			C	(N7 s 1H7 s 2H7 s 3H7 s)
1H7 1D7 H71:		H	(C7 s)
2H7 2D7 H72:		H	(C7 s)
3H7 3D7 H73:		H	(C7 s)
C5:			C 	(N7 s C6 s C4 d)	
C6:			C 	(C5 s O6 d N1 s)	
O6:			O 	(C6 d)			
N1:			N 	(C6 s H1 s C2 s)	
H1 D1 H19:		H 	(N1 s)			
C2:			C 	(N1 s N2 s N3 d)	
N2:			N 	(C2 s 1H2 s 2H2 s)	
1H2 1D2 H21 1H21:	H 	(N2 s)
2H2 2D2 H22 2H21:	H 	(N2 s)
N3:			N 	(C2 d C4 s)
C4:			C 	(N3 s C5 d N9 s)
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)
O2* O2':		O 	(C2* s HO2 s)
HO2 DO2 H11:		H 	(O2* s)
O3* O3':		O 9 	(C3* s +4 s)

;
; O-Methyl-Guanosine.
;
[OMG]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N9 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N9:			N 	(C1* s C8 s C4 s)	
C8:			C 	(N9 s H8 s N7 d)	
H8 D8 H14:		H 	(C8 s)			
N7:			N 	(C8 d C5 s)		
C5:			C 	(N7 s C6 s C4 d)	
C6:			C 	(C5 s O6 d N1 s)	
O6:			O 	(C6 d)			
N1:			N 	(C6 s H1 s C2 s)	
H1 D1 H19:		H 	(N1 s)			
C2:			C 	(N1 s N2 s N3 d)	
N2:			N 	(C2 s 1H2 s 2H2 s)	
1H2 1D2 H21 1H21:	H 	(N2 s)
2H2 2D2 H22 2H21:	H 	(N2 s)
N3:			N 	(C2 d C4 s)
C4:			C 	(N3 s C5 d N9 s)
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)
O2* O2':		O 	(C2* s C2A s)
C2A:			C	(O2* s 1H2A s 2H2A s 3H2A s)
1H2A 1D2A H2A1:		H	(C2A s)
2H2A 2D2A H2A2:		H	(C2A s)
3H2A 3D2A H2A3:		H	(C2A s)
O3* O3':		O 9 	(C3* s +4 s)

;
; Inosine
;
[I]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N9 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N9:			N 	(C1* s C8 s C4 s)	
C8:			C 	(N9 s H8 s N7 d)	
H8 D8 H14:		H 	(C8 s)			
N7:			N 	(C8 d C5 s)		
C5:			C 	(N7 s C6 s C4 d)	
C6:			C 	(C5 s O6 d N1 s)	
O6:			O 	(C6 d)			
N1:			N 	(C6 s H1 s C2 s)	
H1 D1 H19:		H 	(N1 s)			
C2:			C 	(N1 s H21 s N3 d)	
H2 D2:			H	(C2 s)
N3:			N 	(C2 d C4 s)
C4:			C 	(N3 s C5 d N9 s)
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)
O2* O2':		O 	(C2* s HO2 s)
HO2 DO2 H11:		H 	(O2* s)
O3* O3':		O 9 	(C3* s +4 s)


;
;Di-hydro-uridine
;
[H2U]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N1 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)			
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)			
O2* O2':		O 	(C2* s HO2 s)		
HO2 DO2 H11:		H 	(O2* s)			
O3* O3':		O 9 	(C3* s +4 s)		
N1:			N 	(C1* s C6 s C2 s)	
C6:			C 	(N1 s 1H6 s 2H6 s C5 s)	
1H6 1D6 H61:		H 	(C6 s)			
2H6 2D6 H62:		H 	(C6 s)			
C5:			C 	(C6 s 1H5 s 1H5 s C4 s)	
1H5 1D5 H51:		H 	(C5 s)			
2H5 2D5 H52:		H 	(C5 s)			
C4:			C 	(C5 s O4 d N3 s)	
O4:			O 	(C4 d)			
N3:			N 	(C4 s H3 s C2 s)	
H3 D3 H16:		H 	(N3 s)			
C2:			C 	(N3 s O2 d N1 s)	
O2:			O 	(C2 d)			

;
; 5-methyl-uridine (ribosylthymidine)
;
[5MU]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N1 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N1:			N 	(C1* s C6 s C2 s)	
C6:			C 	(N1 s H6 s C5 d)	
H6 D6:			H 	(C6 s)			
C5:			C 	(C6 d C5A s C4 s)	
C5A:			C	(C5 s 1H5A s 3H5A s 2H5A s)
1H5A 1D5A H5A1:		H	(C5A s)
2H5A 2D5A H5A2:		H	(C5A s)
3H5A 3D5A H5A3:		H	(C5A s)
C4:			C 	(C5 s O4 d N3 s)	
O4:			O 	(C4 d)			
N3:			N 	(C4 s H3 s C2 s)	
H3 D3 H16:		H 	(N3 s)			
C2:			C 	(N3 s O2 d N1 s)	
O2:			O 	(C2 d)			
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)			
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)			
O2* O2':		O 	(C2* s HO2 s)		
HO2 DO2 H11:		H 	(O2* s)			
O3* O3':		O 9 	(C3* s +4 s)		



;
; Pseudo-uridine
;
[PSU]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s C5 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
N1:			N 	(H1 s C6 s C2 s)	
H1 D1:			H	(N1 s)
C6:			C 	(N1 s H6 s C5 d)	
H6 D6:			H 	(C6 s)			
C5:			C 	(C6 d C1* s C4 s)	
C4:			C 	(C5 s O4 d N3 s)	
O4:			O 	(C4 d)			
N3:			N 	(C4 s H3 s C2 s)	
H3 D3 H16:		H 	(N3 s)			
C2:			C 	(N3 s O2 d N1 s)	
O2:			O 	(C2 d)			
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)			
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)			
O2* O2':		O 	(C2* s HO2 s)		
HO2 DO2 H11:		H 	(O2* s)			
O3* O3':		O 9 	(C3* s +4 s)		
;
; Base "Y" or Wybutosine
;
[YG Y]N*
P:			P 4	(O1P s O2P s O5* s -9 s)	
O1P:			O 	(P s)			
O2P:			O 	(P s)			
O5* O5':		O 5	(C5* s P s)		
C5* C5':		C 6	(O5* s 1H5* s 2H5* s C4* s)
1H5* 1D5* H5'1 1H_5:	H 	(C5* s)			
2H5* 2D5* H5'2 2H_5:	H 	(C5* s)			
C4* C4':		C 7	(C5* s H4* s O4* s C3* s)
H4* D4* H4' H_6:	H 	(C4* s)			
O4* O4':		O 	(C4* s C1* s)		
C1* C1':		C 	(O4* s H1* s N9 s C2* s)
H1* D1* H1' H12:	H 	(C1* s)			
C3* C3':		C 8	(C4* s H3* s C2* s O3* s)
H3* D3* H3' H_8:	H 	(C3* s)			
C2* C2':		C 	(C3* s H2* s O2* s C1* s)
H2* D2* H2' H10:	H 	(C2* s)			
O2* O2':		O 	(C2* s HO2 s)		
HO2 DO2 H11:		H 	(O2* s)			
O3* O3':		O 9 	(C3* s +4 s)		
N9:			N	(C1* s C8 d C4 s)
C8:			C	(N9 d N7 s H8 s)
H8 D8:			H	(C8 s)
N7:			N	(C8 s C5 s H7 s)
H7 D7:			H	(N7 s)
C5:			C	(N7 s C6 s C4 d)
C6:			C	(C5 s O6 d N1 s)
O6:			O	(C6 d)
N1:			N	(C6 s C2 s C12 s)
C2:			C	(N1 s N2 d N3 s)
N2:			N	(C2 d C11 s)
N3:			N	(C2 s C3 s C4 s)
C3:			C	(N3 s 1H3 s 2H3 s 3H3 s)
1H3 1D3 H31:		H	(C3 s)
2H3 2D3 H32:		H	(C3 s)
3H3 3D3 H33:		H	(C3 s)
C4:			C	(N9 s C5 d N3 s)
C10:			C	(C11 s 1H10 s 2H10 s 3H10 s)
1H10 1D10 H101:		H	(C10 s)
2H10 2D10 H102:		H	(C10 s)
3H10 3D10 H103:		H	(C10 s)
C11:			C	(N2 s C10 s C12 d)
C12:			C	(N1 s C11 d C13 s)
C13:			C	(C12 s C14 s 1H13 s 2H13 s)
1H13 1D13 H131:		H	(C13 s)
2H13 2D13 H132:		H	(C13 s)
C14:			C	(C13 s C15 s 1H14 s 2H14 s)
1H14 1D14 H141:		H	(C14 s)
2H14 2D14 H142:		H	(C14 s)
C15:			C	(C14 s C16 s N20 s H15 s)
H15 D15:		H	(C15 s)
C16:			C	(C15 s O17 d O18 s)
O17:			O	(C16 d)
O18:			O	(C16 s C19 s)
C19:			C	(O18 s 1H19 s 2H19 s 3H19 s)
1H19 1D19 H191:		H	(C19 s)
2H19 2D19 H192:		H	(C19 s)
3H19 3D19 H193:		H	(C19 s)
N20:			N	(C15 s C21 s H20 s)
H20 D20:		H	(N20 s)
C21:			C	(N20 s O22 d O23 s)
O22:			O	(C21 d)
O23:			O	(C21 s C24 s)
C24:			C	(O23 s 1H24 s 2H24 s 3H24 s)
1H24 1D24 H241:		H	(C24 s)
2H24 2D24 H242:		H	(C24 s)
3H24 3D24 H243:		H	(C24 s)


;
;
;*****************************************************************************
;*
;*	Templates for other residues
;*
;*****************************************************************************
;
 

;
; Adenosine triphosphate (ATP)
;
[ATP]*
PG:	P	(O1G s O2G s O3G s O3B s)
O1G:	O	(PG s)
O2G:	O	(PG s)
O3G:	O	(PG s)
O3B:	O	(PG s PB s)
PB:	P	(O3B s O1B s O2B s O3A s)
O1B:	O	(PB s)
O2B:	O	(PB s)
O3A:	O	(PB s PA s)
PA:	P	(O3A s O1A s O2A s O5* s)
O1A:	O	(PA s)
O2A:	O	(PA s)
O5*:	O	(PA s C5* s)
C5*:	C	(O5* s C4* s 1H5* s 2H5* s)
1H5*:	H	(C5* s)
2H5*:	H	(C5* s)
C4*:	C	(C5* s O4* s C3* s H4* s)
H4*:	H	(C4* s)
O4*:	O	(C4* s C1* s)
C3*:	C	(C4* s O3* s C2* s 1H3* s)
1H3*:	H	(C3* s)
O3*:	O	(C3* s 2H3* s)
2H3*:	H	(O3* s)
C2*:	C	(C3* s O2* s C1* s 1H2* s)
1H2*:	H	(C2* s)
O2*:	O	(C2* s 2H2* s)
2H2*:	H	(O2* s)
C1*:	C	(C2* s O4* s N9 s H1* s)
H1*:	H	(C1* s)
N9:	N	(C1* s C8 s C4 s)
C8:	C	(N9 s N7 d H8 s)
H8:	H	(C8 s)
N7:	N	(C8 d C5 s)
C5:	C	(N7 s C6 s C4 d)
C6:	C	(C5 s N6 s N1 d)
N6:	N	(C6 s H61 s H62 s)
H61:	H	(N6 s)
H62:	H	(N6 s)
N1:	N	(C6 d C2 s)
C2:	C	(N1 s N3 d H2 s)
H2:	H	(C2 s)
N3:	N	(C2 d C4 s)
C4:	C	(N3 s N9 s C5 d)


;
; Coenzyme A
;
[COA]*
PS1:	S	(PC2 s PH1 s)
PH1:	H	(PS1 s)
PC2:	C	(PS1 s PC3 s PH21 s PH22 s)
PH21:	H	(PC2 s)
PH22:	H	(PC2 s)
PC3:	C	(PC2 s PN4 s PH31 s PH32 s)
PH31:	H	(PC3 s)
PH32:	H	(PC3 s)
PN4:	N	(PC3 s PC5 s PH4 s)
PH4:	H	(PN4 s)
PC5:	C	(PN4 s PO5 d PC6 s)
PO5:	O	(PC5 d)
PC6:	C	(PC5 s PC7 s PH61 s PH62 s)
PH61:	H	(PC6 s)
PH62:	H	(PC6 s)
PC7:	C	(PC6 s PN8 s PH71 s PH72 s)
PH71:	H	(PC7 s)
PH72:	H	(PC7 s)
PN8:	N	(PC7 s PC9 s PH9 s)
PC9:	C	(PN8 s PO9 d PC10 s)
PH9:	H	(PN8 s)
PO9:	O	(PC9 d)
PC10:	C	(PC9 s PO10 s PC11 s PH10 s)
PH10:	H	(PC10 s)
PO10:	O	(PC10 s PH10 s)
PH10:	H	(PO10 s)
PC11:	C	(PC10 s PC12 s PC13 s PC14 s)
PC12:	C	(PC11 s AO6 s 1H12 s 2H12 s)
1H12:	H	(PC12 s)
2H12:	H	(PC12 s)
PC13:	C	(PC11 s 1H13 s 2H13 s 3H13 s)
1H13:	H	(PC13 s)
2H13:	H	(PC13 s)
3H13:	H	(PC13 s)
PC14:	C	(PC11 s 1H14 s 2H14 s 3H14 s)
1H14:	H	(PC14 s)
2H14:	H	(PC14 s)
3H14:	H	(PC14 s)
AO6:	O	(AP2 s PC12 s)
AP2:	P	(AO6 s AO5 s AO4 s AO3 s)
AO5:	O	(AP2 s)
AO4:	O	(AP2 s)
AO3:	O	(AP2 s AP1 s)
AP1:	P	(AO3 s AO1 s AO2 s AO5* s)
AO1:	O	(AP1 s)
AO2:	O	(AP1 s)
AO5*:	O	(AP1 s AC5* s)
AC5*:	C	(AO5* s AC4* s 1H5* s 2H5* s)
1H5*:	H	(AC5* s)
2H5*:	H	(AC5* s)
AC4*:	C	(AC5* s AO4* s AC3* s AH4* s)
AH4*:	H	(AC4* s)
AO4*:	O	(AC4* s AC1* s)
AC3*:	C	(AC4* s AO3* s AC2* s AH3* s)
AH3*:	H	(AC3* s)
AO3*:	O	(AC3* s AP3* s)
AP3*:	P	(AO3* s AO7 s AO8 s AO9 s)
AO7:	O	(AP3* s)
AO8:	O	(AP3* s)
AO9:	O	(AP3* s)
AC2*:	C	(AC3* s O2* s AC1* s AH2* s)
AH2*:	H	(AC2* s)
O2* AO2*:	O	(AC2* s H2* s)
H2*:	H	(O2* s)
AC1*:	C	(AC2* s AO4* s AN9 s AH1* s)
AH1*:	H	(AC1* s)
AN9:	N	(AC1* s AC8 s AC4 s)
AC8:	C	(AN9 s AN7 d AH8 s)
AH8:	H	(AC8 s)
AN7:	N	(AC8 d AC5 s)
AC5:	C	(AN7 s AC6 s AC4 d)
AC6:	C	(AC5 s AN6 s AN1 d)
AN6:	N	(AC6 s AH61 s AH62 s)
AH61:	H	(AN6 s)
AH62:	H	(AN6 s)
AN1:	N	(AC6 d AC2 s)
AC2:	C	(AN1 s AN3 d AH2 s)
AH2:	H	(AC2 s)
AN3:	N	(AC2 d AC4 s)
AC4:	C	(AN3 s AC5 d AN9 s)


;
;Flavin Mononucleotide
;
[FMN]*
N1:	N	(C2 s C10 d)
C2:	C	(N1 s O2 d N3 s)
O2:	O	(C2 d)
N3:	N	(C2 s C4 s H3 s)
H3:	H	(N3 s)
C4:	C	(N3 s O4 d C4A s)
O4:	O	(C4 d)
C4A:	C	(C4 s N5 d C10 s)
N5:	N	(C4A d C5A s)
C5A:	C	(N5 s C6 s C9A d)
C6:	C	(C5A s C7 d H6 s)
H6:	H	(C6 s)
C7:	C	(C6 d C7M s C8 s)
C7M:	C	(C7 s 1H7M s 2H7M s 3H7M s)
1H7M:	H	(C7M s)
2H7M:	H	(C7M s)
3H7M:	H	(C7M s)
C8:	C	(C7 s C8M s C9 d)
C8M:	C	(C8 s 1H8M s 2H8M s 3H8M s)
1H8M:	H	(C8M s)
2H8M:	H	(C8M s)
3H8M:	H	(C8M s)
C9:	C	(C8 d C9A s H9 s)
H9:	H	(C9 s)
C9A:	C	(C9 s C5A d N10 s)
N10:	N	(C9A s C10 s C1* s)
C10:	C	(N10 s C4A s N1 d)
C1*:	C	(N10 s C2* s 1H1* s 2H1* s)
1H1*:	H	(C1* s)
2H1*:	H	(C1* s)
C2*:	C	(C1* s O2* s C3* s 1H2* s)
1H2*:	H	(C2* s)
O2*:	O	(C2* s 2H2* s)
2H2*:	H	(O2* s)
C3*:	C	(C2* s O3* s C4* s 1H3* s)
1H3*:	H	(C3* s)
O3*:	O	(C3* s 2H3* s)
2H3*:	H	(O3* s)
C4*:	C	(C3* s O4* s C5* s 1H4* s)
1H4*:	H	(C4* s)
O4*:	O	(C4* s 2H4* s)
2H4*:	H	(O4* s)
C5*:	C	(C4* s O5* s 1H5* s 2H5* s)
1H5*:	H	(C5* s)
2H5*:	H	(C5* s)
O5*:	O	(C5* s P s)
P:	P	(O5* s OP1 s OP2 s OP3 s)
OP1:	O	(P s)
OP2:	O	(P s)
OP3:	O	(P s)



;
; Methotrexate (amethopterin)
;
; Hydrogens get named with the PDB sequential index of the heavy
; atom to which they are attached.
;
[MTX]*
N1:	N	(C2 a C8A a)
C2:	C	(N1 a NA2 s N3 a)
NA2:	N	(C2 s 1HA2 s 2HA2 s)
1HA2:	H	(NA2 s)
2HA2:	H	(NA2 s)
N3:	N	(C2 a C4 a)
C4:	C	(N3 a NA4 s C4A a)
NA4:	N	(C4 s 1HA4 s 2HA4 s)
1HA4:	H	(NA4 s)
2HA4:	H	(NA4 s)
C4A:	C	(C4 a N5 s C8A a)
N5:	N	(C4A s C6 d)
C6:	C	(N5 d C7 s C9 s)
C7:	C	(C6 s 1H7 s 2H7 s N8 s)
1H7:	H	(C7 s)
2H7:	H	(C7 s)
N8:	N	(C7 s H8 s C8A s)
H8:	H	(N8 s)
C8A:	C	(N1 a C4A a N8 s)
C9:	C	(C6 s 1H9 s 2H9 s N10 s)
1H9:	H	(C9 s)
2H9:	H	(C9 s)
N10:	N	(C9 s CM s C11 s)
CM:	C	(N10 s 1HM s 2HM s 3HM s)
1HM:	H	(CM s)
2HM:	H	(CM s)
3HM:	H	(CM s)
C11:	C	(N10 s C12 a C16 a)
C12:	C	(C11 a H12 s C13 a)
H12:	H	(C12 s)
C13:	C	(C12 a H13 s C14 a)
H13:	H	(C13 s)
C14:	C	(C13 a C15 a C s)
C15:	C	(C14 a H15 s C16 a)
H15:	H	(C15 s)
C16:	C	(C15 a H16 s C11 a)
H16:	H	(C16 s)
C:	C	(C14 s O d N s)
O:	O	(C d)
N:	N	(C s H s CA s)
H:	H	(C s)
CA:	C	(N s HA s CT s CB s)
HA:	H	(CA s)
CT:	C	(CA s O1 a O2 a)
O1:	O	(CA a)
O2:	O	(CA a)
CB:	C	(CA s 1HB s 2HB s CG s)
1HB:	H	(CB s)
2HB:	H	(CB s)
CG:	C	(CB s 1HG s 2HG s CD s)
1HG:	H	(CG s)
2HG:	H	(CG s)
CD:	C	(CG s OE1 a OE2 a)
OE1:	O	(CD a)
OE2:	O	(CD a)



;
; Nicotinamide-Adenine dinucleotide
;
; Hydrogens get named with the PDB sequential index of the heavy
; atom to which they are attached.
;
[NAD]*
AP:	P	(AO1 s AO2 s AO5* s O3 s)
AO1:	O	(AP s)
AO2:	O	(AP s)
AO5*:	O	(AP s AC5* s)
AC5*:	C	(AO5* s AC4* s 1H5 s 2H5 s)
1H5:	H	(AC5* s)
2H5:	H	(AC5* s)
AC4*:	C	(AC5* s AO4* s AC3* s H6 s)
H6:	H	(AC4* s)
AO4*:	O	(AC4* s AC1* s)
AC3*:	C	(AC4* s AO3* s AC2* s H8 s)
H8:	H	(AC3* s)
AO3*:	O	(AC3* s H9 s)
H9:	H	(AO3* s)
AC2*:	C	(AC3* s AO2* s AC1* s H10 s)
H10:	H	(AC2* s)
AO2*:	O	(AC2* s H11 s)
H11:	H	(AO2* s)
AC1*:	C	(AC2* s AO4* s AN9 s H12 s)
H12:	H	(AC1* s)
AN9:	N	(AC1* s AC8 s AC4 s)
AC8:	C	(AN9 s AN7 d H14 s)
AN7:	N	(AC8 d AC5 s)
H14:	H	(AC8 s)
AC5:	C	(AN7 s AC6 s AC4 d)
AC6:	C	(AC5 s AN6 s AN1 d)
AN6:	N	(AC6 s 1H18 s 2H18 s)
1H18:	H	(AN6 s)
2H18:	H	(AN6 s)
AN1:	N	(AC6 d AC2 s)
AC2:	C	(AN1 s AN3 d H20 s)
H20:	H	(AC2 s)
AN3:	N	(AC2 d AC4 s)
AC4:	C	(AN3 s AC5 d AN9 s)
O3:	O	(AP s NP s)
NP:	P	(O3 s NO1 s NO2 s NO5* s)
NO1:	O	(NP s)
NO2:	O	(NP s)
NO5*:	O	(NP s NC5* s)
NC5*:	C	(NO5* s NC4* s 1H28 s 2H28 s)
1H28:	H	(NC5* s)
2H28:	H	(NC5* s)
NC4*:	C	(NC5* s NO4* s NC3* s H29 s)
H29:	H	(NC4* s)
NO4*:	O	(NC4* s NC1* s)
NC3*:	C	(NC4* s NO3* s NC2* s H31 s)
H31:	H	(NC3* s)
NO3*:	O	(NC3* s H32 s)
H32:	H	(NO3* s)
NC2*:	C	(NC3* s NO2* s NC1* s H33 s)
H33:	H	(NC2* s)
NO2*:	O	(NC2* s H34 s)
H34:	H	(NO2* s)
NC1*:	C	(NC2* s NO4* s NN1 s H35 s)
H35:	H	(NC1* s)
NN1:	N	(NC1* s NC2 s NC6 d)
NC2:	C	(NN1 s NC3 d H37 s)
H37:	H	(NC2 s)
NC3:	C	(NC2 d NC7 s NC4 s)
NC7:	C	(NC3 s NO7 d NN7 s)
NO7:	O	(NC7 d)
NN7:	N	(NC7 s 1H41 s 2H41 s)
1H41:	H	(NN7 s)
2H41:	H	(NN7 s)
NC4:	C	(NC3 s NC5 d H42 s)
H42:	H	(NC4 s)
NC5:	C	(NC4 d NC6 s H43 s)
H43:	H	(NC5 s)
NC6:	C	(NC5 s NN1 d H44 s)
H44:	H	(NC6 s)


;   TIP3P water
[HOH DOD WAT WTR H2O OH2]*
O:		O	(H1 s H2 s)			\
				opls	OT	-0.8340	\
				amber	OW	-0.8340	\
				bio+	OT	-0.8340
H1 D1 1H 1D:	H	(O s)				\
				opls	HT	0.4170	\
				amber	HW	0.4170	\
				bio+	HT	0.4170
H2 D2 2H 1D:	H	(O s)				\
				opls	HT	0.4170	\
				amber	HW	0.4170	\
				bio+	HT	0.4170



; Trifluoromethylphenylanilide
[ANI]*
N:		N 1	(-3 s HN s C1 s)
HN DN:	H	(N s)
C1:		C	(N s C2 a C6 a)
C2:		C	(C1 a H2 s C3 a)
H2 D2:		H	(C2 s)
C3:		C	(C2 a H3 s C4 a)
H3 D3:		H	(C3 s)
C4:		C	(C3 a C7 s C5 a)
C5:		C	(C4 a H5 s C6 a)
H5 D5:		H	(C5 s)
C6:		C	(C5 a H6 s C1 a)
H6 D6:		H	(C6 s)
C7:		C	(C4 s F1 s F2 s F3 s)
F1:		F	(C7 s)
F2:		F	(C7 s)
F3:		F	(C7 s)



; Calcium ion
[CA]*
CA:		Ca	()



; Iron/sulphur inorganic cluster
[FES]*
FE1:		Fe	(S1 s S2 s S3 s)
FE2:		Fe	(S1 s S2 s S4 s)
FE3:		Fe	(S1 s S3 s S4 s)
FE4:		Fe	(S2 s S3 s S4 s)
S1:		S	(FE1 s FE2 s FE3 s)
S2:		S	(FE1 s FE2 s FE4 s)
S3:		S	(FE1 s FE3 s FE4 s)
S4:		S	(FE2 s FE3 s FE4 s)



; Magnesium ion with 4 waters
[MO4]*
MG:		Mg	(OB s OC s OD s OF s)
OB:		O	(MG s 1HB s 2HB s)
1HB 1DB HB1:	H	(OB s)
2HB 2DB HB2:	H	(OB s)
OC:		O	(MG s 1HC s 2HC s)
1HC 1DC HC1:	H	(OC s)
2HC 2DC HC2:	H	(OC s)
OD:		O	(MG s 1HD s 2HD s)
1HD 1DD HD1:	H	(OD s)
2HD 2DD HD2:	H	(OD s)
OF OE:		O	(MG s 1HF s 2HF s)
1HF 1DF HF1:	H	(OF s)
2HF 2DF HF2:	H	(OF s)



; Magnesium ion with 5 waters
[MO5]*
MG:		Mg	(OA s OB s OC s OD s OE s)
OA:		O	(MG s 1HA s 2HA s)
1HA 1DA HA1:	H	(OA s)
2HA 2DA HA2:	H	(OA s)
OB:		O	(MG s 1HB s 2HB s)
1HB 1DB HB1:	H	(OB s)
2HB 2DB HB2:	H	(OB s)
OC:		O	(MG s 1HC s 2HC s)
1HC 1DC HC1:	H	(OC s)
2HC 2DC HC2:	H	(OC s)
OD:		O	(MG s 1HD s 2HD s)
1HD 1DD HD1:	H	(OD s)
2HD 2DD HD2:	H	(OD s)
OE:		O	(MG s 1HE s 2HE s)
1HE 1DE HE1:	H	(OE s)
2HE 2DE HE2:	H	(OE s)



; Magnesium ion with 6 waters
[MO6]*
MG:		Mg	(OA s OB s OC s OD s OE s OF s)
OA:		O	(MG s 1HA s 2HA s)
1HA 1DA HA1:	H	(OA s)
2HA 2DA HA2:	H	(OA s)
OB:		O	(MG s 1HB s 2HB s)
1HB 1DB HB1:	H	(OB s)
2HB 2DB HB2:	H	(OB s)
OC:		O	(MG s 1HC s 2HC s)
1HC 1DC HC1:	H	(OC s)
2HC 2DC HC2:	H	(OC s)
OD:		O	(MG s 1HD s 2HD s)
1HD 1DD HD1:	H	(OD s)
2HD 2DD HD2:	H	(OD s)
OE:		O	(MG s 1HE s 2HE s)
1HE 1DE HE1:	H	(OE s)
2HE 2DE HE2:	H	(OE s)
OF:		O	(MG s 1HF s 2HF s)
1HF 1DF HF1:	H	(OF s)
2HF 2DF HF2:	H	(OF s)



; Beta-mercaptopropionate
[MPR]*
CA:		C	(1HA s 2HA s C s CB s)
1HA 1DA HA1:	H	(CA s)			\
				opls	none	\
				bio+	none
2HA 2DA HA2:	H	(CA s)			\
				opls	none	\
				bio+	none
C:		C	(CA s O d)
O:		O	(C d)
CB:		C	(SG s CA s 1HB s 2HB s)
1HB 1DB HB1 HB3:	H	(CB s)		\
				opls	none	\
				bio+	none
2HB 2DB HB2:	H	(CB s)			\
				opls	none	\
				bio+	none
SG:		S	(CB s LP1 s LP2 s)
LP1:		LP	(SG s)			\
				opls	none	\
				bio+	none
LP2:		LP	(SG s)			\
				opls	none	\
				bio+	none


; Phospate ion
[PO4]*
P:		P	(O1 d O2 d O3 d O4 d)
O1:		O	(P d)
O2:		O	(P d)
O3:		O	(P d)
O4:		O	(P d)



; Sulphate ion
[SUL]*
S S1:		S	(O1 d O2 d O3* d O5* d)
O1:		O	(S d)
O2:		O	(S d)
O3* O3:		O	(S d)
O5* O4:		O	(S d)



; Trifluoroacetate
[TFA]*
C:		C	(CT s O d)
O:		O	(C d)
CT CA:		C	(F1 s F2 s F3 s C s)
F1:		F	(CT s)
F2:		F	(CT s)
F3:		F	(CT s)
