/*
 * $Header:   J:/devkit.dos/vcs/srcsmpl/wshout/src/ulisten.c_v   1.3.1.0   26 Apr 1993 18:01:14   rcq  $
 */

/*
 * Filename: ULISTEN.C
 *
 * Copyright (C) 1986-1993 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 10-Apr-90	daveb	Ported from jbvb's 2.04pl1 prod tctest\shout.c.
 * 21-May-90	jog and over to OS/2 without changing a thing; beauteous
 * 25-May-90	jog cleaned up a bit, print how much have written if get 
 *	    error when still writing
 * 13-Jun-90	jog made arg parsing if/else rather than switch/case, 
 *	    cleaned up some more..., prototype main() 
 * 14-Jun-90	jog AF_INET -> PF_INET
 * 06-Jun-90	jog added stdlib.h, string.h
 * 04-Feb-91	jog io.h, data_buffer hold ints, use BUF_SIZE, 
 *	    total_time is "double"
 * 20-Oct-91	gakio	Ported to Windows 3.0
 * 30-Mar-92	gakio	Removed refs to bsd header files, now uses winsock.h
 * 27-Apr-92	gakio	Moved prototype of dll_close() to listen.h
 *			Added init_dll() in order to allow socket dll to 
 *			 track multiple applications.
 * 07-May-92	gakio	Fixed the TCP window going to 0 bug. Added an icon.
 * 30-Jul-92	gakio	Modified for WinsockAPI.
 * 11-Aug-92	gakio	Consolidated with Shout.
 * 26-Aug-92	gakio	Fixed extra char appended to hostname in server mode.
 *			 (replaced wsprintf() with _fmemcpy)
 * 12-Oct-92	gakio	Fixed cast of double to LPSTR in wsprintf.
 * 02-Nov-92	gakio	Replaced sd with local var hSock and moved SOCKET
 *			   global var sd from wshout.h to wshout.c
 * 03-Nov-92	gakio	prbuf's must be referred to as (LPSTR) in wsprintf
 * 03-Nov-92	gakio	Changed double rtemp with long ltemp.
 * 14-Jan-92	gakio	Fixed cancellation of nonblocking recvfrom()
 * 25-Apr-93	rcq	cleaned-up header, removed references to prbufs,
 *			 added MS Headers (that were in wshout.h) and added
 *			 new error message display.
 */

#include "wshout.h"


/* MSC Include files: */
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

/* Returns the number of bytes written */
long UReadData(SOCKET hSock, HWND hOurDlg, int read_len)
{
    static char	ReadBuf[BUF_SIZE];
    static char	SendBuf[512];
    struct sockaddr_in local;	/* Local machine address structure	*/
    int i;			/* General purpose return code		*/
    long total_time = 0L;       /* variable to hold delta t		*/
    int	tmp, len   = 0;
    int	num_reads  = 0;
    long bytes_read = 0L;
    long last_time, now, timeout = 15L;
    long ltemp;
    extern int run_cancelled;

    BOOL bTemp = TRUE;
    
    SetDlgItemText(hOurDlg, IDD_COMMENT, "Awaiting the UDP Data ...");
    SetDlgItemText(hOurDlg, IDD_HNAME, "                      ");
    
    time(&now); time(&last_time);
    while (last_time + timeout > now) {
	time(&now);
	tmp = sizeof(local);
	do {
	    ;
	} while (ShoutBlockingHook()); /* Dispatch messages while available */
	
	if (run_cancelled) {
	    WSASetLastError(WSAEINTR);
	    break;	/* Non-blocking mode was cancelled */
	}
	    
	len = recvfrom(hSock, ReadBuf, read_len, 0, 
	               (struct sockaddr *) &local, &tmp);
	if (len == SOCKET_ERROR) {
	    if (h_errno == WSAEWOULDBLOCK) {/* if no data, read again */
		continue;
	    } /* end: if (errno == WSAEWOULDBLOCK) */
	    else {
		if (bytes_read) {
		    wshout_err (hOurDlg, WSAGetLastError(), "recvfrom()");
		}    
	    } /* end else */
	    break;
	 } /* end: if (len == SOCKET_ERROR) */
	 
	 if (bTemp) {	/* To update our main display once */
	     /* Do not use wsprintf() or you will add an extra char */
	     _fmemcpy(prbuf, inet_ntoa(local.sin_addr), 4*sizeof(u_long));
	     SetDlgItemText(hOurDlg, IDD_HNAME, (LPSTR) prbuf);
	     SetDlgItemText(hOurDlg, IDD_COMMENT, "Reading UDP Data ...");
	     bTemp = FALSE;
	 }
        
	 num_reads++;
	 if (len != SOCKET_ERROR) 
	     bytes_read += len;
	 /* Print the statistics gathered    */
	 wsprintf((LPSTR)prbuf,"%d\n",num_reads);
	 SetDlgItemText(hOurDlg, IDD_WRITE, (LPSTR) prbuf);

	 wsprintf((LPSTR)prbuf,"%ld\n",bytes_read);
	 SetDlgItemText(hOurDlg, IDD_SENT, (LPSTR) prbuf);
		
	 time(&last_time);
     } /* end: while */
     total_time = timeout;
     
     wsprintf((LPSTR)prbuf,"%ld\n",total_time);
     SetDlgItemText(hOurDlg, IDD_TIME, (LPSTR) prbuf);
     
     ltemp = num_reads/total_time;
     wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
     SetDlgItemText(hOurDlg, IDD_WRITES,(LPSTR) prbuf);
     
     ltemp = bytes_read/total_time;
     wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
     SetDlgItemText(hOurDlg, IDD_BYTES, (LPSTR) prbuf);
     
     ltemp = 8 * (bytes_read/total_time);
     wsprintf((LPSTR)prbuf,"%ld\n", ltemp);
     SetDlgItemText(hOurDlg, IDD_BITS,  (LPSTR) prbuf);
     
     if (bytes_read) {
	 SetDlgItemText(hOurDlg, IDD_COMMENT, "...UDP Listen Done\n");
     } /* end: if (bytes_read) */
     else {
	 wsprintf((LPSTR)prbuf, "Timed out. No data received.\n");
	 SetDlgItemText(hOurDlg, IDD_COMMENT, prbuf);
	 goto come_here;
     } /* end: else */
     
     /* send reply to 'client' */
     wsprintf((LPSTR)prbuf,
	 "Replied to %s\n", inet_ntoa(local.sin_addr));
     SetDlgItemText(hOurDlg, IDD_COMMENT, prbuf);
     
     for (i=0; i<10; ++i) {
	 sprintf(SendBuf, "Rec'd %ld bytes.\n", bytes_read);
	 if(len = sendto(hSock, SendBuf, sizeof(SendBuf), 0, 
	                 (struct sockaddr FAR *)&local,sizeof(local)))
	     {
	     if (len == SOCKET_ERROR) { /* if could not send bec. */ 
		 if (h_errno == WSAEWOULDBLOCK) 
		     continue;
		 wshout_err (hOurDlg, WSAGetLastError(), "sendto()");
		 break;
	     } /* end: if (len == -1) */
	 } /* end: if (len = sendto()) */
     } /* end for */
     come_here:
     return (bytes_read);
 }

/* eof */
/*
 * $Log:   J:/devkit.dos/vcs/srcsmpl/wshout/src/ulisten.c_v  $
 * 
 *    Rev 1.3.1.0   26 Apr 1993 18:01:14   rcq
 * added new error message display, updated headers, general cleaning
 * 
 *    Rev 1.3   28 Jan 1993 14:11:10   GAKIO
 * Fixed cancellation of non-blocking recvfrom().
 * 
 *    Rev 1.2   04 Nov 1992 14:28:58   GAKIO
 * Replaced global var sd with local var hSock,
 * Replaced double rtemp with long ltemp,
 * prbuf's referred to as LPSTR in wsprintf.
 * 
 *    Rev 1.1   14 Oct 1992 00:40:04   GAKIO
 * Fixed improper cast of double to LPSTR in wsprint
 * 
 *    Rev 1.0   05 Oct 1992 17:07:40   GAKIO
 * Initial revision.
 * 
 *    Rev 1.1   08 Sep 1992 16:07:12   arnoff
 * gakio	Fixed extra char appended to hostname in server mode.
 * 	 (replaced wsprintf() with _fmemcpy)
 * 
 *    Rev 1.0   26 Aug 1992 12:39:20   arnoff
 *  
 */
