/*
 * $Header:   E:/22vcs/srccmd/wping/wping.h_v   1.8   26 Jan 1993 19:22:22   drew  $
 */

/*
 * SRCCMD/WPING/WPING.H
 *
 * Copyright (C) 1991, 1992, 1993 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * EDIT HISTORY:
 * 25-Oct-91	towfiq	File created.
 * 05-Feb-92	towfiq	Added parameter to change time interval
 * 07-Feb-92	towfiq	Added error-string resource, "Exit" menu choice.
 * 07-Apr-92	towfiq	Split error-string resources for short/long packets.
 * 26-May-92	MPR added defines for help mapping that is language independent
 * 25-Jun-92	MPR prototype for WTNMessageBox
 * 20-Oct-92    MPR added ids_max_ping_conn define
 * 26-Jan-93    drew changed AppWndProc parameter types to match wping.c
 */

/* Windows-oriented ID-number #defines: */

/* String resources: */
#define IDS_APPNAME		0
#define	IDS_NO_RESOLUTION	1
#define	IDS_INTERNAL_ERROR	2
#define	IDS_NO_TIMER		3
#define	IDS_HOSTNAME_ERROR	4
#define	IDS_VERSION		5
#define	IDS_ERROR		6
#define	IDS_BAD_VALUE		7
#define IDS_TOO_LONG		8
#define IDS_TOO_SHORT		9
#define	IDS_BAD_INTERVAL	10
#define IDS_DLL_INIT_FAILED	11
#define IDS_MAX_PING_CONN       12

/*used for help file mapping*/
#define IDS_KEYBOARD    10000
#define IDS_COMMANDS	10001
#define IDS_PROCEDURES	10002

/* Menu items: */
#define IDM_ABOUT		100
#define IDM_EXIT		101
#define IDM_HELP_INDEX		102
#define IDM_HELP_KEYBOARD	103
#define IDM_HELP_COMMANDS	104
#define IDM_HELP_PROCEDURES	105
#define IDM_HELP_HELP		106

/* Buttons: */
#define	IDD_START		200
#define	IDD_STOP		201

/* Edit boxes: */
#define	IDE_HOSTNAME		300
#define	IDE_SIZE		301
#define	IDE_INTERVAL		302

/* Static text items: */
#define	IDT_SENT		400
#define	IDT_RECD		401
#define	IDT_PCT_RECD		402
#define	IDT_AVERAGE_RTT		403
#define	IDT_VERSION		404

/* local function prototypes */

BOOL FAR PASCAL About(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL MainWndProc(HWND, unsigned, WORD, LONG);
void Initialize (void) ;
int ParseCmdLine (LPSTR) ;
int GetIntFromEditBox (HWND, int) ;
void PutLongIntoStaticBox (HWND, int, long) ;
BOOL StartNameres (void) ;
void ToggleItems (BOOL) ;
void StartPinging (void) ;
void StartTimer (void) ;
void StopPinging (void) ;
struct wping DLLFAR *SendPing (long PingP) ;
void Terminate (void) ;
void TryToReceive (void) ;
void TryToResolve (void) ;
void ClearDisplay (void) ;
void UpdateDisplay (void) ;
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                        LPSTR lpszCmdLine, int cmdShow);

void InitApp(HANDLE hInstance, HANDLE hPrevInstance,
                          LPSTR lpszCmdLine, int cmdShow);
void InitAppFirst(HANDLE hInstance);
void InitAppAdded(HANDLE hPrevInstance);
void InitAppEvery(HANDLE hInstance, int cmdShow);
void CloseApp(void);

  /* Change types to match Petzold's, avoid future C7 warnings (drew)*/
long FAR PASCAL AppWndProc(HWND hWnd, UINT message,
                           UINT wParam, LONG lParam);

void InitMainDlg(HWND hWnd);
BOOL FAR PASCAL MainDlgBoxProc(HWND hDlg, WORD message,
                               WORD wParam, LONG lParam);

int WTNMessageBox(WORD wID, WORD MB_flags);

/*
 * $Log:   E:/22vcs/srccmd/wping/wping.h_v  $
 * 
 *    Rev 1.8   26 Jan 1993 19:22:22   drew
 * Changed parameter types of AppWndProc from HWND, WORD, WORD, LONG
 * to be HWND, UINT, UINT, LONG to be more consistent with a WNDPROC.
 * This will also avoid warnings in the future when compiling C700.
 * 
 *    Rev 1.7   20 Oct 1992 17:15:16   mrioux
 * added max_ping_conn define for an additional error message
 * 
 *    Rev 1.6   29 Jun 1992 14:09:02   arnoff
 *  * 25-Jun-92	MPR prototype for WTNMessageBox
 * 
 * 
 *    Rev 1.5   28 May 1992 11:32:16   arnoff
 *  * 26-May-92	MPR added defines for help mapping that is language independent
 * 
 * 
 *    Rev 1.4   07 Apr 1992 18:30:28   arnoff
 * towfiq	Split error-string resources for short/long packets.
 * 
 *    Rev 1.3   24 Feb 1992 22:44:56   arnoff
 * Mark added EXIT
 * 
 *    Rev 1.2   06 Feb 1992 12:00:14   arnoff
 * Added parameters for time interval and date/time of version.
 * 
 *    Rev 1.1   03 Feb 1992 22:22:52   arnoff
 * pre beta-2 testing freeze
 */
