/*
 * $Header:   E:/22vcs/srccmd/wping/wping.c_v   1.20   26 Jan 1993 19:17:46   drew  $
 */

/*
 * SRCCMD/WPING/WPING.C
 *
 * Copyright (C) 1991, 1992, 1993 by FTP Software, Inc., all rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 05-Sep-90	msd	Original author.
 * 15-Apr-91	towfiq	Add options for ping, strip out ECHO
 * 25-Oct-91	towfiq	Did a MAJOR re-org, became more modular.
 * 12-Dec-91	towfiq	Fixed STOP button, clear stats on START.
 * 13-Jan-92	towfiq	Now we create a Window first, then a DlgBox.
 * 24-Jan-92	towfiq	Fixed up how the program exits.
 * 05-Feb-92	towfiq	Added logic for round-trip time.
 * 24-Feb-92	towfiq	Had percentages be rounded off.
 * 07-Apr-92	towfiq	Allowed the max PingLen to be determined by the MTU.
 * 16-Apr-92	MPR	fixed problem with multiple pings to same host hanging
 *			 windows when the last instance was closed. added
 *			 stoppinging() to terminate().
 *			also changed the createwindow call to allow a system
 *			menu for this app. Also Dick's help keyword changes.
 *			Added close help to wm_close so help goes away when
 *			the app does.
 * 26-May-92	MPR 	changed winhelp calls to get context string from .res
 *			 file to assist in national language support
 * 25-Jun-92	MPR 	added WTNMESSAGEBOX functions to output error messages
 *			 in WPINGnnnn: Message format. Also fixed copyright
 *			 notice in the about box
 * 07-Jul-92	MPR 	Checked for presence of a timer, and give error if no
 *			 timers left, change messages for errors to have
 *			 exclamation
 *			Fixed bug with cascading message boxes.
 *			Fixed bug with starting/stopping rapidly.
 * 14-Jul-92	MPR 	fixed alt-tab focus problem by not sending wm_setfocus
 *			messages to the dlg box proc. ARGHHH I LOVE WINDOWS!!!
 * 15-Jul-92	jbvb	Merged MarkT's nm_res_name() change.
 * 22-Jul-92	MPR 	added karen's test for pre 2.1 vxd
 * 31-Jul-92    mpr     fixed bug with 286's when prog UAEd if no kernel
 *                      fixed recurring messageboxes
 * 09-Aug-92	rcq	changed wdllchk.h reference to pctcp/wdllchk.h
 * 29-Sep-92    MPR changed the way the version number was put in the about
 *                  box, use defaults.h
 * 20-Oct-92    MPR made icon flash when iconized, added target to icon name,
 *                  fixed math problem with percent pings, fixed setwindowtext
 *                  so flika went away when iconized
 * 22-Oct-92    MPR added wping4.ico for better animation
 * 26-Jan-93    drew    Added karen's code for WM_SETFOCUS from WFTP to 
 *                       AppWndProc to fix problem of window going inactive
 *                       after Move or Minimize+Restore
 *                      Changed wrong parameter types in AppWndProc definition
 *                       from WORD to UINT to neg future warnings in C700
 *                       and to be more correct
 */

/* wping.exe -- Simple application for PC/TCP under Windows 3.0. */

#include <windows.h>
#include <defaults.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/timeb.h>
#include <pctcp/wdllchk.h>
#include <pctcp/winapp.h>
#include <pctcp/asynch.h>
#if defined(OLD_NAME)
#include <pctcp/dns_lib.h>
#endif
#include "wping.h"

/* data initialized by first instance */
typedef struct tagSETUPDATA
  {
    char szAppName[10];		/* name of application */
  } SETUPDATA;

SETUPDATA SetUpData;

/* phases of application execution */
#define	STARTUP		0	/* nothing happening yet */
#if defined(OLD_NAME)
#define	DNS		1	/* Waiting for DNS response */
#define	DATA		2	/* rcv / send PINGs */
#define	DESTROYED	3	/* under renovation */

struct whostent _far *DnsResponse;
#else
#define	DATA		1	/* rcv / send PINGs */
#define	DESTROYED	2	/* under renovation */
#endif

/* Data that can be referenced throughout the
   program but not passed to other instances */

HANDLE	hInst;			/* current application instance */
HWND	hWndMain;		/* hWnd of main window */
HWND	hDlgBox;		/* application's root window handle */
HMENU	hMenu;
HICON	hIcon ;			/* points to our icon */
FARPROC	lpDlgProc;		/* pointer to proc for modeless box */

/* hostname control structure (in the DLL) */
char	hostname[100];
in_name	address;
int	phase;
int	PingND ;
int	Interval;
long PingsSent = 0;
long PingsReceived = 0;
long TotalRTT = 0;
char PingBuf[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
int	PingLen = sizeof (PingBuf);
/* PING control structure (in the DLL) */
struct wping DLLFAR *PingP = 0;
BOOL is_icon = FALSE;
BOOL frank = FALSE; /*named for kastenholtz who complained about the flicka*/
int ping_count = 0;

/* function bodies */

/*******************************************************************
 * WinMain - first function called
 *
 * parameters:
 *             hInstance     - The instance of this instance of this
 *                             application.
 *             hPrevInstance - The instance of the previous instance
 *                             of this application. This will be 0
 *                             if this is the first instance.
 *             lpszCmdLine   - A long pointer to the command line that
 *                             started this application.
 *             cmdShow       - Indicates how the window is to be shown
 *                             initially. ie. SW_SHOWNORMAL, SW_HIDE,
 *                             SW_MIMIMIZE.
 *
 * returns:
 *             wParam from last message.
 *
 *******************************************************************/
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
  MSG   msg;

  hInst = hInstance;       /* save for use by window procs */

  /* Go init this application. */
  if (check_for_21plus_dll() == FALSE) {
	 /* net_taskinit failed - something wrong with VxD/Kernel */
	 return FALSE;
  }

  /*mpr 31-Jul-92 moved here from initialize(), can't destroy the window*/
  /*in the middle of a function. Sheesh*/
  /* Get string from resource with application name. */
  LoadString(hInstance, IDS_APPNAME, (LPSTR) SetUpData.szAppName, 10);
  if (net_taskInit ((LPSTR) SetUpData.szAppName) < 0) {
	  WTNMessageBox(IDS_DLL_INIT_FAILED, MB_OK | MB_ICONEXCLAMATION) ;
	  return FALSE;
  }

  InitApp (hInstance, hPrevInstance, lpszCmdLine, nCmdShow);

  /* Get and dispatch messages for this application. */
  while (GetMessage (&msg, NULL, 0, 0))
  {
	if (!IsDialogMessage (hDlgBox, &msg))
    {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
	}
  }
//	return msg.wParam;
	return(0);
}

/*******************************************************************
 * InitApp - init the application
 *
 * parameters:
 *             hInstance     - The instance of this instance of this
 *                             application.
 *             hPrevInstance - The instance of the previous instance
 *                             of this application. This will be 0
 *                             if this is the first instance.
 *             lpszCmdLine   - A long pointer to the command line that
 *                             started this application.
 *             cmdShow       - Indicates how the window is to be shown
 *                             initially. ie. SW_SHOWNORMAL, SW_HIDE,
 *                             SW_MIMIMIZE.
 *******************************************************************/
void InitApp (HANDLE hInstance, HANDLE hPrevInstance,
		LPSTR lpszCmdLine, int cmdShow)
{
  if (!hPrevInstance)			/* if this is the first instance */
    InitAppFirst (hInstance);
  else
    InitAppAdded (hPrevInstance);	/* this is not first instance */

#ifdef notdef
  /* Parse the command line */
  if (!ParseCmdLine(lpszCmdLine)) {
    PostQuitMessage(0);
    return FALSE;
  }
#endif

  InitAppEvery (hInstance, cmdShow);	/* initialization for all instances */
}

/*******************************************************************
 * InitAppFirst - done only for first instance of App
 *
 * parameters:
 *             hInstance     - The instance of this instance of this
 *                             application.
 *
 *******************************************************************/
void InitAppFirst(HANDLE hInstance)
{
    WNDCLASS wcAppClass;


    /* Define the window class for this application. */
    wcAppClass.lpszClassName = SetUpData.szAppName;
    wcAppClass.hInstance     = hInstance;
    wcAppClass.lpfnWndProc   = AppWndProc;
    wcAppClass.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wcAppClass.hIcon         = LoadIcon (hInstance, SetUpData.szAppName);
    wcAppClass.lpszMenuName  = (LPSTR) SetUpData.szAppName;
    wcAppClass.hbrBackground = COLOR_WINDOW + 1;
    wcAppClass.style         = CS_HREDRAW | CS_VREDRAW;
    wcAppClass.cbClsExtra    = 0;
    wcAppClass.cbWndExtra    = 0;

    /* Register the class */
    RegisterClass(&wcAppClass);
}

/*******************************************************************
 * InitAppAdded - done only for added instances of the application
 *
 * parameters:
 *             hPrevInstance - The instance of the previous instance
 *                             of this application.
 *
 *******************************************************************/
void InitAppAdded(HANDLE hPrevInstance)
{
  /* get the results of the initialization of first instance */
  GetInstanceData (hPrevInstance, (PSTR) &SetUpData, sizeof(SETUPDATA));
}

/*******************************************************************
 * InitAppEvery - done for every instance of App
 *
 * parameters:
 *             hInstance     - The instance of this instance of this
 *                             application.
 *             cmdShow       - Indicates how the window is to be shown
 *                             initially. ie. SW_SHOWNORMAL, SW_HIDE,
 *                             SW_MIMIMIZE.
 *
 *******************************************************************/
void InitAppEvery(HANDLE hInstance, int cmdShow)
{

  /* Create application's main window. */
  hWndMain = CreateWindow(
		SetUpData.szAppName,	/* window class name */
		SetUpData.szAppName,	/* window title */
		WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX,
		0,			/* x - same as dialog box */
		0,			/* y */
		1,			/* cx */
		1,			/* cy */
		NULL,			/* no parent for this window */
		NULL,                   /* use the class menu */
		hInstance,		/* who created this window */
		NULL			/* no parms to pass on */
		);

  /* Create a thunk for the main dialog box proc function. */
  lpDlgProc = MakeProcInstance (MainDlgBoxProc, hInst);

  InitMainDlg (hWndMain);
}

/*******************************************************************
 * CloseApp - done at termination of every instance of App
 *******************************************************************/
void CloseApp(void)
{
}

/*******************************************************************
 * AppWndProc - handles messages for this application
 *
 * parameters:
 *             hWnd          - The window handle for this message
 *             message       - The message number
 *             wParam        - The WORD parmater for this message
 *             lParam        - The LONG parmater for this message
 *
 * returns:
 *             depends on message.
 *******************************************************************/
LONG FAR PASCAL AppWndProc(HWND hWnd, UINT message,
                           UINT wParam, LONG lParam)
{
  switch (message) {
    case WM_MOVE:
      /* Move the dialog box on top of our main window every
	 time the main window moves. */
      if (IsWindow (hDlgBox))
        SendMessage (hDlgBox, message, wParam, lParam);
      break;

    case WM_SETFOCUS:
      /* This is karen's WFTP code added by drew */
      if (!IsWindow(hDlgBox))
	  break;
      if (IsWindowEnabled(hDlgBox) && IsWindowVisible(hDlgBox)) {
          SendMessage (hDlgBox, message, wParam, lParam);
	  break;
      }
      else if (IsWindowEnabled(hDlgBox) && !IsWindowVisible(hDlgBox)) 
	  return DefWindowProc (hWnd, message, wParam, lParam);

    case WM_CLOSE:
      /* Tell the DlgBox to close, and let it destroy us. */
      WinHelp(hDlgBox, (LPSTR) "wping.hlp", HELP_QUIT, 0L);
      /* make sure help goes away */
      PostMessage (hDlgBox, WM_CLOSE, 0, 0L);
      break;

    case WM_QUERYENDSESSION:
      /* If we return TRUE we are saying it's ok with us to end the
         windows session. */
      return (long) TRUE;	/* we agree to end session. */

    case WM_ENDSESSION:
      /* If wParam is not zero, it meany every application said ok
         to WM_QUERYENDSESSION messages, so we are really ending. */
      if (wParam)		/* if all apps aggreed to end session. */
        /* This is the end. We will not get a WM_DESTROY message on end
	   session. */
        CloseApp ();
      break;

    case WM_DESTROY:
      /* This is the end if we were closed by a DestroyWindow call. */
      CloseApp ();
      PostQuitMessage (0);
      break;

    default:
      return DefWindowProc (hWnd, message, wParam, lParam) ;
  }
  return 0L;
}

/*******************************************************************

/*******************************************************************
 * InitMainDlg - put up modeless dialog box
 *
 * parameters:
 *             hWnd          - The window handle of the caller
 *
 *******************************************************************/
void InitMainDlg (HWND hWnd)
{
  /* Create the dialog box. Its proc is the next function down. */
  CreateDialog (hInst, (LPSTR) SetUpData.szAppName, hWnd, lpDlgProc) ;
}

/*******************************************************************
 * MainDlgBoxProc - handle Main dialog messages (modeless)
 *
 * This is a modeless dialog box procedure that controls this
 * entire application.
 *
 * parameters:
 *             hDlg          - The window handle for this message
 *             message       - The message number
 *             wParam        - The WORD parmater for this message
 *             lParam        - The LONG parmater for this message
 *
 *******************************************************************/
BOOL FAR PASCAL MainDlgBoxProc (HWND hDlg, WORD message,
				WORD wParam, LONG lParam)
{
  int x, y, w, h;
  static RECT wrect;
  FARPROC lpProcAbout;
  char buf[50];

  switch (message) {
  case WM_INITDIALOG:
    /* We don't know our handle yet... */
    hDlgBox = hDlg;

    /* Add the menu in */
    hMenu = LoadMenu (hInst, (LPSTR) SetUpData.szAppName) ;
    if (hMenu != NULL)
      SetMenu (hDlgBox, hMenu) ;

    /* Get position of dialog box window. */
    GetWindowRect (hDlgBox, (LPRECT) &wrect);
    w = wrect.right - wrect.left;
    h = wrect.bottom - wrect.top;

    /* Move main application window to same position. */
    SetWindowPos (hWndMain, hDlgBox, wrect.left, wrect.top, w, h, 0);

    /* Make the main window visible, so the prog shows up in the task list. */
    ShowWindow (hWndMain, SW_SHOWNOACTIVATE) ;

    Initialize ();
    break;

  case WM_MOVE:
    /* Always keep this dialog box on top of main window. */
    GetWindowRect (hWndMain, (LPRECT) &wrect);
    x = wrect.left;
    y = wrect.top;

    /* preserve the size of the dialog box */
    GetWindowRect (hDlgBox, (LPRECT) &wrect);
    w = wrect.right - wrect.left;
    h = wrect.bottom - wrect.top;
    MoveWindow (hDlg, x, y, w, h, 1);
    break;

  case WM_SYSCOMMAND:
    /* Pass WM_SYSCOMMAND messages on to main window so both
       main window and dialog box get iconized, minimized etc.
       in parallel. */
    SendMessage (hWndMain, message, wParam, lParam);
    break;

  case WM_COMMAND:    /* message: command from application menu */
    switch (wParam) {
		char messagebuf[255];

		case IDM_HELP_INDEX:
			WinHelp(hDlg, (LPSTR) "wping.hlp", HELP_INDEX, 0L);
			break;
		case IDM_HELP_KEYBOARD:
			LoadString(hInst, IDS_KEYBOARD, (LPSTR)messagebuf,
				sizeof(messagebuf));
			WinHelp(hDlg, (LPSTR) "wping.hlp", HELP_KEY,
				(LONG)(LPSTR)messagebuf);
			break;
		case IDM_HELP_COMMANDS:
			LoadString(hInst, IDS_COMMANDS, (LPSTR)messagebuf,
				sizeof(messagebuf));
			WinHelp(hDlg, (LPSTR) "wping.hlp", HELP_KEY,
				(LONG)(LPSTR)messagebuf);
			break;
		case IDM_HELP_PROCEDURES:
			LoadString(hInst, IDS_PROCEDURES, (LPSTR)messagebuf,
				sizeof(messagebuf));
			WinHelp(hDlg, (LPSTR) "wping.hlp", HELP_KEY,
				(LONG)(LPSTR)messagebuf);
			break;
		case IDM_HELP_HELP:
			WinHelp(hDlg, (LPSTR)"wping.hlp", HELP_HELPONHELP,0L);
			break;
		case IDM_ABOUT:
			lpProcAbout = MakeProcInstance (About, hInst);
			DialogBox (hInst, "AboutBox", hDlg, lpProcAbout);
			FreeProcInstance (lpProcAbout);
			break;
		case IDM_EXIT:
			/* emulate CLOSE on sysmenu */
			SendMessage (hDlgBox, WM_CLOSE, 0, 0L) ;
			break;
		case IDD_START:
/* First, read the entries of the menu and different edit boxes
into our variables, and go into the mode where the user
can only hit either the STOP button or exit. */
			GetWindowText (GetDlgItem (hDlgBox, IDE_HOSTNAME),
				(LPSTR)hostname, sizeof(hostname));

			PingLen = GetIntFromEditBox (hDlgBox, IDE_SIZE);
			if (PingLen < 18) {
				WTNMessageBox(IDS_TOO_SHORT, MB_OK | MB_ICONEXCLAMATION) ;
				return TRUE;
			}

			Interval = GetIntFromEditBox (hDlgBox, IDE_INTERVAL);
			if (Interval < 1 || Interval > 1000) {
				WTNMessageBox(IDS_BAD_INTERVAL, MB_OK | MB_ICONEXCLAMATION) ;
				return TRUE;
			}

      /* Then, clear the displayed statistics */
      ClearDisplay ();

#if defined(OLD_NAME)	/* Old way of resolving names */
      /* Then, start trying to resolve the name.
         If that succeeds, we can start pinging!
	 This is like an OK button. */
      if (StartNameres ()) {
        ToggleItems (TRUE) ;
	StartTimer () ;
      }
#else	/* Use DLL's nm_res_name() service */
      /* Resolve the name.  If that succeeds, we can start pinging!
       * This is like an OK button.
       */
      ToggleItems (TRUE) ;

      /* Ask DLL to resolve it, however, stash address we get.
      */
      address = nm_res_name (hostname, hostname, sizeof(hostname));
      if (address == 0) {
	WTNMessageBox(IDS_HOSTNAME_ERROR, MB_OK|MB_ICONEXCLAMATION);
        ToggleItems (FALSE);
        phase = STARTUP;
      } else {
        StartTimer ();
	StartPinging();
      }
#endif	/* Which way names are resolved */
      break;

    case IDD_STOP:
      /* Stop sending/receiving pings.  Enable menu items, etc.
         Perhaps put up a final statistics box?  This is like a
	 CANCEL button. */
      if (phase == DATA) { /*MPR 7-7-92 only stop if already getting data*/
	      StopPinging ();
          frank = FALSE; /*to reset window text*/
      }
      break;

    default:
      break;
    }
    break;

  case WM_CLOSE:
    /* We put everything in this function */
    Terminate ();
    break;

  /* These remaining two cases are for retries of the
     reception phase of outstanding network replies
     (of various kinds), as well as sending out new
     pings.  This forestalls permanent death, in the
     event that an asynch event fails to be delivered.
     First, we must make sure the message is for us,
     though... */

  default:
    if (message != net_msgType)
      /* message not for us; let Windows handle it... */
	    return FALSE;
    /* FALL THROUGH.... */

  case WM_TIMER:
    switch (phase) {
    case STARTUP:
      /* Do nothing;  probably a timer tick */
      break;
#if defined(OLD_NAME)
    case DNS:
      /* See if the host response has come in, or if there's an error */
      TryToResolve();
      break;
#endif
    case DATA:
      /* Receive until you can't anymore */
      TryToReceive();
      /* Next, send out another ping, if necessary */
    if (message == WM_TIMER) {
        (void) SendPing ((long) PingP);
        wsprintf( (LPSTR)buf, SetUpData.szAppName, lstrlen(SetUpData.szAppName));
        if ( IsIconic( hWndMain )) { /*change the icon so the pgm looks like its pinging*/
            if ( frank == FALSE ) {
                lstrcat( (LPSTR)buf, " - " );
                lstrcat( (LPSTR)buf, (LPSTR)hostname );
                SetWindowText ( hWndMain, (LPSTR)buf );
                frank = TRUE;
            }
            if ( ping_count == 0 ) {
                SetClassWord( hWndMain, GCW_HICON, LoadIcon (hInst, "WPING1"));
                InvalidateRect( hWndMain, NULL, TRUE );
                UpdateWindow( hWndMain );
                ping_count++;
                break;
            }
            if ( ping_count == 1 ) {
                SetClassWord( hWndMain, GCW_HICON, LoadIcon (hInst, "WPING2"));
                InvalidateRect( hWndMain, NULL, TRUE );
                UpdateWindow( hWndMain );
                ping_count++;
                break;
            }
            if ( ping_count == 2 ) {
                SetClassWord( hWndMain, GCW_HICON, LoadIcon (hInst, "WPING3"));
                InvalidateRect( hWndMain, NULL, TRUE );
                UpdateWindow( hWndMain );
                ping_count++;
                break;
            }
            if ( ping_count == 3 ) {
                SetClassWord( hWndMain, GCW_HICON, LoadIcon (hInst, "WPING4"));
                InvalidateRect( hWndMain, NULL, TRUE );
                UpdateWindow( hWndMain );
                ping_count = 0;
                break;
            }
        } /*isicon*/
        else { /*make sure original icon is re-activated*/
            SetClassWord( hWndMain, GCW_HICON, LoadIcon (hInst, "WPING"));
            InvalidateRect( hWndMain, NULL, TRUE );
            UpdateWindow( hWndMain );
        }
    } /*wm_timer*/
    break;

    case DESTROYED:
    default:
      break;
    }
    /* Finally, update the display */
    break;
  }
  return TRUE;
}

/* This puts up the icon and copyright information */
BOOL FAR PASCAL
About (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
  char szBuffer1[255], szBuffer2[255];

  switch (message) {

  case WM_INITDIALOG:
    /* Set static text item to have date and time of compilation. */
    LoadString (hInst, IDS_VERSION, (LPSTR)szBuffer1, sizeof(szBuffer1)) ;
    lstrcat( szBuffer1, " " );
    wsprintf( szBuffer2, "%d.%d%d", PCTCP_MAJOR, PCTCP_MINOR, PCTCP_PATCH );
    lstrcat( szBuffer2, " - " );
    lstrcat( szBuffer1, szBuffer2 );
    wsprintf (szBuffer2, "%s @ %s", (LPSTR)__DATE__, (LPSTR)__TIME__) ;
    lstrcat( szBuffer1, szBuffer2 );
    SetWindowText (GetDlgItem (hDlg, IDT_VERSION), szBuffer1) ;
    return TRUE;

  case WM_COMMAND:      /* message: received a command */
    switch (wParam) {
    case IDOK:			/* the OK button;  we're done! */
      EndDialog(hDlg, TRUE);	/* Exits the dialog box */
      return TRUE;
    }
    break;
  case WM_CLOSE:
    EndDialog(hDlg, TRUE) ;	/* Exits the dialog box */
    return TRUE;
  }
  return FALSE;    /* Didn't process a message    */
}

void
Initialize(void)
{

  /* default values */
  Interval = 1;
  PingLen = 56;

  /* put defaults into edit boxes */
  PutLongIntoStaticBox (hDlgBox, IDE_INTERVAL, Interval) ;
  PutLongIntoStaticBox (hDlgBox, IDE_SIZE, PingLen) ;

  ToggleItems (FALSE) ;

  phase = STARTUP;
}

int
GetIntFromEditBox(HWND hWindow, int ItemID)
{
      HANDLE handle = GetDlgItem(hWindow, ItemID) ;
      char buffer[100] ;

      GetWindowText (handle, (LPSTR)buffer, sizeof(buffer)) ;
      return atoi(buffer) ;
}

void
PutLongIntoStaticBox(HWND hWindow, int ItemID, long Value)
{
      HANDLE handle = GetDlgItem(hWindow, ItemID) ;
      char buffer[100] ;

      wsprintf(buffer, "%ld", Value);
      SetWindowText (handle, (LPSTR)buffer) ;
}
#if defined(OLD_NAME)	/* Using nm_res_name() instead */
BOOL
StartNameres(void)
{
  if (!(DnsResponse = host_nm_query(hostname, -1))) {
    /* Couldn't resolve hostname--probably not in hosts file */
    StopPinging(); /*mpr 7-6-92*/
    WTNMessageBox(IDS_HOSTNAME_ERROR, MB_OK | MB_ICONEXCLAMATION) ;
    ToggleItems (FALSE) ;
    phase = STARTUP;
    return FALSE;
  }

  /* Register for asynchronous delivery of host resolution reply. */
  if (net_asynchw(DnsResponse->h_nd, NET_AS_RCV, hDlgBox, NET_ASWM_POST) == -1L) {
    /* Couldn't set async--probably out of resources? */
    StopPinging();	 /*mpr 7-6-92*/
    WTNMessageBox(IDS_INTERNAL_ERROR, MB_OK | MB_ICONEXCLAMATION) ;
    ToggleItems (FALSE) ;
    phase = STARTUP;
    return FALSE;
  }
  phase = DNS;
  return TRUE;
}
#endif

/* ToggleItems -- This function turns menu items, buttons, etc. on
   or off, depending on whether we are performing network operations or
   not. */
void
ToggleItems(BOOL bOnOff)
{
  HANDLE hButton;

  /* If bOnOff is TRUE, enable the "Stop" button */
  EnableWindow (GetDlgItem(hDlgBox, IDD_STOP), bOnOff) ;

  /* If bOnOff is TRUE, disable the "Start" button */
  EnableWindow (GetDlgItem(hDlgBox, IDD_START), !bOnOff) ;
  
  if (bOnOff)
    hButton = GetDlgItem (hDlgBox, IDD_STOP) ;
  else
    hButton = GetDlgItem (hDlgBox, IDD_START) ;

  /* Set the button focus to the START button */
  SetFocus (hButton) ;
  SendMessage (hButton, BM_SETSTYLE, (WORD)BS_DEFPUSHBUTTON, 1L) ;
}

void
StartTimer(void)
{
  /* This will allow us to loop periodically checking for 
     hostname timeout or resolution via the host table. */
  if (SetTimer(hDlgBox, 0, 1000, 0) == NULL)
    /* Couldn't set timer--probably out of resources? */
	WTNMessageBox(IDS_NO_TIMER, MB_OK | MB_ICONEXCLAMATION);
/*    complain (IDS_INTERNAL_ERROR, IDS_NO_TIMER) */ ;
}

void
StartPinging(void)
{
  /* Clear stats */
  TotalRTT = 0 ;
  PingsSent = 0;
  PingsReceived = 0;

  /* Create a network descriptor for the PING. */
  if ((PingND = net_getdesc()) < 0)
	  /* complain */
	  ;

  /* Register for asynchronous delivery of PING reply. */
  if (net_asynchw(PingND, NET_AS_RCV, hDlgBox, NET_ASWM_POST) == -1L)
	  /* complain */
	  ;

  /* This is what determines how often the pings are sent */
  if (SetTimer(hDlgBox, 0, Interval * 1000, 0) == NULL)
    /* Couldn't set timer--probably out of resources? */
/*    complain (IDS_INTERNAL_ERROR, IDS_NO_TIMER) */ ;

  /* Initial PING to the designated host. */
  PingP = SendPing ((long) PingND) ;

  /* record that we are in the next phase */
  phase = DATA ;
}

void
StopPinging(void)
{
  icmp_free (PingP) ;
  net_release (PingND) ;
  PingND = -1 ;
  KillTimer (hDlgBox, 0) ;
  ToggleItems (FALSE) ;
  phase = STARTUP ;
}

void
Terminate(void)
{
  /* free the net descriptor */
  
  StopPinging (); /*mpr 4/16/92*/
  
  net_release (PingND) ;

  /* Terminate access to PC/TCP DLL. */
  net_taskDestroy();

  /* Zero handle to this dialog window. */
  hDlgBox = 0;

  /* Tell main window to close. */
  DestroyWindow (hWndMain) ;

  /* Exits the program */
  DestroyWindow (hDlgBox);
}

/* Parse out options and arguments on the command line. */
int
ParseCmdLine (LPSTR lpCmdLine)
{
  return 1;
}
#if defined(OLD_NAME)	/* Not used if nm_res_name() available */
void TryToResolve(void)
{
  int i;

  /* Try to complete hostname resolution. */
  if ((i = host_adnm_rcv(DnsResponse)) < 0) {
    /* Couldn't resolve hostname--probably a timeout */
    StopPinging();	/*mpr 7-6-92*/
    WTNMessageBox(IDS_HOSTNAME_ERROR, MB_OK | MB_ICONEXCLAMATION) ;
    phase = STARTUP;
    ToggleItems (FALSE) ;
    return;
  }

  if (i == 0)
    return;

  /* save address */
  address = DnsResponse->h_addrs[0];

  /* free up the host pointer */
  host_free(DnsResponse);
  DnsResponse = (struct whostent *) 0;
  
  StartPinging() ;
}
#endif

void TryToReceive(void)
{
  int i;

  if ((i = icmp_echo_rcv(PingP, NULL, PingLen, 0, 0)) < 0) {
    if (neterrno == NET_ERR_TIMEOUT) {
      /* complain */
      ;
    } else {
      /* there was an error; stop pinging ... */
      MessageBeep (0) ;
      MessageBox (hDlgBox, (LPSTR)net_errname(), "WPING",
	      MB_OK | MB_ICONSTOP | MB_APPLMODAL) ;
      SendMessage (hDlgBox, WM_COMMAND, IDD_STOP, 0L) ;
    }
  } else if (i > 0) {
    TotalRTT += PingRTT (PingP) ;
    PingsReceived++;
    /* proper reply was seen--update display */
    UpdateDisplay();
  } else
    /* no reply was seen */
    ;
}

struct wping DLLFAR *SendPing(long PingP)
{
  struct wping DLLFAR *retval;

  retval = icmp_echo(PingP, address, NULL, PingLen, 0, 0) ;
  if (retval) {
    PingsSent++;
    UpdateDisplay() ;
  }
  else {		/* there was an ERROR! */
    int save_errnum = neterrno;
    LPSTR save_errstring = (LPSTR)net_errname();

    StopPinging();
    /*restore original icon*/
    SetClassWord( hWndMain, GCW_HICON, LoadIcon (hInst, "WPING"));
    InvalidateRect( hWndMain, NULL, TRUE );
    UpdateWindow( hWndMain );
    /* packet size probably greater than MTU */
    if (save_errnum == NET_ERR_NOMEM) {
	    WTNMessageBox(IDS_TOO_LONG, MB_OK | MB_ICONEXCLAMATION) ;
    }
    /* some other network error */
    else {
      MessageBeep (0);
      if ( save_errnum == NET_ERR_INUSE )
        WTNMessageBox( IDS_MAX_PING_CONN, MB_ICONSTOP | MB_OK ) ;
      else
        MessageBox (hDlgBox, save_errstring, "WPING",
            MB_OK | MB_ICONSTOP | MB_APPLMODAL) ;
    }
  }
  return retval;
}

void ClearDisplay (void)
{
  PingsSent = 0 ;
  PingsReceived = 0 ;
  PutLongIntoStaticBox (hDlgBox, IDT_SENT, 0L) ;
  PutLongIntoStaticBox (hDlgBox, IDT_RECD, 0L) ;
  PutLongIntoStaticBox (hDlgBox, IDT_PCT_RECD, 0L) ;
}

void UpdateDisplay (void)
{
  long percent;
  long AverageRTT;
  HANDLE hnd;
  char buffer[100];

  PutLongIntoStaticBox (hDlgBox, IDT_SENT, PingsSent) ;
  PutLongIntoStaticBox (hDlgBox, IDT_RECD, PingsReceived) ;

  /* avoid divide by zero error */
  if (PingsSent == 0)
    percent = 0;
  else
//    percent = (long)((((double) PingsReceived / (double) PingsSent) + 0.005)
//                                     * 100.0);
    percent = ((1000 * PingsReceived) + 5) / ( 10 * PingsSent );
    hnd = GetDlgItem(hDlgBox, IDT_PCT_RECD) ;
    wsprintf(buffer, "%ld", percent);
    SetWindowText (hnd, (LPSTR)buffer) ;

//  PutLongIntoStaticBox (hDlgBox, IDT_PCT_RECD, percent) ;

  /* avoid divide by zero error */
  if (PingsReceived == 0)
    AverageRTT = 0;
  else
    AverageRTT = TotalRTT / PingsReceived;
  PutLongIntoStaticBox (hDlgBox, IDT_AVERAGE_RTT, AverageRTT) ;
}

/*joel did this for wtnvt, so lets make it a standard*/
/* Called when want to LoadString a string resources that user will see:
 * Given the string resource id of the string:  Load in string, 
 * put " WTNVTwID:  string"  into buf given.
 * (Will not handle string resources where need to load in arguments 
 * into string).
 *
 * Should we have a built in error msg for case where we can't get 
 * string requested??
 */
int  LoadPrefixedString(HANDLE hInst, WORD wID, LPSTR Buffy, int max) {
    char scratch[256];
    
    if (LoadString(hInst, wID, (LPSTR) scratch, max - 10)) {
	wsprintf((LPSTR) Buffy, "WPING%04d: %s", wID, (LPSTR) scratch);
	return (lstrlen(Buffy));
    }
    /* else couldn't get string resource, return 0 like Loadstring would */
	Buffy[0]='\0';
	return (lstrlen(Buffy));
//	  return 0;

}

/* Called when want to display a MessageBox, where the message is
 * a string resource without any variables to be put into it.
 * Load in string, w/ msg number prefix, & MessageBox w/ given flags.
 * (Will not handle string resources where need to load in arguments 
 * into string).
 */
int WTNMessageBox(WORD wID, WORD MB_flags) {
    char buf[256];
    
    if (LoadPrefixedString(hInst, wID, (LPSTR) buf, sizeof(buf))) {
	MessageBeep (0);
	return MessageBox(hWndMain, (LPSTR) buf, "WPING", MB_flags);
    }
    /* else couldn't get string resource, punt */

    return 0;
}

/* eof */

/*
 * $Log:   E:/22vcs/srccmd/wping/wping.c_v  $
 * 
 *    Rev 1.20   26 Jan 1993 19:17:46   drew
 * Added code to handle WM_SETFOCUS message so that the main dialog box
 * does not go inactive when moving or minimizing/restore, etc.  This
 * code was added to AppWndProc, gratefully copied from WFTP and karen.
 * Also changed AppWndProc's parameter types to be UINTs and not WORDs,
 * which will be more consistent and avoid warnings in the switch to C7.
 * 
 *    Rev 1.19   29 Oct 1992 13:39:26   mrioux
 * added 4th icon for animation
 * 
 *    Rev 1.18   20 Oct 1992 17:16:34   mrioux
 * added error message for lack of icmp connections
 * 
 *    Rev 1.17   20 Oct 1992 13:45:54   mrioux
 * got rid of icon flicker when app iconized
 * 
 *    Rev 1.16   20 Oct 1992 11:30:40   mrioux
 * animated icons when iconized, fixed math problem
 * 
 *    Rev 1.15   29 Sep 1992 17:15:52   natalia
 * mpr changed the way the version number was put in the about
 *     box, use defaults.h
 * 
 *    Rev 1.14   26 Aug 1992 22:05:16   arnoff
 * WPING.C
 *  * 09-Aug-92	rcq	changed wdllchk.h reference to pctcp/wdllchk.h
 * 
 * WPING.RC
 * 
 *    Rev 1.13   19 Aug 1992 11:55:50   arnoff
 *  * 31-Jul-92    mpr     fixed bug with 286's when prog UAEd if no kernel
 *  *                      fixed recurring messageboxes
 * 
 *    Rev 1.12   23 Jul 1992 14:07:32   arnoff
 *  * 22-Jul-92	MPR 	added karen's test for pre 2.1 vxd
 * 
 * 
 *    Rev 1.11   15 Jul 1992 11:52:30   jbvb
 * Merge MarkT's changes to use nm_res_name() instead of host_nm_query().
 * 
 *    Rev 1.10   14 Jul 1992 23:53:22   arnoff
 *  * 14-Jul-92	MPR 	fixed alt-tab focus problem by not sending wm_setfocus
 *  *						messages to the dlg box proc. ARGHHH I LOVE WINDOWS!!!
 * 
 * 
 *    Rev 1.9   09 Jul 1992 13:53:50   arnoff
 *  * 07-Jul-92	MPR 	Checked for presence of a timer, and give error if no
 *  *						timers left, change messages for errors to have exclamation
 *  *						Fixed bug with cascading message boxes.
 *  *						Fixed bug with starting/stopping rapidly.
 * 
 * 
 *    Rev 1.8   29 Jun 1992 14:08:14   arnoff
 *  * 25-Jun-92	MPR 	added WTNMESSAGEBOX functions to output error messages
 *  *						in WPINGnnnn: Message format. Also fixed copyright
 *  *						notice in the about box
 * 
 * 
 *    Rev 1.7   28 May 1992 11:31:04   arnoff
 *  * 26-May-92	MPR 	changed winhelp calls to get context string from .res file
 *  *						to assist in national language support
 * 
 * 
 *    Rev 1.6   16 Apr 1992 18:18:14   arnoff
 *  *						Added close help to wm_close so help goes away when the
 *  *						app does.
 * 
 *    Rev 1.5   16 Apr 1992 17:14:12   arnoff
 *  * 16-Apr-92	MPR		fixed problem with multiple pings to same host hanging
 *  *						windows when the last instance was closed. added
 *  *						stoppinging() to terminate().
 *  *						also changed the createwindow call to allow a system
 *  *						menu for this app. Also Dick's help keyword changes.
 * 
 *    Rev 1.4   07 Apr 1992 18:28:08   arnoff
 * towfiq	Allowed the max PingLen to be determined by the MTU.
 * 
 *    Rev 1.3   24 Feb 1992 17:11:08   arnoff
 * Had percentages to be rounded off.  towfiq
 * 
 *    Rev 1.2   06 Feb 1992 11:59:12   arnoff
 * Added support for Round-trip time, removed dead code.
 * 
 *    Rev 1.1   03 Feb 1992 22:22:42   arnoff
 * pre beta-2 testing freeze
 */
