/*
 * $Header:   K:/21vcs/srccmd/samples.win/fmters.c_v   1.3   06 May 1992 16:02:50   arnoff  $
 */

/*
 * Copyright (C) 1991-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 05-Sep-90  msd@ayuda	Original author.
 * 04-Oct-90  msd@ayuda	First pre-release.
 * 01-Apr-91  msd@ayuda	To FTP for 2.05 pl 2 beta.
 * 06-May-92  ftp	DevKit 2.1 beta.
 */

/* "fmters.c" -- Data formatting utility routines used in the simple
    test applications for PC/TCP under Windows 3.x. */

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <pctcp/winapp.h>
#include "fmters.h"


/* Format a printable version of an 48 bit Ethernet address, returning
   a pointer to such a string.
   Note: returns a pointer to a near static buffer. */
char *
pr_eaddr (fEAP)
register char FAR *fEAP;
{
	register int i;
	static char buf[16];

	for (i = 0; i < 6; ++i, ++fEAP)
		wsprintf(&buf[i*2], "%02x", *fEAP & 0xFF);
	return buf;
}

/* Format the errno code into a printable string.
   Note: returns a pointer to a near static buffer. */
char *
pr_errno () {
	char FAR *errstr;
	static char mybuf[64];

	if (errstr = net_errname())
		_fstrncpy(mybuf, errstr, sizeof mybuf - 1);
	else
		wsprintf(mybuf, "Unknown error #%u", neterrno);
	return mybuf;
}

/* Format a printable version of an IP address, in 'dotted' notation,
   returning a pointer to such a string.
   Note: returns a pointer to a near static buffer. */
char *
pr_in_name (in)
in_name in;
{
	union {
		in_name		in;
		unsigned char	b[4];
	} thang;
	static char buf[16];

	thang.in = in;
	wsprintf(buf, "%u.%u.%u.%u", thang.b[0], thang.b[1], thang.b[2]
	  , thang.b[3]);
	return buf;
}

/* Format the suberrno code into a printable string.
   Note: returns a pointer to a near static buffer. */
char *
pr_suberrno () {
	char FAR *errstr;
	static char mybuf[64];

	if (netsuberrno == 0)
		mybuf[0] = '\0';
	else if (errstr = net_suberrname()) {
		strcpy(mybuf, "(");
		_fstrncat(mybuf, errstr, sizeof mybuf - 3);
		strcat(mybuf, ")");
	} else
		wsprintf(mybuf, "(Unknown suberror #%u)", netsuberrno);
	return mybuf;
}

/* eof */

/*
 * $Log:   K:/21vcs/srccmd/samples.win/fmters.c_v  $
 * 
 *    Rev 1.3   06 May 1992 16:02:50   arnoff
 *  * 06-May-92  ftp	DevKit 2.1 beta.
 * 
 *    Rev 1.2   03 Feb 1992 22:00:56   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.1   29 Jan 1992 22:46:50   arnoff
 *  
 */
