/*
 * $Header:   K:/21vcs/srccmd/samples.win/cgarf.c_v   1.3   06 May 1992 16:02:46   arnoff  $
 */

/*
 * Copyright (C) 1991-1992 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * 
 * EDIT HISTORY:
 * 05-Sep-90  msd@ayuda	Original author.
 * 04-Oct-90  msd@ayuda	First pre-release.
 * 01-Apr-91  msd@ayuda	To FTP for 2.05 pl 2 beta.
 * 06-May-92  ftp	DevKit 2.1 beta.
 */

/* "cgarf.c" -- similar to normal C runtime */

#include <stdio.h>
#include <windows.h>
#include "cgarf.h"

/* Local heap version of 'calloc'. */
PSTR
my_calloc (size)
 unsigned size;
{
	 HANDLE hMem;
	 PSTR ptr;

	if ((hMem = LocalAlloc(LMEM_FIXED|LMEM_ZEROINIT, size)) == NULL)
		return (PSTR)0;
	if ((ptr = LocalLock(hMem)) == NULL) {
		LocalFree(hMem);
		return (PSTR)0;
	}
	return ptr;
}

/* Local heap version of 'free'. */
void
my_free (cP)
 void *cP;
{
	LocalFree(LocalHandle((WORD) cP));
}

/* Short version of 'strtol' with FAR pointers for Windows' thing. */
long
wstrtol (fcP, fcPP, radix)
LPSTR fcP, *fcPP;
unsigned radix;
{
	register LPSTR P = fcP;
	register char c;
	int sign = 1;
	long l = 0L;

	if (radix != 10)
		goto done;
	while (*P == '-')
		sign = -sign, ++P;
	while (c = *P++)
		if ('0' <= c  &&  c <= '9')
			l *= 10, l += c - '0';
		else
			break;
done:;
	if (fcPP)
		*fcPP = P;
	return l * sign;
}

/* eof */

/*
 * $Log:   K:/21vcs/srccmd/samples.win/cgarf.c_v  $
 * 
 *    Rev 1.3   06 May 1992 16:02:46   arnoff
 *  * 06-May-92  ftp	DevKit 2.1 beta.
 * 
 *    Rev 1.2   03 Feb 1992 22:00:52   arnoff
 * pre beta-2 testing freeze
 * 
 *    Rev 1.1   29 Jan 1992 22:46:46   arnoff
 *  
 */
