/*
 * ULISTEN.C - Receiving side of UDP test demo.
 *
 * Copyright (C) 1986,1990 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 10-Apr-90	daveb	Ported jbvb's 2.04pl1 prod srccmd\tctest\listen.c.
 * 22-May-90	jog	and over to OS/2, and make UDP server;
 * 04-Jun-90	jog	make it "listen and reply"..., note that doesn't yet
 *			deal properly with multiple remote hosts yelling at it
 * 11-Jun-90	jog	clean up a bit..,  prototype main() declaration
 * 13-Jun-90	jog	use discard socket
 * 14-Jun-90	jog	AF_INET -> PF_INET
 * 06-Jun-90	jog	added stdlib.h, string.h
 * 18-Apr-91	jog	take out extern int errno for dlls
 * 15-May-91	towfiq	Added #include <io.h>
 * 28-Apr-93	rcq	changed "listen" in usage to "ulisten"
 */

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dos.h>		/* Microsoft C DOS defnintions */

/*#include <pctcp.h>*/

/* PC/TCP 4BSD Socket Includes: */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>

static char	read_buf[8192];
static char	send_buf[512];

#define	SOCK_DISCARD	9	/* use the UDP ttytst source port for test */

main(int argc, char *argv[])
{
	struct	sockaddr_in local;/* Local machine address structure */
	int 	sd;		  /* Connection socket descriptor    */
	int 	ret;		  /* General purpose return code     */
	int	tmp, len  = 0;
	int	num_reads = 0;
	long    bytes_read   = 0L;
	long    last_time, now, timeout = 15L;

	if (argc == 2) {
		if (strcmp(argv[1], "-version") == 0) {
			printf("FTP Software, Inc, UDP example \"listen and reply\" program\n");
			exit(0);
		}
	}

	if (argc != 1) {
		puts("usage:  ulisten");
		exit(1);
	}

	/* allocate a network (socket) descriptor */
	sd = socket(PF_INET, SOCK_DGRAM, 0);
	if (sd == -1) {
		perror("socket for listen");
		exit(1);
	}
		
	/* Internet Family addressing; default port to listen on
 	 * Must be in network byte order! (Opposite PC)
	 */
	bzero(&local, sizeof(local));
	local.sin_family = PF_INET;
	local.sin_port = htons(SOCK_DISCARD);

	/* bind socket to an address */
	ret = bind(sd, (struct sockaddr *) &local, sizeof(local));
	if (ret == -1) {
		perror("bind to SHOUT port");
		exit(1);
	}

	last_time = 1; /* use as flag for ioctl call */
	/* put the socket sd in non-blocking mode    */
	tmp = ioctl(sd, FIONBIO, &last_time);
	if (tmp == -1) {
		perror("ioctl");
		exit(1);
	}

	printf("Waiting for data...  ");

	time(&now); time(&last_time);
	/* Now, read the data */
	while (last_time + timeout > now) {
		time(&now);
		num_reads++;
		tmp = sizeof(local);
		len = recvfrom(sd, read_buf, sizeof(read_buf), 0, (struct sockaddr *) &local, &tmp);
		if (len == -1) {
			if (errno == EWOULDBLOCK) /* if no data, read again */
				continue;
			perror("recvfrom");
			if (bytes_read)
				printf("\nError reading; %ld bytes read from %s in %d reads.\n",
					bytes_read, inet_ntoa(local.sin_addr),
					num_reads);
			exit(1);
		}

		printf(".");
		bytes_read += len;
		time(&last_time);
	}

	if (bytes_read)
		printf("\n%ld bytes read from %s in %d reads.\n",
			bytes_read, inet_ntoa(local.sin_addr), num_reads);
	else {
		printf("no data received before timing out\n");
		exit(0);
	}

	/* send reply to 'client' */
	while (1) {
		sprintf(send_buf, "Received %ld bytes of data\n", bytes_read);
		if(len = sendto(sd, send_buf, sizeof(send_buf), 0, &local, sizeof(local))) {
			if (len == -1) { /* if could not send bec. */ 
				if (errno == EWOULDBLOCK) 
					continue;
				printf("\nError sending reply to %s.\n", inet_ntoa(local.sin_addr));
				perror("sendto");
				break;
			}
			printf("\nSent reply to %s\n", inet_ntoa(local.sin_addr));
			break;
		}
	}
	close(sd);
}
