/*
 * $Header:   J:/22vcs/srclib/socket/select.c_v   1.3.1.0   13 Apr 1993 18:37:46   rcq  $
 */

/*
 * SRCLIB/SOCKET/SELECT.C - 4bsd-style select()
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * EDIT HISTORY:
 * 19-Sep-87	romkey	Fixed select() to work correctly with
 *			 descriptors higher than 16. Deleted a couple
 *			 of stupid comments.
 * 29-Sep-87	jbvb	Fix bug in above (sizeof(long) * 8 is # of bits),
 *			 restructure loop, add debugging messages.
 * 15-Oct-87	jbvb	Add delay loop to work around kernel scheduler crock.
 * 20-Jan-88	jbvb	HP wants us to return an error if STREAM connections
 *			 have closed: The only way to obtain this is with
 *			 a probing read on each STREAM socket.  This makes
 *			 the net_select() call sort of redundant.
 * 23-Jan-88	jbvb	Remove delay to test kernel.  It worked.
 * 28-Jan-88	jbvb	Don't return error on dead connection after all:
 *			 just indicate that it is readable.
 * 18-Feb-88	jbvb	Make select() work on more than 16 descriptors.
 * 01-Mar-88	jbvb	Make select() pass correct arguments in large model.
 * 24JAN90	stev	seems to lack my edit histories. hmmm. fix the error
 *			 return in case of a descriptor > 20.
 * 21MAR90	stev	change select() to only deal with 20 selectors, even
 *			 even if passed more, silently. (HGM request)
 * 27-Mar-90	jbvb	Fix above to use #if 0, memcpy not usable w/large data
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 26-Feb-92	paul	removed memory.h and the unused memcpy code
 *			removed unused scratch buffer s_buf
 * 14-Aug-92    rcq     updated the copyright in comments
 * 09-Mar-93	rcq	changed logic at peek read to account to detect 
 *			 connect() completion non-blocking socket
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <errno.h>

#include <pctcp/error.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>

#include <sys/socket.h>
#include <netinet/in.h>

#include <debug.h>

#include "4bsd.h"

/* Socket emulation library select() function.
 *
 * We don't honour the exceptfds field (but neither does Ultrix), we have
 * to do an incredibly elaborate kludge to determine if a connection has
 * closed on us, and we spin on the kernel calls rather than wait for a
 * change in status.  Well, close enough.
 */

int
select(int nfds, fd_set *readfds, fd_set *writefds, 
	fd_set *exceptfds, struct timeval *timeout)
{
	int	nfound, i;
	long	mread, mwrite, mexcept = 0;
	long	tread, twrite, texcept;
	long	allmasks, j;
	struct	timeb	now, then;
	SOCKET	*sp;
	int	maxfd;
	char	c;

#ifdef	DEBUG
	printf("select(nfds = %d, &readfds = %p, &writefds = %p, \
&exceptfds = %p, &timeout = %p)\n",
		nfds, (fd_set far *)readfds, (fd_set far *)writefds,
		(fd_set far *)exceptfds, (struct timeval far *)timeout);
	printf("readfds = %lx, writefds = %lx, exceptfds = %lx\n",
		*readfds, *writefds, *exceptfds);
#endif
#if 0
	if ((nfds < 1) || (nfds > MAXSOCK))
#else
	if (nfds < 1)
#endif
		bomb(EINVAL)	/* fix request by HGM, 24JAN90	*/

			
	maxfd = (nfds > 20 ) ? MAXSOCK - 1 : nfds - 1;

	if(timeout) {
		ftime(&then);
		then.time += timeout->tv_sec;
		if((then.millitm += (timeout->tv_usec / 1000)) >= 1000) {
			then.time++;
			then.millitm -= 1000;
		}
	}

	tread = readfds ? readfds->fds_bits[0] : 0L;
	twrite = writefds ? writefds->fds_bits[0] : 0L;
	texcept = exceptfds ? exceptfds->fds_bits[0] : 0L;
	allmasks = tread | twrite | texcept;


	mread = mwrite = 0;		/* gratis */
	for(;;) {
		net_select(maxfd, &mread, &mwrite);

		/* this may be hairy, but don't laugh,
		 * it works...
		 */
		j = 1;				/* Get initial bitmask */
		for(i = 0; i <= maxfd; ++i) {
		    if (sp = NSOCK(i)) {	/* Get socket (if any) */
			if ((tread & j) &&
			    (STATE(sp) & SI_LISTENING) &&
			    (sp->cur_q_len > 0))
				mread |= j;
			if ((j & allmasks) && (sp->type == STREAM)) {

			    /* do peak read to check connection status */
			    if ((net_read(sp->nd, &c, 1,(struct addr *) NULL,
				 (NET_FLG_PEEK|NET_FLG_NONBLOCKING))) == -1) {
				 
				/* We had an error returned from peak read */ 
				/*  would block == good connection, no data */
			        if (neterrno == NET_ERR_WOULD_BLOCK) {
				    mwrite |= j;  /* its writable! */
				    
				    /* we may not have set this yet */
				    sp->state |= SI_CONNECTED;
				}else if (STATE(sp) & SI_CONNECTED) {
				    mread |= j;		/* readable */
				    mwrite |= j;	/* or writeable */
				    mexcept |= j;	/* or excepted */
				}
			    }
			}
		    }
		    j <<= 1;		/* Bump the bitmask... */
		}
/**		printf("mread = x%lx mwrite = x%lx\r", mread, mwrite);	*/

		/* wipe out descriptors that we aren't interested in.
		 */
		mread &= tread;
		mwrite &= twrite;
		mexcept &= texcept;

		/* if any of the descriptors have fired or we are
		 * doing a non-waiting select, terminate loop.
		 */
		if(mread || mwrite || mexcept) {
#ifdef DEBUG
			printf("break: mread = %lx, mwrite = %lx, mexcept = %lx\n", mread, mwrite, mexcept);
#endif
			break;
		}

		if (timeout != NULL) {
			ftime(&now);
			if ((now.time > then.time) ||
			    ((now.time == then.time) &&
			     (now.millitm >= then.millitm))) {
#ifdef DEBUG
				printf("Select timed out\n");
#endif
				break;			/* timed out - done */
			 }
		}
	}					/* end of infinite for(;;) */

/**	putc('\n', stdout);	*/

	/* report what we've found, if anything...
	 */
	if(readfds)
		readfds->fds_bits[0] = mread;
	if(writefds)
		writefds->fds_bits[0] = mwrite;
	if(exceptfds)
		exceptfds->fds_bits[0] = mexcept;

	/* need to report how many descriptors fired.
	 */
	nfound = 0;
	j = 1;
	for(i = 0; i < (sizeof(long) * 8); i++) {
		if((mread | mwrite | mexcept) & j)
			nfound++;
		j <<= 1;
	}
#ifdef DEBUG
	printf("%d descriptors fired\n", nfound);
#endif
	dreturn(" = %d\n", nfound);
}

/*
 * $Log:   J:/22vcs/srclib/socket/select.c_v  $
 * 
 *    Rev 1.3.1.0   13 Apr 1993 18:37:46   rcq
 * changed to detect incoming connect completion
 * 
 *    Rev 1.3.1.0   09 Apr 1993 15:09:54   rcq
 * changed to detect incoming connect completion
 * 
 *    Rev 1.3   02 Oct 1992 18:58:08   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 15:59:44   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.2   13 Apr 1992 16:09:44   arnoff
 * Removed memory.h and the unused memcpy code
 * Removed unused scratch buffer s_buf
 * 
 *    Rev 1.1   30 Jan 1992 00:51:48   arnoff
 *  
 */
