/*
 * $Header:   J:/devkit.dos/vcs/srclib/socket/src/recv.c_v   1.4.1.1   28 Apr 1993 11:37:18   rcq  $
 */

/*
 * RECV.C - Emulate the 4BSD functions recv() & recvfrom() for PC/TCP.
 *
 * Copyright (C) 1987-1993 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 14-Oct-87	jbvb	Fix minor coding error.
 * 31-Oct-87	jbvb	Allow recvfrom() on STREAM sockets, check "from"
 *			 argument before copying into it.
 * 10-Dec-87	jbvb	Only allow MSG_OOB on STREAM sockets, per CNOdm839.
 *			Don't require DGRAM sockets to be connected, HP #819.
 * 07-Jan-87	jbvb	Return 0 if receiving disabled, rather than ESHUTDOWN
 *			 (fixes HP CNDdm00902).
 *			fromlen argument may be passed as 0.
 * 28-Jan-88	jbvb	Return ENOTCONN for NET_ERR_NOTESTAB (HP #976)
 *			Return ENETRESET for NET_ERR_RESET (TCP gave up).
 * 01-Mar-88	jbvb	Add cast of NULL so right size argument will get
 *			 passed to net_read() in large data models.
 * 24-AUG-88	stev	added ITIMER stuff for use by SNMP.
 * ?? OCT 89	stev	fix the sockaddr_in problem in recv_from()
 * 13-Dec-89	jbvb	Fix warnings on set_option() calls.
 * 25-Jul-90	jbvb	Handle NET_ERR_ICMPMSG & NET_ERR_HOST_UNREACHABLE on
 *			 datagram sockets.
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 25-Feb-92	paul	moved ITIMER_TIMEOUT_VALUE, int_routine here
 *			 from 4bsddefs.h
 * 14-Aug-92    rcq     updated the copyright in comments
 * 26-Aug-92	rcq	deleted default pneterror() call and added cases
 *			for other errors returned (and passed on).
 * 01-Sep-92	rcq	added other errors to recv and recv_from()
 * 27-Apr-93	daveb &	if type stream and not connected checked to see if
 *		arnoff	*really* connected before we bomb.  fixes part of
 *			socktst.
 */

#include <stdio.h>
#include <stdlib.h>

#include <pctcp/error.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/options.h>	/* for ITIMER	*/

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <debug.h>

#include "4bsd.h"

#undef STEV

u_long ITIMER_TIMEOUT_VALUE;
int (*int_routine)();	  

int
recv(int s, char *buf, int len, int flags) 
{
	SOCKET	*sp = NSOCK(s);
	int	iflags;
	int	n;
	long stev;			/* my, the implications . . .	*/

#ifdef	DEBUG
	printf("recv(s = %d, buf = x%Np, len = %d, flags = x%x)",
		s, buf, len, flags);
#endif

	if(sp == NULL || is_netnd(sp->nd))
		bomb(ENOTSOCK);

	if ((sp->type == STREAM) &&		/* If STREAM socket */
	    (!(STATE(sp) & SI_CONNECTED))) {	/*  must be connected. */
		if ((net_read (sp->nd,(char*)0,256,(struct addr*)0,
		    NET_FLG_NONBLOCKING|NET_FLG_PEEK) == -1) &&
		    ((neterrno == NET_ERR_NOTESTAB) ||
		    (neterrno == NET_ERR_NOTNETCONN) ||
		    (neterrno == NET_ERR_UNBOUND))) {
			bomb(ENOTCONN);
		} else sp->state |= SI_CONNECTED;
	}
	if(! (STATE(sp) & SI_CAN_RECV))
		return(0);			/* Return 0 to indicate EOF */

	/* Figure out the flags to pass, translating caller's from 4BSD
	*/
	iflags = SOPTIONS(sp);			/* Get basic socket options */

	if (flags & MSG_OOB) {			/* Was OOB specified? */
		if (sp->type == STREAM)		/* Legal for TCP */
			iflags |= NET_FLG_OOB;
		else
			bomb(EOPNOTSUPP);	/* Not otherwise */
	}
	if (flags & MSG_PEEK) {			/* Was PEEK specified? */
		iflags |= NET_FLG_PEEK;
		iflags &= ~NET_FLG_NONBLOCKING;	/* Clear so we get data */
	}

	if (ITIMER_TIMEOUT_VALUE)  {
	    stev = ITIMER_TIMEOUT_VALUE * 1000L;
	    set_option(sp->nd, DGRAM, NET_OPT_TIMEOUT, (char far *)stev,
		    sizeof(long));
#ifdef STEV
	    printf("DEBUG: just set the timeout to %ld / %u returned %d\n",\
		stev,ITIMER_TIMEOUT_VALUE,dab);
#endif /*STEV*/	    
	}
	if((n = net_read(sp->nd,buf,len,(struct addr *)NULL,iflags)) == -1)
		switch(neterrno) {
		case NET_ERR_ICMPMSG:		/* Various fatal ICMP errs */
		case NET_ERR_RESET:		/* Conventional TCP RST */
			bomb(ENETRESET);	/* Kernel dropped it */
		case NET_ERR_WOULD_BLOCK:
			bomb(EWOULDBLOCK);
		case NET_ERR_NOTESTAB:
			bomb(ENOTCONN);		/* Per HP #976 */
		case NET_ERR_EOF:
			n = 0;
			break;
/* this return should *only* appear if the timeout was set above, *so*,	*/
/* i dont have to check to make sure this routine isnt NULL, why do i 	*/
/* fear i will be back here later checking for NULL:)			*/
		case NET_ERR_TIMEOUT:
			(*int_routine)();
			bomb(EINTR);
			break;
		case NET_ERR_HOST_UNREACHABLE:
			bomb(EHOSTUNREACH);	/* Could be elaborated using*/
			break;			/*  "sub" net error codes?? */
		case NET_ERR_NET_UNREACHABLE:
			bomb(ENETUNREACH);
			break;
		case NET_ERR_NOQIOS:            /* No Qued I/O Control Blks */
		        bomb(ENOBUFS);		/*  innocuous, needs retry */
			break;
		case NET_ERR_UNBOUND:
		case NET_ERR_NOTNETCONN:        
		        bomb(ENOTCONN);		/* not a connection */
			break;
		case NET_ERR_EMM:		
		case NET_ERR_WOULD_TRUNCATE:
		default:
			bomb(-1);		/* inequivalent errors */
		}

	dreturn(" = %ld\n", n);
}

int
recvfrom(int s, char *buf, int len, int flags, 
	struct sockaddr *from_passed, int *fromlen)
/* s		socket			*/
/* buf		buffer ponter		*/
/* len		buffer's length 	*/
/* from_passed	May be NULL 		*/
{
	SOCKET			*sp = NSOCK(s);
	ADDR			na;
	int			iflags;
	int			n;
	long			stev;		/* needed for ltoa() 	*/
	struct sockaddr_in	*from;		/* May be NULL 		*/


	from = (struct sockaddr_in *) from_passed;
#ifdef	DEBUG
	printf("recvfrom(s = %d, buf = x%Np, len = %d, flags = x%x, from = x%Np, *fromlen = %d)",
		s, buf, len, flags, from, *fromlen);
#endif

	if(sp == NULL || is_netnd(sp->nd))
		bomb(ENOTSOCK);

	if(! (STATE(sp) & SI_BOUND))
		bomb(EINVAL)			/* PAP's macro */
	else if(! (STATE(sp) & SI_CAN_RECV))
		return(0);			/* Return 0 to indicate EOF */

	/* Figure out the flags to pass, translating caller's from 4BSD
	*/
	iflags = SOPTIONS(sp);			/* Get basic socket options */

	if (flags & MSG_OOB) {			/* Was OOB specified? */
		if (sp->type == STREAM)		/* Legal for TCP */
			iflags |= NET_FLG_OOB;
		else
			bomb(EOPNOTSUPP);	/* Not otherwise */
	}
	if (flags & MSG_PEEK) {			/* Was PEEK specified? */
		iflags |= NET_FLG_PEEK;
		iflags &= ~NET_FLG_NONBLOCKING;	/* Clear so we get data */
	}

	if (ITIMER_TIMEOUT_VALUE)  {
	    stev = ITIMER_TIMEOUT_VALUE * 1000L;
	    set_option(sp->nd, DGRAM, NET_OPT_TIMEOUT, (char far *)stev,
		    sizeof(long));
#ifdef STEV
	    printf("DEBUG: just set the timeout to %ld / %u returned %d\n",\
		stev,ITIMER_TIMEOUT_VALUE,dab);
#endif /*STEV*/	    
	    }
	if((n = net_read(sp->nd, buf, len, &na, iflags)) == -1) {
		switch(neterrno) {
		case NET_ERR_ICMPMSG:		/* Various fatal ICMP errs */
		case NET_ERR_RESET:		/* Conventional TCP RST */
			bomb(ENETRESET);	/* Kernel dropped it */
		case NET_ERR_WOULD_BLOCK:
			bomb(EWOULDBLOCK);
		case NET_ERR_NOTESTAB:
			bomb(ENOTCONN);		/* Per HP #976 */
		case NET_ERR_EOF:
			n = 0;
			break;
/* this return should *only* appear if the timeout was set above, *so*,	*/
/* i dont have to check to make sure this routine isnt NULL, why do i 	*/
/* fear i will be back here later checking for NULL:)			*/
		case NET_ERR_TIMEOUT:
			(*int_routine)();
			bomb(EINTR);
			break;
		case NET_ERR_HOST_UNREACHABLE:
			bomb(EHOSTUNREACH);	/* Could be elaborated using*/
			break;			/*  "sub" net error codes?? */
		case NET_ERR_NET_UNREACHABLE:
			bomb(ENETUNREACH);
			break;
		case NET_ERR_NOQIOS:            /* No Qued I/O Control Blks */
		        bomb(ENOBUFS);		/*  innocuous, needs retry */
			break;
		case NET_ERR_UNBOUND:
		case NET_ERR_NOTNETCONN:
		        bomb(ENOTCONN);		/* not a connection */
			break;
		case NET_ERR_EMM:		
		case NET_ERR_WOULD_TRUNCATE:
		default:
			bomb(-1);		/* inequivalent errors */
		}
#if 0	/* not expected berkeley behavior, the application should reset	*/
	/* the timeout							*/
	if (ITIMER_TIMEOUT_VALUE)  {
	    set_option(sp->nd, DGRAM, NET_OPT_TIMEOUT, (char far *)0L,
		    sizeof(long));
#ifdef STEV
	    printf("DEBUG: just set the timeout to 0 / %u returned %d\n",\
		ITIMER_TIMEOUT_VALUE,dab);
#endif /*STEV*/	    
	    }
#endif /*0*/
	}

	if (from) {				/* may be NULL */
		from->sin_family = AF_INET;
		from->sin_port = htons(na.fsocket);
		from->sin_addr.s_addr = na.fhost;

		*fromlen = sizeof(*from);
	}

	dreturn(" = %ld\n", n);
}


/*
*sigh*
*/

void
interupt_signal(int nothing, int (*routine)())  
{
    int_routine = routine;
}


/*
 * $Log:   J:/devkit.dos/vcs/srclib/socket/src/recv.c_v  $
 * 
 *    Rev 1.4.1.1   28 Apr 1993 11:37:18   rcq
 * removed the recvfrom() NET_ERR_NOTESTAB added since it was a duplicate
 * 
 *    Rev 1.4.1.0   28 Apr 1993 09:43:34   arnoff
 *  * 27-Apr-93	daveb &	if type stream and not connected checked to see if
 *  *		arnoff	*really* connected before we bomb.  fixes part of
 *  *			socktst.
 *  * 28-Apr-93	rcq & arnoff	added check for NET_ERR_NOTESTAB in recvfrom().
 * 
 *    Rev 1.4   02 Oct 1992 18:57:42   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 15:58:14   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 *  * 26-Aug-92	rcq	deleted default pneterror() call and added cases
 *  *			for other errors returned (and passed on).
 * 
 *    Rev 1.2   13 Apr 1992 16:08:48   arnoff
 * Moved ITIMER_TIMEOUT_VALUE, int_routine here from 4bsddefs.h
 * 
 *    Rev 1.1   30 Jan 1992 00:51:44   arnoff
 *  
 */
