/*
 * $Header:   J:/22vcs/srclib/socket/ioctl.c_v   1.4   10 Nov 1992 11:00:26   rcq  $
 */

/*
 * IOCTL.C - Emulate 4BSD ioctl() function for PC/TCP.
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 14-Oct-87	jbvb	Minor cleanup, fixing comments.
 * 14-Dec-87	jbvb	Correct declaration of argument for FIONBIO
 * 14-Jan-88	jbvb	Romkey requires *exactly* NET_FLG_PEEK and
 *			 NET_FLG_NONBLOCKING for net_read() to return
 *			 number of pending characters.  Fixes HP #884.
 * 20-Jan-88	jbvb	Convert NET_ERR_NOTESTAB into ENOTSOCK, for HP #859.
 * 01-Mar-88	jbvb	Add cast of NULL so net_read() will get passed the
 *			 right size pointer in large data models.
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92	rcq	updated copyright in comments
 * 09-Sep-92	rcq	printf() only if DEBUGging
 * 23-Sep-92	rcq	now calls set_option to make blocking/non-blocking
 *			in addition to setting option flag.
 *		        Made ioctl() compatible with Borland's (made it take
 *			variable # args, pass-thru if not a descriptor and
 *			if Borland in use ...otherwise return ENOTSOCK).
 *			Also fixed some bogus casts, set return, got rid
 *			of net_read() error printing
 * 04-Oct-92	rcq	replaced panic() with return(-1)
 * 02-Nov-92	rcq	call set_option() with non-block *value* not ptr!
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>   /* to handle variable # of function arguments */

#include <pctcp/error.h>
#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/error.h>
#include <pctcp/options.h>

#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>

#include <debug.h>

#include "4bsd.h"

/* ioctl -- i/o control. */
int
bsd_ioctl(int fd, int request, ...)
{
	SOCKET	*sp = NSOCK(fd);
	int	bytes_waiting;
	char    *argp;
	va_list	argptr;

#ifdef	DEBUG
	printf("ioctl(fd = %d, request = x%x, argp = x%x)",
		fd, request, argp);
#endif

	if(sp == NULL || is_netnd(sp->nd)) {
#ifdef __TURBOC__
#undef ioctl
		ioctl (fd, request, argp);  /* Call Borland's ioctl() */
#else    
		bomb(ENOTSOCK);             /* If MSC, return error */
#endif	    
	}
	
	/* Get argp value from 3rd parameter ...if given */
	va_start(argptr, request);
	argp = va_arg(argptr, char *);
	va_end(argptr);

	switch(request) {
	case FIONREAD:
		if(argp == (char *)0)    /* 3rd argument required */
			bomb(EFAULT);

		bytes_waiting = net_read(sp->nd, (char *) NULL, -1, 
		    (struct addr *) NULL,NET_FLG_PEEK | NET_FLG_NONBLOCKING);

		*argp = (char) 0;
		if(bytes_waiting >= 0) 
			*argp = (char) bytes_waiting;
		else if (neterrno == NET_ERR_NOTESTAB)
			bomb(ENOTSOCK)
		else if (neterrno != NET_ERR_WOULD_BLOCK) 
			bomb(EFAULT); /* Some unexpected error */
		break;
	case FIONBIO:			
		if(argp == (char *)0)   /* 3rd argument required */
			bomb(EFAULT);   /* (its a pointer to a flag) */

	        /*  (if argp value non-zero, socket becomes NON-blocking) */
		if (set_option(sp->nd,sp->type,
		    NET_OPT_NONBLOCKING,(char far *)*argp,0) == -1) {
		/* panic("ioctl: set_option %d\n", neterrno); */
		    return (-1);
		}
		if(*argp) {
			SOPTIONS(sp) |= NET_FLG_NONBLOCKING;
		}
		else {
			SOPTIONS(sp) &= ~NET_FLG_NONBLOCKING;
		}
		*argp = (char)0;
		break;
	case FIOASYNC:
#ifdef DEBUG	    
		printf("ioctl: FIOASYNC: asynch not implemented.\n");
#endif
	default:
#ifdef DEBUG	    
		printf("ioctl: request x%x not implemented\n", request);
#endif	    
		bomb(EINVAL);
	}
	dreturn(" = %d\n", *argp);
}

/*
 * $Log:   J:/22vcs/srclib/socket/ioctl.c_v  $
 * 
 *    Rev 1.4   10 Nov 1992 11:00:26   rcq
 * call set_option with *value* not pointer
 * 
 *    Rev 1.3   04 Oct 1992 12:54:58   rcq
 * replaced panic() with return (-1)
 * 
 *    Rev 1.2   02 Oct 1992 18:56:24   rcq
 * ioctl.new
 * 
 *    Rev 1.1   30 Jan 1992 00:51:32   arnoff
 *  
 */
