/*
 * $Header:   J:/22vcs/srclib/socket/inet.c_v   1.3   02 Oct 1992 18:55:34   rcq  $
 */

/*
 * INET.C - Internet number manipulation for PC/TCP socket library
 *
 * Copyright (C) 1987-1992 by FTP Software, Inc.  All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 24-Jan-88	jbvb	Removed inet_ntoa(), to put in NETLIB for wider use.
 * 22MAR90	stev	changed inet_addr() to conform to 4.3BSD.
 * 07-Nov-91	paul	changed to new-style function declarators,
 *			added function return types,
 *			changed forever loops from while(1) to for(;;)
 * 14-Aug-92    rcq     updated the copyright in comments
 */

#include <pctcp/error.h>
#include <pctcp/types.h>

#include <sys/types.h>
#include <netinet/in.h>

#define	AMASK	0x80
#define	AADDR	0x00
#define	APART	0xff000000L
#define	ASHIFT	24
#define	BMASK	0xc0
#define	BADDR	0x80
#define	BPART	0xffff0000L
#define	BSHIFT	16
#define	CMASK	0xe0
#define	CADDR	0xc0
#define	CPART	0xffffff00L
#define	CSHIFT	8

unsigned long
inet_addr(char *s)
{
	u_long	a, n, mask;
	int	dots, digs, shft;

	mask = ~0;
	a = 0;
	shft = 32;
	for(dots = 0; dots < 4; ++dots, ++s) {
		for(n = digs = 0; '0'<= *s && *s <= '9'; ++s, ++digs)
			n = n * 10 + *s - '0';

		if(! digs)
			return((unsigned long )-1);

		if(! *s)
			shft = 0;
		else
			shft -= 8;

		a |= (n & mask) << shft;
		mask >>= 8;

		if(*s != '.')
			break;
	}
	if(dots < 1 || dots > 3 || *s)
		a = ~0;
	
	return(htonl(a));

}

/* you would think this code converts the result back into network
 * byte order before returning it.  no...  lose.
 */

u_long
inet_netof(struct in_addr in)
{
	u_long	r = ntohl(in.s_addr);

	if(((r >> 24) & AMASK) == AADDR)
		r >>= ASHIFT;
	else if(((r >> 24) & BMASK) == BADDR)
		r >>= BSHIFT;
	else
		r >>= CSHIFT;
	return(r);
}

/* likewise, this is brain-damaged too...
 */

u_long
inet_lnaof(struct in_addr in)
{
	u_long	r = ntohl(in.s_addr);

	if(((r >> 24) & AMASK) == AADDR)
		r &= ~APART;
	else if(((r >> 24) & BMASK) == BADDR)
		r &= ~BPART;
	else
		r &= ~CPART;
	return(r);
}

/* ah, sanity at last!
 */

struct in_addr
inet_makeaddr(long net, long lna)
{
	struct in_addr	r;

	if(net < 0x80)
		r.s_addr = (net << ASHIFT) | lna;
	else if(net < 0x10000L)
		r.s_addr = (net << BSHIFT) | lna;
	else
		r.s_addr = (net << CSHIFT) | lna;
	r.s_addr = htonl(r.s_addr);
	return(r);
}

/*
 * $Log:   J:/22vcs/srclib/socket/inet.c_v  $
 * 
 *    Rev 1.3   02 Oct 1992 18:55:34   rcq
 * merged changes done in 2.1
 * 
 *    Rev 1.3   27 Aug 1992 15:54:32   arnoff
 *  * 14-Aug-92    rcq     updated the copyright in comments
 * 
 *    Rev 1.2   13 Apr 1992 16:06:08   arnoff
 * Added 'L' to long constants
 * 
 *    Rev 1.1   30 Jan 1992 00:51:26   arnoff
 *  
 */
